
#ifndef __PACLIST_H_INCLUDED_
#define __PACLIST_H_INCLUDED_ 1

#include <stdbool.h>
#include <pthread.h>
#include <limits.h> /* PATH_MAX, NAME_MAX */

#define PAC_NAME_MAX 256
#define PACS_NEED_AMOUNT_MAX 256
#define ROLE_NAME_MAX 256
#define ROLE_PRESET_AMOUNT_MAX 10
#define ROLE_OPTIONAL_AMOUNT_MAX 10

typedef struct {
	char name[PAC_NAME_MAX+1];
} pac_need;

typedef struct {
	char name[PAC_NAME_MAX];
	pac_need *needs[PACS_NEED_AMOUNT_MAX];
	int num_needs;
	double version;
} pacinfo;

typedef struct pac_struct {
	/* ľ󥯥ꥹ */
	/* ǽΥΡɤüpac "_LAST" */
	struct pac_struct *next;  /* 󥯥ꥹȼpac */ /* get_paclist()ǥå */
	struct pac_struct *prev;  /* 󥯥ꥹpac */ /* get_paclist()ǥå */
	pacinfo info;
	char  dirname[NAME_MAX+1];  /* ǥ쥯ȥ̾(pac̾) */ /* get_paclsit()ǥå */
	struct pac_struct *need[PACS_NEED_AMOUNT_MAX];  /* pacɬפȤƤpac */ /* resolve_dependency()ǥå üNULL */
	char in_role_path[PATH_MAX+1];  /* pacäƤroleؤpath */ /* find_paclsit_in_role()ǥå üNULL */
	enum {No=0, Yes=1, YesButNotInRole=2, Special=3} use;  /* ŬѤ뤫ݤ */ /* find_paclist_in_role()ǥåȤresolve_dependency()ɲäǥåȡapply_paclist() */
	bool resolved;  /* ¸طѤߤݤ */ /* resolve_dependency() */
	int resolve_count; /* ¸ط襫 */ /* resolve_dependency() */
	bool applied;  /* ŬѺѤߤݤ */ /* apply_paclist() */
	pthread_mutex_t applied_mutex;  /* appliedСmutex */ /* apply_paclist() */
	pthread_cond_t applied_cond;  /* appliedСcond */ /* apply_paclist() */
} pac;

void initialize_pac(pac *pac);
pac* paclist_initialize(void);
void paclist_clean(pac *cue);
int paclist_count(const pac* cue);
void paclist_addpac(pac *cue, pac *new_pac);
void paclist_delpac(pac *del_pac);
pac* paclist_search_by_dirname(pac *cue, const char *key);
pac* paclist_search_by_name(pac *cue, const char *key);

#endif /* paclist.h */
