/*
    accel
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MISC_ACCEL_H__
#define __MISC_ACCEL_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MISC_TYPE_ACCEL            (misc_accel_get_type ())
#define MISC_ACCEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), MISC_TYPE_ACCEL, MiscAccel))
#define MISC_ACCEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), MISC_TYPE_ACCEL, MiscAccelClass))
#define MISC_IS_ACCEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MISC_TYPE_ACCEL))
#define MISC_IS_ACCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MISC_TYPE_ACCEL))
#define MISC_ACCEL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), MISC_TYPE_ACCEL, MiscAccelClass))


typedef struct _MiscAccel      MiscAccel;
typedef struct _MiscAccelClass MiscAccelClass;


struct _MiscAccel
{
  /*< private >*/
  GObject    parent;

  /*< public >*/

  /*< private >*/
  gulong         handler_destroy;
  gulong         handler_key_press;
  GSList        *gslist;
  GtkAccelGroup *accel_group;
  GtkWindow     *window;
};
struct _MiscAccelClass
{
  GObjectClass parent_class;
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
misc_accel_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:アクセラレータ関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
         window,ウインドウ
    accel_group,アクセルグループ
            RET,オブジェクト                                                */
GObject*
misc_accel_new (void);


/*  ja:ウインドウを取得する
    accel,オブジェクト
      RET,ウインドウ                                                        */
#define misc_accel_get_window(accel) (MISC_ACCEL(accel)->window)


/*  ja:ウインドウを設定する
     accel,オブジェクト
    window,ウインドウ                                                       */
void
misc_accel_set_window (MiscAccel *accel,
                       GtkWindow *window);


/*  ja:アクセルグループを追加する
          accel,オブジェクト
    accel_group,アクセルグループ                                            */
void
misc_accel_add_accel_group (MiscAccel     *accel,
                            GtkAccelGroup *accel_group);


/*  ja:アクセルグループを削除する
          accel,オブジェクト
    accel_group,アクセルグループ                                            */
void
misc_accel_remove_accel_group (MiscAccel     *accel,
                               GtkAccelGroup *accel_group);


/*  ja:アクセルグループを取得する
    accel,オブジェクト
      RET,アクセルグループのリスト                                          */
#define misc_accel_get_accel_group(accel) (MISC_ACCEL(accel)->gslist)


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MISC_ACCEL_H__ */
