/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.Serializable;
import java.util.ArrayList;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerType;

public abstract class PointerTarget
implements Serializable {
    static final long serialVersionUID = 3230195199146939027L;
    private transient PointerTarget[] _pointerTargets;

    protected PointerTarget() {
    }

    public abstract POS getPOS();

    public abstract Pointer[] getPointers();

    public abstract String toString();

    public boolean equals(Object obj) {
        return obj instanceof PointerTarget && ((PointerTarget)obj).getPOS().equals(this.getPOS());
    }

    public Pointer[] getPointers(PointerType type) {
        ArrayList<Pointer> list = new ArrayList<Pointer>();
        Pointer[] pointers = this.getPointers();
        int i = 0;
        while (i < pointers.length) {
            if (pointers[i].getType().equals(type) || type.equals(PointerType.HYPERNYM) && pointers[i].getType().equals(PointerType.INSTANCE_HYPERNYM) || type.equals(PointerType.HYPONYM) && pointers[i].getType().equals(PointerType.INSTANCES_HYPONYM)) {
                list.add(pointers[i]);
            }
            ++i;
        }
        return list.toArray(new Pointer[list.size()]);
    }

    public PointerTarget[] getTargets() throws JWNLException {
        if (this._pointerTargets == null) {
            this._pointerTargets = this.collectTargets(this.getPointers());
        }
        return this._pointerTargets;
    }

    public PointerTarget[] getTargets(PointerType type) throws JWNLException {
        return this.collectTargets(this.getPointers(type));
    }

    private PointerTarget[] collectTargets(Pointer[] pointers) throws JWNLException {
        PointerTarget[] targets = new PointerTarget[pointers.length];
        int i = 0;
        while (i < pointers.length) {
            targets[i] = pointers[i].getTarget();
            ++i;
        }
        return targets;
    }
}

