/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabularpublisher;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.tonouchi.vocabulardb.WordCard;

public class XMLExporter {
    public void export(File file, List<WordCard> cards) {
        try {
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(new FileOutputStream(file), "UTF-8");
            writer.writeStartDocument("utf-8", "1.0");
            writer.writeStartElement("words");
            for (WordCard card : cards) {
                writer.writeStartElement("word");
                writer.writeAttribute("word", card.getWord());
                writer.writeAttribute("pos", card.getPos());
                writer.writeAttribute("japanese", card.getJapanese());
                writer.writeAttribute("english", card.getEnglish());
                writer.writeAttribute("example", card.getExample());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

