/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocable.gui.models;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import org.tonouchi.vocabulardb.DBService;
import org.tonouchi.vocabulardb.WordCard;
import org.tonouchi.vocabulardb.WordList;

public class VocabularTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = -1L;
    private static final String[] header = new String[]{"Word", "POS", "Japanese", "English", "Example"};
    private List<WordCard> data = new ArrayList<WordCard>();

    public VocabularTableModel() {
        this.updateTableData();
    }

    public void updateTableData() {
        this.data.clear();
        this.data.addAll(DBService.getDBService().getAllCards());
        this.setRowCount(this.data.size());
        this.fireTableDataChanged();
    }

    public void updateTableData(WordList list) {
        this.data.clear();
        this.data.addAll(DBService.getDBService().getCards(list));
        this.setRowCount(this.data.size());
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        WordCard card = this.data.get(row);
        switch (column) {
            case 0: {
                card.setWord(aValue.toString());
                break;
            }
            case 1: {
                card.setPos(aValue.toString());
                break;
            }
            case 2: {
                card.setJapanese(aValue.toString());
                break;
            }
            case 3: {
                card.setEnglish(aValue.toString());
                break;
            }
            case 4: {
                card.setExample(aValue.toString());
            }
        }
        DBService.getDBService().updateACard(card);
    }

    @Override
    public int getColumnCount() {
        return header.length;
    }

    @Override
    public String getColumnName(int column) {
        return header[column];
    }

    @Override
    public int getRowCount() {
        return super.getRowCount();
    }

    @Override
    public Object getValueAt(int row, int column) {
        String ret = null;
        switch (column) {
            case 0: {
                ret = this.data.get(row).getWord();
                break;
            }
            case 1: {
                ret = this.data.get(row).getPos();
                break;
            }
            case 2: {
                ret = this.data.get(row).getJapanese();
                break;
            }
            case 3: {
                ret = this.data.get(row).getEnglish();
                break;
            }
            case 4: {
                ret = this.data.get(row).getExample();
            }
        }
        return ret;
    }

    public WordCard getACard(int row) {
        return this.data.get(row);
    }
}

