/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocabulardictionary.smartfm.sentences;

import java.io.InputStream;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.XMLEvent;
import org.tonouchi.vocabulardictionary.Result;
import org.tonouchi.vocabulardictionary.smartfm.items.SmartFmContext;
import org.tonouchi.vocabulardictionary.smartfm.sentences.SmartFmSentencesCommandFactory;
import org.tonouchi.vocabulardictionary.smartfm.sentences.SmartFmSentencesFilter;

public class SmartFmSentencesParser {
    public static List<Result> parse(InputStream is) {
        SmartFmContext context = new SmartFmContext();
        try {
            Stack<XMLEvent> eventStack = new Stack<XMLEvent>();
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader reader = factory.createFilteredReader(factory.createXMLEventReader(is), new SmartFmSentencesFilter());
            SmartFmSentencesCommandFactory commandFactory = new SmartFmSentencesCommandFactory();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    eventStack.push(event);
                    commandFactory.create(eventStack).invoke(context, eventStack);
                    continue;
                }
                if (event.isCharacters()) {
                    eventStack.push(event);
                    commandFactory.create(eventStack).invoke(context, eventStack);
                    eventStack.pop();
                    continue;
                }
                if (!event.isEndElement()) continue;
                eventStack.pop();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return context.getResults();
    }
}

