/*
 * Decompiled with CFR 0.152.
 */
package org.tonouchi.vocable;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.io.InputStream;
import javax.swing.UIManager;
import org.tonouchi.vocable.ConfigInputStreamResolver;
import org.tonouchi.vocable.DBConnecitonHolder;
import org.tonouchi.vocable.gui.VocabularFrame;
import org.tonouchi.vocabularconfig.Config;
import org.tonouchi.vocabularconfig.stax.XMLConfigBuilder;
import org.tonouchi.vocabulardb.DBService;
import org.tonouchi.vocabulardictionary.DictionaryService;

public class App {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(WindowsLookAndFeel.class.getName());
            InputStream is = ConfigInputStreamResolver.getConfigInputStream();
            new XMLConfigBuilder().initialize(is);
            is.close();
            Config config = Config.getConfig();
            DBConnecitonHolder.getInstance().connect(config);
            DBService.getDBService().initialize(DBConnecitonHolder.getInstance().getConnection());
            DBService.getDBService().setUpConfig();
            DictionaryService.getDictionaryservice().init(config);
            VocabularFrame frame = new VocabularFrame();
            frame.setDefaultCloseOperation(3);
            frame.setTitle("Vocable");
            frame.setVisible(true);
            frame.setResizable(true);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    DBConnecitonHolder.getInstance().close();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

