/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.h2.api.DatabaseEventListener;
import org.h2.command.ddl.CreateTableData;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.DatabaseCloser;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Engine;
import org.h2.engine.FunctionAlias;
import org.h2.engine.MetaRecord;
import org.h2.engine.Mode;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.index.BtreeIndex;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.jdbc.JdbcSQLException;
import org.h2.log.LogSystem;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.DiskFile;
import org.h2.store.FileLock;
import org.h2.store.FileStore;
import org.h2.store.PageStore;
import org.h2.store.RecordReader;
import org.h2.store.Storage;
import org.h2.store.WriterThread;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.table.TableLinkConnection;
import org.h2.table.TableView;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.h2.util.BitField;
import org.h2.util.ByteUtils;
import org.h2.util.ClassUtils;
import org.h2.util.FileUtils;
import org.h2.util.MemoryUtils;
import org.h2.util.NetUtils;
import org.h2.util.New;
import org.h2.util.ObjectArray;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;
import org.h2.util.TempFileDeleter;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueLob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
implements DataHandler {
    private static int initialPowerOffCount;
    private final boolean persistent;
    private final String databaseName;
    private final String databaseShortName;
    private final String databaseURL;
    private final String cipher;
    private final byte[] filePasswordHash;
    private final HashMap<String, Role> roles = New.hashMap();
    private final HashMap<String, User> users = New.hashMap();
    private final HashMap<String, Setting> settings = New.hashMap();
    private final HashMap<String, Schema> schemas = New.hashMap();
    private final HashMap<String, Right> rights = New.hashMap();
    private final HashMap<String, FunctionAlias> functionAliases = New.hashMap();
    private final HashMap<String, UserDataType> userDataTypes = New.hashMap();
    private final HashMap<String, UserAggregate> aggregates = New.hashMap();
    private final HashMap<String, Comment> comments = New.hashMap();
    private final Set<Session> userSessions = Collections.synchronizedSet(new HashSet());
    private Session exclusiveSession;
    private final BitField objectIds = new BitField();
    private final Object lobSyncObject = new Object();
    private Schema mainSchema;
    private Schema infoSchema;
    private int nextSessionId;
    private User systemUser;
    private Session systemSession;
    private TableData meta;
    private Index metaIdIndex;
    private FileLock lock;
    private LogSystem log;
    private WriterThread writer;
    private HashMap<Integer, Storage> storageMap = New.hashMap();
    private boolean starting;
    private DiskFile fileData;
    private DiskFile fileIndex;
    private TraceSystem traceSystem;
    private DataPage dummy;
    private int fileLockMethod;
    private Role publicRole;
    private long modificationDataId;
    private long modificationMetaId;
    private CompareMode compareMode;
    private String cluster = "''";
    private boolean readOnly;
    private boolean noDiskSpace;
    private int writeDelay = 500;
    private DatabaseEventListener eventListener;
    private int maxMemoryRows = 10000;
    private int maxMemoryUndo = SysProperties.DEFAULT_MAX_MEMORY_UNDO;
    private int lockMode = SysProperties.DEFAULT_LOCK_MODE;
    private boolean logIndexChanges;
    private int logLevel = 1;
    private int maxLengthInplaceLob = SysProperties.DEFAULT_MAX_LENGTH_INPLACE_LOB;
    private int allowLiterals = 2;
    private int powerOffCount = initialPowerOffCount;
    private int closeDelay;
    private DatabaseCloser delayedCloser;
    private boolean recovery;
    private volatile boolean closing;
    private boolean ignoreCase;
    private boolean deleteFilesOnDisconnect;
    private String lobCompressionAlgorithm;
    private boolean optimizeReuseResults = true;
    private String cacheType;
    private boolean indexSummaryValid = true;
    private String accessModeLog;
    private String accessModeData;
    private boolean referentialIntegrity = true;
    private boolean multiVersion;
    private DatabaseCloser closeOnExit;
    private Mode mode = Mode.getInstance("REGULAR");
    private boolean multiThreaded;
    private int maxOperationMemory = SysProperties.DEFAULT_MAX_OPERATION_MEMORY;
    private boolean lobFilesInDirectories = SysProperties.LOB_FILES_IN_DIRECTORIES;
    private SmallLRUCache<String, String[]> lobFileListCache = SmallLRUCache.newInstance(128);
    private boolean autoServerMode;
    private Server server;
    private HashMap<TableLinkConnection, TableLinkConnection> linkConnections;
    private TempFileDeleter tempFileDeleter = TempFileDeleter.getInstance();
    private PageStore pageStore;
    private boolean usePageStoreSet;
    private boolean usePageStore;
    private Properties reconnectLastLock;
    private volatile long reconnectCheckNext;
    private volatile boolean reconnectChangePending;
    private int cacheSize;

    public Database(String string, ConnectionInfo connectionInfo, String string2) throws SQLException {
        String string3;
        String string4;
        this.compareMode = CompareMode.getInstance(null, 0);
        this.persistent = connectionInfo.isPersistent();
        this.filePasswordHash = connectionInfo.getFilePasswordHash();
        this.databaseName = string;
        this.databaseShortName = this.parseDatabaseShortName();
        this.cipher = string2;
        String string5 = connectionInfo.getProperty("FILE_LOCK", null);
        this.accessModeLog = connectionInfo.getProperty("ACCESS_MODE_LOG", "rw").toLowerCase();
        this.accessModeData = connectionInfo.getProperty("ACCESS_MODE_DATA", "rw").toLowerCase();
        this.autoServerMode = connectionInfo.getProperty("AUTO_SERVER", false);
        this.usePageStoreSet = connectionInfo.getProperty("PAGE_STORE") != null;
        this.usePageStore = connectionInfo.getProperty("PAGE_STORE", SysProperties.getPageStore());
        this.cacheSize = connectionInfo.getProperty("CACHE_SIZE", SysProperties.CACHE_SIZE_DEFAULT);
        if ("r".equals(this.accessModeData)) {
            this.readOnly = true;
            this.accessModeLog = "r";
        }
        this.fileLockMethod = FileLock.getFileLockMethod(string5);
        this.databaseURL = connectionInfo.getURL();
        this.eventListener = connectionInfo.getDatabaseEventListenerObject();
        connectionInfo.removeDatabaseEventListenerObject();
        if (this.eventListener == null && (string4 = connectionInfo.removeProperty("DATABASE_EVENT_LISTENER", null)) != null) {
            string4 = StringUtils.trim(string4, true, true, "'");
            this.setEventListenerClass(string4);
        }
        if ((string4 = connectionInfo.getProperty(19, null)) != null) {
            this.logIndexChanges = "2".equals(string4);
        }
        if ((string3 = connectionInfo.getProperty("RECOVER", null)) != null) {
            this.recovery = true;
        }
        this.multiVersion = connectionInfo.getProperty("MVCC", false);
        boolean bl = connectionInfo.getProperty("DB_CLOSE_ON_EXIT", true);
        int n = connectionInfo.getIntProperty(10, 1);
        int n2 = connectionInfo.getIntProperty(9, 0);
        this.cacheType = StringUtils.toUpperEnglish(connectionInfo.removeProperty("CACHE_TYPE", SysProperties.CACHE_TYPE_DEFAULT));
        this.openDatabase(n, n2, bl);
    }

    private void openDatabase(int n, int n2, boolean bl) throws SQLException {
        try {
            MemoryUtils.allocateReserveMemory();
            this.open(n, n2);
            if (bl) {
                try {
                    this.closeOnExit = new DatabaseCloser(this, 0, true);
                    Runtime.getRuntime().addShutdownHook(this.closeOnExit);
                }
                catch (IllegalStateException illegalStateException) {
                }
                catch (SecurityException securityException) {}
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                MemoryUtils.freeReserveMemory();
                throwable.fillInStackTrace();
            }
            if (this.traceSystem != null) {
                SQLException sQLException;
                if (throwable instanceof SQLException && (sQLException = (SQLException)throwable).getErrorCode() != 90020) {
                    this.traceSystem.getTrace("database").error("opening " + this.databaseName, throwable);
                }
                this.traceSystem.close();
            }
            this.closeOpenFilesAndUnlock(false);
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw Message.convert((Exception)throwable);
        }
    }

    public static void setInitialPowerOffCount(int n) {
        initialPowerOffCount = n;
    }

    public void setPowerOffCount(int n) {
        if (this.powerOffCount == -1) {
            return;
        }
        this.powerOffCount = n;
    }

    public boolean areEqual(Value value, Value value2) throws SQLException {
        return value.compareTo(value2, this.compareMode) == 0;
    }

    public int compare(Value value, Value value2) throws SQLException {
        return value.compareTo(value2, this.compareMode);
    }

    @Override
    public int compareTypeSave(Value value, Value value2) throws SQLException {
        return value.compareTypeSave(value2, this.compareMode);
    }

    public long getModificationDataId() {
        return this.modificationDataId;
    }

    synchronized boolean reconnectModified(boolean bl) {
        if (this.readOnly || this.lock == null || this.fileLockMethod != 3) {
            return true;
        }
        try {
            Object object;
            if (bl == this.reconnectChangePending) {
                long l = System.currentTimeMillis();
                if (l > this.reconnectCheckNext) {
                    if (bl) {
                        String string = this.log == null ? null : this.log.getWritePos();
                        this.lock.setProperty("logPos", string);
                        this.lock.save();
                    }
                    this.reconnectCheckNext = l + (long)SysProperties.RECONNECT_CHECK_DELAY;
                }
                return true;
            }
            Properties properties = this.lock.load();
            if (bl) {
                if (properties.getProperty("changePending") != null) {
                    return false;
                }
                this.getTrace().debug("wait before writing");
                Thread.sleep((int)((double)SysProperties.RECONNECT_CHECK_DELAY * 1.1));
                object = this.lock.load();
                if (!((Properties)object).equals(properties)) {
                    return false;
                }
            }
            object = this.log == null ? null : this.log.getWritePos();
            this.lock.setProperty("logPos", (String)object);
            if (bl) {
                this.lock.setProperty("changePending", "true-" + Math.random());
            } else {
                this.lock.setProperty("changePending", null);
            }
            this.reconnectCheckNext = System.currentTimeMillis() + (long)(2 * SysProperties.RECONNECT_CHECK_DELAY);
            properties = this.lock.save();
            if (bl) {
                this.getTrace().debug("wait before writing again");
                Thread.sleep((int)((double)SysProperties.RECONNECT_CHECK_DELAY * 1.1));
                Properties properties2 = this.lock.load();
                if (!properties2.equals(properties)) {
                    return false;
                }
            } else {
                Thread.sleep(1L);
            }
            this.reconnectLastLock = properties;
            this.reconnectChangePending = bl;
            this.reconnectCheckNext = System.currentTimeMillis() + (long)SysProperties.RECONNECT_CHECK_DELAY;
            return true;
        }
        catch (Exception exception) {
            this.getTrace().error("pending:" + bl, exception);
            return false;
        }
    }

    public long getNextModificationDataId() {
        return ++this.modificationDataId;
    }

    public long getModificationMetaId() {
        return this.modificationMetaId;
    }

    public long getNextModificationMetaId() {
        ++this.modificationDataId;
        return this.modificationMetaId++;
    }

    public int getPowerOffCount() {
        return this.powerOffCount;
    }

    @Override
    public void checkPowerOff() throws SQLException {
        if (this.powerOffCount == 0) {
            return;
        }
        if (this.powerOffCount > 1) {
            --this.powerOffCount;
            return;
        }
        if (this.powerOffCount != -1) {
            try {
                this.powerOffCount = -1;
                if (this.log != null) {
                    try {
                        this.stopWriter();
                        this.log.close(false);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.log = null;
                }
                if (this.fileData != null) {
                    try {
                        this.fileData.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.fileData = null;
                }
                if (this.fileIndex != null) {
                    try {
                        this.fileIndex.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.fileIndex = null;
                }
                if (this.pageStore != null) {
                    try {
                        this.pageStore.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    this.pageStore = null;
                }
                if (this.lock != null) {
                    this.stopServer();
                    if (this.fileLockMethod != 3) {
                        this.lock.unlock();
                    }
                    this.lock = null;
                }
            }
            catch (Exception exception) {
                TraceSystem.traceThrowable(exception);
            }
        }
        Engine.getInstance().close(this.databaseName);
        throw Message.getSQLException(90098);
    }

    public static boolean exists(String string) {
        return FileUtils.exists(string + ".h2.db") | FileUtils.exists(string + ".data.db");
    }

    public Trace getTrace(String string) {
        return this.traceSystem.getTrace(string);
    }

    @Override
    public FileStore openFile(String string, String string2, boolean bl) throws SQLException {
        if (bl && !FileUtils.exists(string)) {
            throw Message.getSQLException(90124, string);
        }
        FileStore fileStore = FileStore.open(this, string, string2, this.cipher, this.filePasswordHash);
        try {
            fileStore.init();
        }
        catch (SQLException sQLException) {
            fileStore.closeSilently();
            throw sQLException;
        }
        return fileStore;
    }

    public boolean validateFilePasswordHash(String string, byte[] byArray) {
        if (!StringUtils.equals(string, this.cipher)) {
            return false;
        }
        return ByteUtils.compareSecure(byArray, this.filePasswordHash);
    }

    private void openFileData() throws SQLException {
        this.fileData = new DiskFile(this, this.databaseName + ".data.db", this.accessModeData, true, true, SysProperties.CACHE_SIZE_DEFAULT);
    }

    private void openFileIndex() throws SQLException {
        this.fileIndex = new DiskFile(this, this.databaseName + ".index.db", this.accessModeData, false, this.logIndexChanges, SysProperties.CACHE_SIZE_INDEX_DEFAULT);
    }

    public DataPage getDataPage() {
        return this.dummy;
    }

    private String parseDatabaseShortName() {
        String string = this.databaseName;
        if (string.endsWith(":")) {
            string = null;
        }
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/\\:,;");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
            }
        }
        if (string == null || string.length() == 0) {
            string = "UNNAMED";
        }
        return StringUtils.toUpperEnglish(string);
    }

    private synchronized void open(int n, int n2) throws SQLException {
        int n3;
        Object object2;
        Object object3;
        if (this.persistent) {
            object3 = this.databaseName + ".h2.db";
            boolean bl = FileUtils.exists((String)object3);
            object2 = this.databaseName + ".data.db";
            n3 = FileUtils.exists((String)object2);
            if (!this.usePageStoreSet) {
                this.usePageStore = n3 != 0 && !bl ? false : (bl && n3 == 0 ? true : SysProperties.getPageStore());
            }
            if (this.usePageStore) {
                if (bl && FileUtils.isReadOnly((String)object3)) {
                    this.readOnly |= FileUtils.isReadOnly((String)object3);
                }
            } else if (n3 != 0) {
                this.readOnly |= FileUtils.isReadOnly((String)object2);
            }
            boolean bl2 = n3 != 0 || bl;
            this.traceSystem = this.readOnly ? new TraceSystem(null, false) : new TraceSystem(this.databaseName + ".trace.db", true);
            this.traceSystem.setLevelFile(n);
            this.traceSystem.setLevelSystemOut(n2);
            this.traceSystem.getTrace("database").info("opening " + this.databaseName + " (build " + 121 + ")");
            if (this.autoServerMode && (this.readOnly || this.fileLockMethod == 0)) {
                throw Message.getUnsupportedException("autoServerMode && (readOnly || fileLockMethod == NO)");
            }
            if (!this.readOnly && this.fileLockMethod != 0) {
                this.lock = new FileLock(this.traceSystem, this.databaseName + ".lock.db", 1000);
                this.lock.lock(this.fileLockMethod);
                if (this.autoServerMode) {
                    this.startServer(this.lock.getUniqueId());
                }
            }
            while (this.isReconnectNeeded() && !this.beforeWriting()) {
            }
            if (bl2) {
                this.lobFilesInDirectories &= !ValueLob.existsLobFile(this.getDatabasePath());
                this.lobFilesInDirectories |= FileUtils.exists(this.databaseName + ".lobs.db");
            }
            this.dummy = DataPage.create((DataHandler)this, 0);
            this.deleteOldTempFiles();
            if (this.usePageStore) {
                this.starting = true;
                this.getPageStore();
                this.starting = false;
            }
            this.log = new LogSystem(this, this.databaseName, this.readOnly, this.accessModeLog, this.pageStore);
            if (this.pageStore == null) {
                this.openFileData();
                this.log.open();
                this.openFileIndex();
                this.log.recover();
                this.fileData.init();
                try {
                    this.fileIndex.init();
                }
                catch (Exception exception) {
                    if (this.recovery) {
                        this.traceSystem.getTrace("database").error("opening index", exception);
                        for (Storage object4 : New.arrayList(this.storageMap.values())) {
                            if (object4.getDiskFile() != this.fileIndex) continue;
                            this.removeStorage(object4.getId(), this.fileIndex);
                        }
                        this.fileIndex.delete();
                        this.openFileIndex();
                    }
                    throw Message.convert(exception);
                }
            }
            this.reserveLobFileObjectIds();
            this.writer = WriterThread.create(this, this.writeDelay);
        } else {
            this.traceSystem = new TraceSystem(null, false);
            this.log = new LogSystem(null, null, false, null, null);
        }
        this.systemUser = new User(this, 0, "DBA", true);
        this.mainSchema = new Schema(this, 0, "PUBLIC", this.systemUser, true);
        this.infoSchema = new Schema(this, -1, "INFORMATION_SCHEMA", this.systemUser, true);
        this.schemas.put(this.mainSchema.getName(), this.mainSchema);
        this.schemas.put(this.infoSchema.getName(), this.infoSchema);
        this.publicRole = new Role(this, 0, "PUBLIC", true);
        this.roles.put("PUBLIC", this.publicRole);
        this.systemUser.setAdmin(true);
        this.systemSession = new Session(this, this.systemUser, ++this.nextSessionId);
        object3 = new CreateTableData();
        ObjectArray<Column> objectArray = ((CreateTableData)object3).columns;
        object2 = new Column("ID", 4);
        ((Column)object2).setNullable(false);
        objectArray.add((Column)object2);
        objectArray.add(new Column("HEAD", 4));
        objectArray.add(new Column("TYPE", 4));
        objectArray.add(new Column("SQL", 13));
        n3 = 0;
        if (this.pageStore != null) {
            n3 = this.pageStore.getSystemTableHeadPos();
        }
        ((CreateTableData)object3).tableName = "SYS";
        ((CreateTableData)object3).id = 0;
        ((CreateTableData)object3).temporary = false;
        ((CreateTableData)object3).persistData = this.persistent;
        ((CreateTableData)object3).persistIndexes = this.persistent;
        ((CreateTableData)object3).headPos = n3;
        ((CreateTableData)object3).session = this.systemSession;
        this.meta = this.mainSchema.createTable((CreateTableData)object3);
        IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{object2});
        this.metaIdIndex = this.meta.addIndex(this.systemSession, "SYS_ID", 0, indexColumnArray, IndexType.createPrimaryKey(false, false), -1, null);
        this.objectIds.set(0);
        for (int i = 0; i < MetaTable.getMetaTableTypeCount(); ++i) {
            this.addMetaData(i);
        }
        this.starting = true;
        Cursor cursor = this.metaIdIndex.find(this.systemSession, null, null);
        ObjectArray objectArray2 = ObjectArray.newInstance();
        while (cursor.next()) {
            MetaRecord metaRecord = new MetaRecord(cursor.get());
            this.objectIds.set(metaRecord.getId());
            objectArray2.add(metaRecord);
        }
        MetaRecord.sort(objectArray2);
        Iterator iterator = objectArray2.iterator();
        while (iterator.hasNext()) {
            MetaRecord metaRecord = (MetaRecord)iterator.next();
            metaRecord.execute(this, this.systemSession, this.eventListener);
        }
        this.recompileInvalidViews(this.systemSession);
        this.starting = false;
        this.addDefaultSetting(this.systemSession, 6, null, 2000);
        this.addDefaultSetting(this.systemSession, 7, null, 0);
        this.addDefaultSetting(this.systemSession, 8, null, SysProperties.CACHE_SIZE_DEFAULT);
        this.addDefaultSetting(this.systemSession, 13, "''", 0);
        this.addDefaultSetting(this.systemSession, 14, null, 500);
        this.addDefaultSetting(this.systemSession, 34, null, 121);
        if (!this.readOnly) {
            this.removeUnusedStorages(this.systemSession);
        }
        this.systemSession.commit(true);
        this.traceSystem.getTrace("database").info("opened " + this.databaseName);
    }

    public Schema getMainSchema() {
        return this.mainSchema;
    }

    private void startServer(String string) throws SQLException {
        this.server = Server.createTcpServer("-tcpPort", "0", "-tcpAllowOthers", "-key", string, this.databaseName);
        this.server.start();
        String string2 = NetUtils.getLocalAddress() + ":" + this.server.getPort();
        this.lock.setProperty("server", string2);
        this.lock.save();
    }

    private void stopServer() {
        if (this.server != null) {
            Server server = this.server;
            this.server = null;
            server.stop();
        }
    }

    private void recompileInvalidViews(Session session) {
        TableView tableView;
        boolean bl;
        do {
            bl = false;
            for (Table table : this.getAllTablesAndViews()) {
                if (!(table instanceof TableView) || !(tableView = (TableView)table).isInvalid()) continue;
                try {
                    tableView.recompile(session);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (tableView.isInvalid()) continue;
                bl = true;
            }
        } while (bl);
        for (Table table : this.getAllTablesAndViews()) {
            if (!(table instanceof TableView) || (tableView = (TableView)table).isInvalid()) continue;
            try {
                tableView.recompile(this.systemSession);
            }
            catch (SQLException sQLException) {}
        }
    }

    private void removeUnusedStorages(Session session) throws SQLException {
        if (this.persistent) {
            ObjectArray<Storage> objectArray = this.getAllStorages();
            for (Storage storage : objectArray) {
                if (storage == null || storage.getRecordReader() != null) continue;
                storage.truncate(session);
            }
        }
    }

    private void addDefaultSetting(Session session, int n, String string, int n2) throws SQLException {
        if (this.readOnly) {
            return;
        }
        String string2 = SetTypes.getTypeName(n);
        if (this.settings.get(string2) == null) {
            Setting setting = new Setting(this, this.allocateObjectId(false, true), string2);
            if (string == null) {
                setting.setIntValue(n2);
            } else {
                setting.setStringValue(string);
            }
            this.addDatabaseObject(session, setting);
        }
    }

    public void removeStorage(int n, DiskFile diskFile) {
        Storage storage;
        if (SysProperties.CHECK && ((storage = this.storageMap.get(n)) == null || storage.getDiskFile() != diskFile)) {
            Message.throwInternalError();
        }
        this.storageMap.remove(n);
    }

    public Storage getStorage(int n, DiskFile diskFile) {
        Storage storage = this.storageMap.get(n);
        if (storage != null) {
            if (SysProperties.CHECK && storage.getDiskFile() != diskFile) {
                Message.throwInternalError(storage.getDiskFile() + " != " + diskFile + " id:" + n);
            }
        } else {
            storage = new Storage(this, diskFile, null, n);
            this.storageMap.put(n, storage);
        }
        return storage;
    }

    private void addMetaData(int n) throws SQLException {
        MetaTable metaTable = new MetaTable(this.infoSchema, -1 - n, n);
        this.infoSchema.add(metaTable);
    }

    private synchronized void addMeta(Session session, DbObject dbObject) throws SQLException {
        int n = dbObject.getId();
        if (n > 0 && !this.starting && !dbObject.isTemporary()) {
            Row row = this.meta.getTemplateRow();
            MetaRecord metaRecord = new MetaRecord(dbObject);
            metaRecord.setRecord(row);
            this.objectIds.set(n);
            this.meta.lock(session, true, true);
            this.meta.addRow(session, row);
            if (this.isMultiVersion()) {
                session.log(this.meta, (short)0, row);
            }
        }
    }

    public synchronized void removeMeta(Session session, int n) throws SQLException {
        if (n > 0 && !this.starting) {
            SearchRow searchRow = this.meta.getTemplateSimpleRow(false);
            searchRow.setValue(0, ValueInt.get(n));
            Cursor cursor = this.metaIdIndex.find(session, searchRow, searchRow);
            if (cursor.next()) {
                Row row = cursor.get();
                this.meta.lock(session, true, true);
                this.meta.removeRow(session, row);
                if (this.isMultiVersion()) {
                    session.log(this.meta, (short)1, row);
                }
                this.objectIds.clear(n);
                if (SysProperties.CHECK) {
                    this.checkMetaFree(session, n);
                }
            }
        }
    }

    private HashMap<String, DbObject> getMap(int n) {
        HashMap<String, DbObject> hashMap;
        switch (n) {
            case 2: {
                hashMap = this.users;
                break;
            }
            case 6: {
                hashMap = this.settings;
                break;
            }
            case 7: {
                hashMap = this.roles;
                break;
            }
            case 8: {
                hashMap = this.rights;
                break;
            }
            case 9: {
                hashMap = this.functionAliases;
                break;
            }
            case 10: {
                hashMap = this.schemas;
                break;
            }
            case 12: {
                hashMap = this.userDataTypes;
                break;
            }
            case 13: {
                hashMap = this.comments;
                break;
            }
            case 14: {
                hashMap = this.aggregates;
                break;
            }
            default: {
                throw Message.throwInternalError("type=" + n);
            }
        }
        return hashMap;
    }

    public synchronized void addSchemaObject(Session session, SchemaObject schemaObject) throws SQLException {
        int n = schemaObject.getId();
        if (n > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        schemaObject.getSchema().add(schemaObject);
        this.addMeta(session, schemaObject);
    }

    public synchronized void addDatabaseObject(Session session, DbObject dbObject) throws SQLException {
        Object object;
        int n = dbObject.getId();
        if (n > 0 && !this.starting) {
            this.checkWritingAllowed();
        }
        HashMap<String, DbObject> hashMap = this.getMap(dbObject.getType());
        if (dbObject.getType() == 2 && ((User)(object = (User)dbObject)).isAdmin() && this.systemUser.getName().equals("DBA")) {
            this.systemUser.rename(((DbObjectBase)object).getName());
        }
        object = dbObject.getName();
        if (SysProperties.CHECK && hashMap.get(object) != null) {
            Message.throwInternalError("object already exists");
        }
        this.addMeta(session, dbObject);
        hashMap.put((String)object, dbObject);
    }

    public UserAggregate findAggregate(String string) {
        return this.aggregates.get(string);
    }

    public Comment findComment(DbObject dbObject) {
        if (dbObject.getType() == 13) {
            return null;
        }
        String string = Comment.getKey(dbObject);
        return this.comments.get(string);
    }

    public FunctionAlias findFunctionAlias(String string) {
        return this.functionAliases.get(string);
    }

    public Role findRole(String string) {
        return this.roles.get(string);
    }

    public Schema findSchema(String string) {
        return this.schemas.get(string);
    }

    public Setting findSetting(String string) {
        return this.settings.get(string);
    }

    public User findUser(String string) {
        return this.users.get(string);
    }

    public UserDataType findUserDataType(String string) {
        return this.userDataTypes.get(string);
    }

    public User getUser(String string) throws SQLException {
        User user = this.findUser(string);
        if (user == null) {
            throw Message.getSQLException(90032, string);
        }
        return user;
    }

    public synchronized Session createSession(User user) throws SQLException {
        if (this.exclusiveSession != null) {
            throw Message.getSQLException(90135);
        }
        Session session = new Session(this, user, ++this.nextSessionId);
        this.userSessions.add(session);
        this.traceSystem.getTrace("session").info("connecting #" + session.getId() + " to " + this.databaseName);
        if (this.delayedCloser != null) {
            this.delayedCloser.reset();
            this.delayedCloser = null;
        }
        return session;
    }

    public synchronized void removeSession(Session session) {
        if (session != null) {
            if (this.exclusiveSession == session) {
                this.exclusiveSession = null;
            }
            this.userSessions.remove(session);
            if (session != this.systemSession) {
                this.traceSystem.getTrace("session").info("disconnecting #" + session.getId());
            }
        }
        if (this.userSessions.size() == 0 && session != this.systemSession) {
            if (this.closeDelay == 0) {
                this.close(false);
            } else {
                if (this.closeDelay < 0) {
                    return;
                }
                this.delayedCloser = new DatabaseCloser(this, this.closeDelay * 1000, false);
                this.delayedCloser.setName("H2 Close Delay " + this.getShortName());
                this.delayedCloser.setDaemon(true);
                this.delayedCloser.start();
            }
        }
        if (session != this.systemSession && session != null) {
            this.traceSystem.getTrace("session").info("disconnected #" + session.getId());
        }
    }

    synchronized void close(boolean bl) {
        Object object;
        if (this.closing) {
            return;
        }
        if (this.fileLockMethod == 3 && !this.reconnectChangePending) {
            try {
                if (this.log != null) {
                    this.log.setReadOnly(true);
                }
                this.closeOpenFilesAndUnlock(false);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.traceSystem.close();
            Engine.getInstance().close(this.databaseName);
            return;
        }
        this.closing = true;
        this.stopServer();
        if (this.userSessions.size() > 0) {
            if (!bl) {
                return;
            }
            this.traceSystem.getTrace("database").info("closing " + this.databaseName + " from shutdown hook");
            object = new Session[this.userSessions.size()];
            this.userSessions.toArray((T[])object);
            for (Object object2 : object) {
                try {
                    ((Session)object2).rollback();
                    ((Session)object2).close();
                }
                catch (SQLException sQLException) {
                    this.traceSystem.getTrace("session").error("disconnecting #" + ((Session)object2).getId(), sQLException);
                }
            }
        }
        if (this.log != null) {
            this.log.setDisabled(false);
        }
        this.traceSystem.getTrace("database").info("closing " + this.databaseName);
        if (this.eventListener != null) {
            this.closing = false;
            object = this.eventListener;
            this.eventListener = null;
            object.closingDatabase();
            if (this.userSessions.size() > 0) {
                return;
            }
            this.closing = true;
        }
        try {
            if (this.systemSession != null) {
                if (this.powerOffCount != -1) {
                    for (Table table : this.getAllTablesAndViews()) {
                        table.close(this.systemSession);
                    }
                    for (SchemaObject schemaObject : this.getAllSchemaObjects(3)) {
                        Sequence sequence = (Sequence)schemaObject;
                        sequence.close();
                    }
                }
                for (SchemaObject schemaObject : this.getAllSchemaObjects(4)) {
                    TriggerObject triggerObject = (TriggerObject)schemaObject;
                    triggerObject.close();
                }
                if (this.powerOffCount != -1) {
                    this.meta.close(this.systemSession);
                    this.systemSession.commit(true);
                }
                this.indexSummaryValid = true;
            }
        }
        catch (SQLException sQLException) {
            this.traceSystem.getTrace("database").error("close", sQLException);
        }
        if (this.persistent) {
            try {
                ValueLob.removeAllForTable(this, -1);
            }
            catch (SQLException sQLException) {
                this.traceSystem.getTrace("database").error("close", sQLException);
            }
        }
        this.tempFileDeleter.deleteAll();
        try {
            this.closeOpenFilesAndUnlock(true);
        }
        catch (SQLException sQLException) {
            this.traceSystem.getTrace("database").error("close", sQLException);
        }
        this.traceSystem.getTrace("database").info("closed");
        this.traceSystem.close();
        if (this.closeOnExit != null) {
            this.closeOnExit.reset();
            try {
                Runtime.getRuntime().removeShutdownHook(this.closeOnExit);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.closeOnExit = null;
        }
        Engine.getInstance().close(this.databaseName);
        if (this.deleteFilesOnDisconnect && this.persistent) {
            this.deleteFilesOnDisconnect = false;
            try {
                object = FileUtils.getParent(this.databaseName);
                String string = FileUtils.getFileName(this.databaseName);
                DeleteDbFiles.execute((String)object, string, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopWriter() {
        if (this.writer != null) {
            try {
                this.writer.stopThread();
            }
            catch (SQLException sQLException) {
                this.traceSystem.getTrace("database").error("close", sQLException);
            }
            this.writer = null;
        }
    }

    private synchronized void closeOpenFilesAndUnlock(boolean bl) throws SQLException {
        if (this.log != null) {
            this.stopWriter();
            try {
                this.log.close(bl);
            }
            catch (Throwable throwable) {
                this.traceSystem.getTrace("database").error("close", throwable);
            }
            this.log = null;
        }
        if (this.pageStore != null && bl) {
            try {
                this.pageStore.checkpoint();
                if (!this.readOnly) {
                    this.pageStore.trim();
                }
            }
            catch (Throwable throwable) {
                this.traceSystem.getTrace("database").error("close", throwable);
            }
        }
        this.reconnectModified(false);
        this.closeFiles();
        if (this.persistent && this.lock == null && this.fileLockMethod != 0) {
            return;
        }
        if (this.persistent) {
            this.deleteOldTempFiles();
        }
        if (this.systemSession != null) {
            this.systemSession.close();
            this.systemSession = null;
        }
        if (this.lock != null) {
            if (this.fileLockMethod != 3) {
                this.lock.unlock();
            }
            this.lock = null;
        }
    }

    private void closeFiles() {
        try {
            if (this.fileData != null) {
                this.fileData.close();
                this.fileData = null;
            }
            if (this.fileIndex != null) {
                this.fileIndex.close();
                this.fileIndex = null;
            }
            if (this.pageStore != null) {
                this.pageStore.close();
                this.pageStore = null;
            }
        }
        catch (SQLException sQLException) {
            this.traceSystem.getTrace("database").error("close", sQLException);
        }
        this.storageMap.clear();
    }

    private void checkMetaFree(Session session, int n) throws SQLException {
        SearchRow searchRow = this.meta.getTemplateSimpleRow(false);
        searchRow.setValue(0, ValueInt.get(n));
        Cursor cursor = this.metaIdIndex.find(session, searchRow, searchRow);
        if (cursor.next()) {
            Message.throwInternalError();
        }
    }

    @Override
    public synchronized int allocateObjectId(boolean bl, boolean bl2) {
        int n;
        bl = true;
        if (bl) {
            n = this.objectIds.getLastSetBit() + 1;
            if ((n & 1) != (bl2 ? 1 : 0)) {
                ++n;
            }
            while (this.storageMap.get(n) != null || this.objectIds.get(n)) {
                if ((++n & 1) == (bl2 ? 1 : 0)) continue;
                ++n;
            }
        } else {
            n = this.objectIds.nextClearBit(0);
        }
        if (SysProperties.CHECK && this.objectIds.get(n)) {
            Message.throwInternalError();
        }
        this.objectIds.set(n);
        return n;
    }

    public ObjectArray<UserAggregate> getAllAggregates() {
        return ObjectArray.newInstance(this.aggregates.values());
    }

    public ObjectArray<Comment> getAllComments() {
        return ObjectArray.newInstance(this.comments.values());
    }

    public ObjectArray<FunctionAlias> getAllFunctionAliases() {
        return ObjectArray.newInstance(this.functionAliases.values());
    }

    public int getAllowLiterals() {
        if (this.starting) {
            return 2;
        }
        return this.allowLiterals;
    }

    public ObjectArray<Right> getAllRights() {
        return ObjectArray.newInstance(this.rights.values());
    }

    public ObjectArray<Role> getAllRoles() {
        return ObjectArray.newInstance(this.roles.values());
    }

    public ObjectArray<SchemaObject> getAllSchemaObjects(int n) {
        ObjectArray<SchemaObject> objectArray = ObjectArray.newInstance();
        for (Schema schema : this.schemas.values()) {
            objectArray.addAll(schema.getAll(n));
        }
        return objectArray;
    }

    public ObjectArray<Table> getAllTablesAndViews() {
        ObjectArray<Table> objectArray = ObjectArray.newInstance();
        for (Schema schema : this.schemas.values()) {
            objectArray.addAll(schema.getAllTablesAndViews());
        }
        return objectArray;
    }

    public ObjectArray<Schema> getAllSchemas() {
        return ObjectArray.newInstance(this.schemas.values());
    }

    public ObjectArray<Setting> getAllSettings() {
        return ObjectArray.newInstance(this.settings.values());
    }

    public ObjectArray<Storage> getAllStorages() {
        return ObjectArray.newInstance(this.storageMap.values());
    }

    public ObjectArray<UserDataType> getAllUserDataTypes() {
        return ObjectArray.newInstance(this.userDataTypes.values());
    }

    public ObjectArray<User> getAllUsers() {
        return ObjectArray.newInstance(this.users.values());
    }

    public String getCacheType() {
        return this.cacheType;
    }

    @Override
    public int getChecksum(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n < n2) {
            n3 += byArray[n++];
        }
        return n3;
    }

    public String getCluster() {
        return this.cluster;
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    @Override
    public String getDatabasePath() {
        if (this.persistent) {
            return FileUtils.getAbsolutePath(this.databaseName);
        }
        return null;
    }

    public String getShortName() {
        return this.databaseShortName;
    }

    public String getName() {
        return this.databaseName;
    }

    public LogSystem getLog() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session[] getSessions(boolean bl) {
        ArrayList<Session> arrayList;
        Object object = this.userSessions;
        synchronized (object) {
            arrayList = New.arrayList(this.userSessions);
        }
        object = this.systemSession;
        if (bl && object != null) {
            arrayList.add((Session)object);
        }
        Session[] sessionArray = new Session[arrayList.size()];
        arrayList.toArray(sessionArray);
        return sessionArray;
    }

    public synchronized void update(Session session, DbObject dbObject) throws SQLException {
        int n = dbObject.getId();
        this.removeMeta(session, n);
        this.addMeta(session, dbObject);
    }

    public synchronized void renameSchemaObject(Session session, SchemaObject schemaObject, String string) throws SQLException {
        this.checkWritingAllowed();
        schemaObject.getSchema().rename(schemaObject, string);
        this.updateWithChildren(session, schemaObject);
    }

    private synchronized void updateWithChildren(Session session, DbObject dbObject) throws SQLException {
        ObjectArray<DbObject> objectArray = dbObject.getChildren();
        Comment comment = this.findComment(dbObject);
        if (comment != null) {
            Message.throwInternalError();
        }
        this.update(session, dbObject);
        for (int i = 0; objectArray != null && i < objectArray.size(); ++i) {
            DbObject dbObject2 = objectArray.get(i);
            if (dbObject2.getCreateSQL() == null) continue;
            this.update(session, dbObject2);
        }
    }

    public synchronized void renameDatabaseObject(Session session, DbObject dbObject, String string) throws SQLException {
        this.checkWritingAllowed();
        int n = dbObject.getType();
        HashMap<String, DbObject> hashMap = this.getMap(n);
        if (SysProperties.CHECK) {
            if (!hashMap.containsKey(dbObject.getName())) {
                Message.throwInternalError("not found: " + dbObject.getName());
            }
            if (dbObject.getName().equals(string) || hashMap.containsKey(string)) {
                Message.throwInternalError("object already exists: " + string);
            }
        }
        dbObject.checkRename();
        int n2 = dbObject.getId();
        this.removeMeta(session, n2);
        hashMap.remove(dbObject.getName());
        dbObject.rename(string);
        hashMap.put(string, dbObject);
        this.updateWithChildren(session, dbObject);
    }

    @Override
    public String createTempFile() throws SQLException {
        try {
            boolean bl = this.readOnly;
            String string = this.databaseName;
            if (!this.persistent) {
                string = "memFS:" + string;
            }
            return FileUtils.createTempFile(string, ".temp.db", true, bl);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, this.databaseName);
        }
    }

    private void reserveLobFileObjectIds() throws SQLException {
        String[] stringArray;
        String string = FileUtils.normalize(this.databaseName) + ".";
        String string2 = FileUtils.getParent(this.databaseName);
        for (String string3 : stringArray = FileUtils.listFiles(string2)) {
            if (!string3.endsWith(".lob.db") || !FileUtils.fileStartsWith(string3, string)) continue;
            string3 = string3.substring(string.length());
            int n = (string3 = string3.substring(0, string3.length() - ".lob.db".length())).indexOf(46);
            if (n < 0) continue;
            String string4 = string3.substring(n + 1);
            int n2 = Integer.parseInt(string4);
            this.objectIds.set(n2);
        }
    }

    private void deleteOldTempFiles() throws SQLException {
        String[] stringArray;
        String string = FileUtils.getParent(this.databaseName);
        String string2 = FileUtils.normalize(this.databaseName);
        for (String string3 : stringArray = FileUtils.listFiles(string)) {
            if (!string3.endsWith(".temp.db") || !FileUtils.fileStartsWith(string3, string2)) continue;
            FileUtils.tryDelete(string3);
        }
    }

    public Storage getStorage(RecordReader recordReader, int n, boolean bl) {
        DiskFile diskFile = bl ? this.fileData : this.fileIndex;
        Storage storage = this.getStorage(n, diskFile);
        storage.setReader(recordReader);
        return storage;
    }

    public Schema getSchema(String string) throws SQLException {
        Schema schema = this.findSchema(string);
        if (schema == null) {
            throw Message.getSQLException(90079, string);
        }
        return schema;
    }

    public synchronized void removeDatabaseObject(Session session, DbObject dbObject) throws SQLException {
        Comment comment;
        this.checkWritingAllowed();
        String string = dbObject.getName();
        int n = dbObject.getType();
        HashMap<String, DbObject> hashMap = this.getMap(n);
        if (SysProperties.CHECK && !hashMap.containsKey(string)) {
            Message.throwInternalError("not found: " + string);
        }
        if ((comment = this.findComment(dbObject)) != null) {
            this.removeDatabaseObject(session, comment);
        }
        int n2 = dbObject.getId();
        dbObject.removeChildrenAndResources(session);
        hashMap.remove(string);
        this.removeMeta(session, n2);
    }

    public Table getDependentTable(SchemaObject schemaObject, Table table) {
        switch (schemaObject.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 13: {
                return null;
            }
        }
        HashSet<DbObject> hashSet = New.hashSet();
        for (Table table2 : this.getAllTablesAndViews()) {
            if (table == table2) continue;
            hashSet.clear();
            table2.addDependencies(hashSet);
            if (!hashSet.contains(schemaObject)) continue;
            return table2;
        }
        return null;
    }

    private String getFirstInvalidTable(Session session) {
        String string = null;
        try {
            for (Table table : this.getAllTablesAndViews()) {
                string = table.getSQL();
                session.prepare(table.getCreateSQL());
            }
        }
        catch (SQLException sQLException) {
            return string;
        }
        return null;
    }

    public synchronized void removeSchemaObject(Session session, SchemaObject schemaObject) throws SQLException {
        Object object;
        DbObject dbObject;
        int n = schemaObject.getType();
        if (n == 0) {
            dbObject = (Table)schemaObject;
            if (dbObject.isTemporary() && !dbObject.isGlobalTemporary()) {
                session.removeLocalTempTable((Table)dbObject);
                return;
            }
        } else if (n == 1) {
            dbObject = (Index)schemaObject;
            object = dbObject.getTable();
            if (((DbObjectBase)object).isTemporary() && !((Table)object).isGlobalTemporary()) {
                session.removeLocalTempTableIndex((Index)dbObject);
                return;
            }
        } else if (n == 5 && ((DbObjectBase)(object = ((Constraint)(dbObject = (Constraint)schemaObject)).getTable())).isTemporary() && !((Table)object).isGlobalTemporary()) {
            session.removeLocalTempTableConstraint((Constraint)dbObject);
            return;
        }
        this.checkWritingAllowed();
        dbObject = this.findComment(schemaObject);
        if (dbObject != null) {
            this.removeDatabaseObject(session, dbObject);
        }
        schemaObject.getSchema().remove(schemaObject);
        if (!this.starting) {
            Table table;
            object = SysProperties.OPTIMIZE_DROP_DEPENDENCIES ? ((table = this.getDependentTable(schemaObject, null)) == null ? null : table.getSQL()) : this.getFirstInvalidTable(session);
            if (object != null) {
                schemaObject.getSchema().add(schemaObject);
                throw Message.getSQLException(90107, new String[]{schemaObject.getSQL(), object});
            }
            schemaObject.removeChildrenAndResources(session);
        }
        int n2 = schemaObject.getId();
        this.removeMeta(session, n2);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public TraceSystem getTraceSystem() {
        return this.traceSystem;
    }

    public DiskFile getDataFile() {
        return this.fileData;
    }

    public DiskFile getIndexFile() {
        return this.fileIndex;
    }

    public synchronized void setCacheSize(int n) throws SQLException {
        this.cacheSize = n;
        if (this.fileData != null) {
            this.fileData.getCache().setMaxSize(n);
            int n2 = n <= 32 ? n : n >>> SysProperties.CACHE_SIZE_INDEX_SHIFT;
            this.fileIndex.getCache().setMaxSize(n2);
        }
        if (this.pageStore != null) {
            this.pageStore.getCache().setMaxSize(n);
        }
    }

    public synchronized void setMasterUser(User user) throws SQLException {
        this.addDatabaseObject(this.systemSession, user);
        this.systemSession.commit(true);
    }

    public Role getPublicRole() {
        return this.publicRole;
    }

    public String getTempTableName(int n) {
        String string;
        int n2 = 0;
        while (this.mainSchema.findTableOrView(null, string = "TEMP_TABLE_" + n + "_" + n2) != null) {
            ++n2;
        }
        return string;
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    public void setCluster(String string) {
        this.cluster = string;
    }

    @Override
    public void checkWritingAllowed() throws SQLException {
        if (this.readOnly) {
            throw Message.getSQLException(90097);
        }
        if (this.noDiskSpace) {
            throw Message.getSQLException(90100);
        }
        if (this.fileLockMethod == 3 && !this.reconnectChangePending) {
            throw Message.getSQLException(90097);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
        if (this.writer != null) {
            this.writer.setWriteDelay(n);
        }
    }

    public void deleteLogFileLater(String string) throws SQLException {
        if (this.fileLockMethod == 3) {
            FileUtils.setLength(string, 0L);
        } else if (this.writer != null) {
            this.writer.deleteLogFileLater(string);
        } else {
            FileUtils.delete(string);
        }
    }

    public void setEventListener(DatabaseEventListener databaseEventListener) {
        this.eventListener = databaseEventListener;
    }

    public void setEventListenerClass(String string) throws SQLException {
        if (string == null || string.length() == 0) {
            this.eventListener = null;
        } else {
            try {
                this.eventListener = (DatabaseEventListener)ClassUtils.loadUserClass(string).newInstance();
                String string2 = this.databaseURL;
                if (this.cipher != null) {
                    string2 = string2 + ";CIPHER=" + this.cipher;
                }
                this.eventListener.init(string2);
            }
            catch (Throwable throwable) {
                throw Message.getSQLException(90099, throwable, string, throwable.toString());
            }
        }
    }

    @Override
    public synchronized void freeUpDiskSpace() throws SQLException {
        if (this.eventListener != null) {
            this.eventListener.diskSpaceIsLow(0L);
        }
    }

    public void setProgress(int n, String string, int n2, int n3) {
        if (this.eventListener != null) {
            try {
                this.eventListener.setProgress(n, string, n2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void exceptionThrown(SQLException sQLException, String string) {
        if (this.eventListener != null) {
            try {
                this.eventListener.exceptionThrown(sQLException, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sync() throws SQLException {
        if (this.log != null) {
            this.log.sync();
        }
        if (this.fileData != null) {
            this.fileData.sync();
        }
        if (this.fileIndex != null) {
            this.fileIndex.sync();
        }
    }

    public int getMaxMemoryRows() {
        return this.maxMemoryRows;
    }

    public void setMaxMemoryRows(int n) {
        this.maxMemoryRows = n;
    }

    public void setMaxMemoryUndo(int n) {
        this.maxMemoryUndo = n;
    }

    public int getMaxMemoryUndo() {
        return this.maxMemoryUndo;
    }

    public void setLockMode(int n) throws SQLException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw Message.getInvalidValueException("lock mode", "" + n);
            }
        }
        this.lockMode = n;
    }

    public int getLockMode() {
        return this.lockMode;
    }

    public synchronized void setCloseDelay(int n) {
        this.closeDelay = n;
    }

    public boolean getLogIndexChanges() {
        return this.logIndexChanges;
    }

    public synchronized void setLog(int n) throws SQLException {
        boolean bl;
        boolean bl2;
        if (this.logLevel == n) {
            return;
        }
        switch (n) {
            case 0: {
                bl2 = false;
                bl = false;
                break;
            }
            case 1: {
                bl2 = true;
                bl = false;
                break;
            }
            case 2: {
                bl2 = true;
                bl = true;
                break;
            }
            default: {
                throw Message.throwInternalError("level=" + n);
            }
        }
        if (this.fileIndex != null) {
            this.fileIndex.setLogChanges(bl);
        }
        this.logIndexChanges = bl;
        if (this.log != null) {
            this.log.setDisabled(!bl2);
            this.log.checkpoint();
        }
        if (n == 0) {
            this.traceSystem.getTrace("database").error("SET LOG " + n, null);
        }
        this.logLevel = n;
    }

    public boolean getRecovery() {
        return this.recovery;
    }

    public Session getSystemSession() {
        return this.systemSession;
    }

    @Override
    public void handleInvalidChecksum() throws SQLException {
        JdbcSQLException jdbcSQLException = Message.getSQLException(90030, "wrong checksum");
        if (!this.recovery) {
            throw jdbcSQLException;
        }
        this.traceSystem.getTrace("database").error("recover", jdbcSQLException);
    }

    public boolean isClosing() {
        return this.closing;
    }

    public void setMaxLengthInplaceLob(int n) {
        this.maxLengthInplaceLob = n;
    }

    @Override
    public int getMaxLengthInplaceLob() {
        return this.persistent ? this.maxLengthInplaceLob : Integer.MAX_VALUE;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean getIgnoreCase() {
        if (this.starting) {
            return false;
        }
        return this.ignoreCase;
    }

    public synchronized void setDeleteFilesOnDisconnect(boolean bl) {
        this.deleteFilesOnDisconnect = bl;
    }

    @Override
    public String getLobCompressionAlgorithm(int n) {
        return this.lobCompressionAlgorithm;
    }

    public void setLobCompressionAlgorithm(String string) {
        this.lobCompressionAlgorithm = string;
    }

    public void notifyFileSize(long l) {
    }

    public synchronized void setMaxLogSize(long l) {
        this.getLog().setMaxLogSize(l);
    }

    public void setAllowLiterals(int n) {
        this.allowLiterals = n;
    }

    public boolean getOptimizeReuseResults() {
        return this.optimizeReuseResults;
    }

    public void setOptimizeReuseResults(boolean bl) {
        this.optimizeReuseResults = bl;
    }

    public void invalidateIndexSummary() throws SQLException {
        if (this.indexSummaryValid) {
            this.indexSummaryValid = false;
            this.log.invalidateIndexSummary();
        }
    }

    public boolean isIndexSummaryValid() {
        return this.indexSummaryValid;
    }

    @Override
    public Object getLobSyncObject() {
        return this.lobSyncObject;
    }

    public int getSessionCount() {
        return this.userSessions.size();
    }

    public void setReferentialIntegrity(boolean bl) {
        this.referentialIntegrity = bl;
    }

    public boolean getReferentialIntegrity() {
        return this.referentialIntegrity;
    }

    public boolean isStarting() {
        return this.starting;
    }

    public boolean isMultiVersion() {
        return this.multiVersion;
    }

    public void opened() {
        if (this.eventListener != null) {
            this.eventListener.opened();
        }
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    public void setMultiThreaded(boolean bl) throws SQLException {
        if (bl && this.multiVersion && this.multiThreaded != bl) {
            throw Message.getSQLException(90133, "MVCC & MULTI_THREADED");
        }
        this.multiThreaded = bl;
    }

    public void setMaxOperationMemory(int n) {
        this.maxOperationMemory = n;
    }

    public int getMaxOperationMemory() {
        return this.maxOperationMemory;
    }

    public Session getExclusiveSession() {
        return this.exclusiveSession;
    }

    public void setExclusiveSession(Session session) {
        this.exclusiveSession = session;
    }

    @Override
    public boolean getLobFilesInDirectories() {
        return this.lobFilesInDirectories;
    }

    @Override
    public SmallLRUCache<String, String[]> getLobFileListCache() {
        return this.lobFileListCache;
    }

    public boolean isSysTableLocked() {
        return this.meta.isLockedExclusively();
    }

    public TableLinkConnection getLinkConnection(String string, String string2, String string3, String string4) throws SQLException {
        if (this.linkConnections == null) {
            this.linkConnections = New.hashMap();
        }
        return TableLinkConnection.open(this.linkConnections, string, string2, string3, string4);
    }

    public String toString() {
        return this.databaseShortName + ":" + super.toString();
    }

    public void shutdownImmediately() {
        this.setPowerOffCount(1);
        try {
            this.checkPowerOff();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.closeFiles();
    }

    @Override
    public TempFileDeleter getTempFileDeleter() {
        return this.tempFileDeleter;
    }

    @Override
    public Trace getTrace() {
        return this.getTrace("database");
    }

    public PageStore getPageStore() throws SQLException {
        if (this.pageStore == null && this.usePageStore) {
            this.pageStore = new PageStore(this, this.databaseName + ".h2.db", this.accessModeData, this.cacheSize);
            this.pageStore.open();
        }
        return this.pageStore;
    }

    public boolean isPageStoreEnabled() {
        return this.usePageStore;
    }

    public Table getFirstUserTable() {
        for (Table table : this.getAllTablesAndViews()) {
            if (table.getCreateSQL() == null) continue;
            return table;
        }
        return null;
    }

    public boolean isReconnectNeeded() {
        if (this.fileLockMethod != 3) {
            return false;
        }
        if (this.reconnectChangePending) {
            return false;
        }
        long l = System.currentTimeMillis();
        if (l < this.reconnectCheckNext) {
            return false;
        }
        this.reconnectCheckNext = l + (long)SysProperties.RECONNECT_CHECK_DELAY;
        if (this.lock == null) {
            this.lock = new FileLock(this.traceSystem, this.databaseName + ".lock.db", 1000);
        }
        try {
            Properties properties;
            Properties properties2 = properties = this.lock.load();
            while (true) {
                if (properties.equals(this.reconnectLastLock)) {
                    return false;
                }
                if (properties.getProperty("changePending", null) == null) break;
                if (System.currentTimeMillis() > l + (long)(SysProperties.RECONNECT_CHECK_DELAY * 10) && properties2.equals(properties)) {
                    this.lock.setProperty("changePending", null);
                    this.lock.save();
                    break;
                }
                this.getTrace().debug("delay (change pending)");
                Thread.sleep(SysProperties.RECONNECT_CHECK_DELAY);
                properties = this.lock.load();
            }
            this.reconnectLastLock = properties;
        }
        catch (Exception exception) {
            this.getTrace().error("readOnly:" + this.readOnly, exception);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkpointIfRequired() throws SQLException {
        if (this.fileLockMethod != 3 || this.readOnly || !this.reconnectChangePending || this.closing) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l > this.reconnectCheckNext + (long)SysProperties.RECONNECT_CHECK_DELAY) {
            Database database = this;
            synchronized (database) {
                this.getTrace().debug("checkpoint");
                this.flushIndexes(0L);
                this.checkpoint();
                this.reconnectModified(false);
            }
        }
    }

    public boolean isFileLockSerialized() {
        return this.fileLockMethod == 3;
    }

    public synchronized void flushIndexes(long l) {
        for (SchemaObject schemaObject : this.getAllSchemaObjects(1)) {
            Table table;
            BtreeIndex btreeIndex;
            if (!(schemaObject instanceof BtreeIndex) || (btreeIndex = (BtreeIndex)schemaObject).getLastChange() == 0L || (table = btreeIndex.getTable()).isLockedExclusively() || l != 0L && btreeIndex.getLastChange() > l) continue;
            try {
                btreeIndex.flush(this.systemSession);
            }
            catch (SQLException sQLException) {
                this.getTrace().error("flush index " + btreeIndex.getName(), sQLException);
            }
        }
    }

    public void checkpoint() throws SQLException {
        if (this.persistent) {
            if (this.pageStore != null) {
                this.pageStore.checkpoint();
            }
            this.getLog().checkpoint();
        }
        this.getTempFileDeleter().deleteUnused();
    }

    public boolean beforeWriting() {
        if (this.fileLockMethod == 3) {
            return this.reconnectModified(true);
        }
        return true;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }
}

