/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageDataIndex;
import org.h2.index.PageIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.PageStore;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;

public class PageDelegateIndex
extends PageIndex {
    private final PageDataIndex mainIndex;

    public PageDelegateIndex(TableData tableData, int n, String string, IndexType indexType, PageDataIndex pageDataIndex, int n2, Session session) throws SQLException {
        IndexColumn[] indexColumnArray = IndexColumn.wrap(new Column[]{tableData.getColumn(pageDataIndex.getMainIndexColumn())});
        this.initBaseIndex(tableData, n, string, indexColumnArray, indexType);
        this.mainIndex = pageDataIndex;
        if (!this.database.isPersistent() || n < 0) {
            throw Message.throwInternalError("" + string);
        }
        PageStore pageStore = this.database.getPageStore();
        pageStore.addIndex(this);
        if (n2 == -1) {
            pageStore.addMeta(this, session);
        }
    }

    public void add(Session session, Row row) {
    }

    public boolean canFindNext() {
        return false;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public void close(Session session) {
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        long l = this.mainIndex.getLong(searchRow, Long.MIN_VALUE);
        long l2 = this.mainIndex.getLong(searchRow2, Long.MAX_VALUE);
        return this.mainIndex.find(session, l, l2, false);
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        Cursor cursor;
        if (bl) {
            cursor = this.mainIndex.find(session, Long.MIN_VALUE, Long.MAX_VALUE, false);
        } else {
            long l = this.mainIndex.getLastKey();
            cursor = this.mainIndex.find(session, l, l, false);
        }
        cursor.next();
        return cursor;
    }

    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        throw Message.throwInternalError();
    }

    public int getColumnIndex(Column column) {
        return this.mainIndex.getColumnIndex(column);
    }

    public double getCost(Session session, int[] nArray) {
        return 10L * this.getCostRangeIndex(nArray, this.mainIndex.getRowCount(session));
    }

    public boolean needRebuild() {
        return false;
    }

    public void remove(Session session, Row row) {
    }

    public void remove(Session session) throws SQLException {
        this.mainIndex.setMainIndexColumn(-1);
        session.getDatabase().getPageStore().removeMeta(this, session);
    }

    public void truncate(Session session) {
    }

    public void checkRename() {
    }

    public long getRowCount(Session session) {
        return this.mainIndex.getRowCount(session);
    }

    public long getRowCountApproximation() {
        return this.mainIndex.getRowCountApproximation();
    }
}

