/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.util.FileUtils;
import org.h2.util.New;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempFileDeleter {
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final HashMap<PhantomReference<?>, TempFile> refMap = New.hashMap();

    private TempFileDeleter() {
    }

    public static TempFileDeleter getInstance() {
        return new TempFileDeleter();
    }

    public synchronized Reference<?> addFile(String string, Object object) {
        FileUtils.trace("TempFileDeleter.addFile", string, object);
        PhantomReference<Object> phantomReference = new PhantomReference<Object>(object, this.queue);
        TempFile tempFile = new TempFile();
        tempFile.fileName = string;
        tempFile.lastModified = FileUtils.getLastModified(string);
        this.refMap.put(phantomReference, tempFile);
        this.deleteUnused();
        return phantomReference;
    }

    public synchronized void updateAutoDelete(Reference<?> reference) {
        TempFile tempFile = this.refMap.get(reference);
        if (tempFile != null) {
            long l;
            String string = tempFile.fileName;
            tempFile.lastModified = l = FileUtils.getLastModified(string);
        }
    }

    public synchronized void deleteFile(Reference<?> reference, String string) {
        TempFile tempFile;
        if (reference != null && (tempFile = this.refMap.remove(reference)) != null) {
            long l;
            if (SysProperties.CHECK && string != null && !tempFile.fileName.equals(string)) {
                Message.throwInternalError("f2:" + tempFile.fileName + " f:" + string);
            }
            if ((l = FileUtils.getLastModified(string = tempFile.fileName)) != tempFile.lastModified) {
                return;
            }
        }
        if (string != null && FileUtils.exists(string)) {
            try {
                FileUtils.trace("TempFileDeleter.deleteFile", string, null);
                FileUtils.tryDelete(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void deleteAll() {
        for (TempFile tempFile : this.refMap.values()) {
            this.deleteFile(null, tempFile.fileName);
        }
        this.deleteUnused();
    }

    public void deleteUnused() {
        Reference<Object> reference;
        while (this.queue != null && (reference = this.queue.poll()) != null) {
            this.deleteFile(reference, null);
        }
    }

    public void stopAutoDelete(Reference<?> reference, String string) {
        FileUtils.trace("TempFileDeleter.stopAutoDelete", string, reference);
        if (reference != null) {
            TempFile tempFile = this.refMap.remove(reference);
            if (SysProperties.CHECK && (tempFile == null || !tempFile.fileName.equals(string))) {
                Message.throwInternalError("f2:" + tempFile + " " + (tempFile == null ? "" : tempFile.fileName) + " f:" + string);
            }
        }
        this.deleteUnused();
    }

    static class TempFile {
        String fileName;
        long lastModified;

        TempFile() {
        }
    }
}

