drop table if exists cards;
drop table if exists binders;
drop table if exists leaves;
drop table if exists configure;
drop table if exists history;

create table cards(
    id int not null auto_increment,
    word text not null,
    pos text not null default '',
    japanese text not null default '',
    english text not null default '',
    example text not null default '',
    list_id int not null,
    created timestamp not null default current time,
    primary key(id));

create table binders(
    id int not null auto_increment,
    name text not null default '',
    created timestamp not null default current time,
    primary key(id));

create table configure(
    use_smart_fm boolean,
    smart_fm_as_ej boolean,
    smart_fm_as_ex boolean,
    use_word_net boolean,
    word_net_as_ee boolean,
    word_net_as_ex boolean,
    path_to_word_net text,
    path_to_font text,
    use_pdic boolean,
    path_to_pdic text);

insert into configure values(
    false,
    false,
    false,
    true,
    true,
    true,
    'conf/jwnlsetting.xml',
    'font/ipagp.otf',
    false,
    '');