/***************************************************************************
                          wganttitem.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5 30  02:20:12 JST
    copyright            : (C) 2003 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qapplication.h>
#include "wganttitem.h"
#include <qcursor.h>

/////////////////////////////////////////////////////////////////////////////

WGanttItem::WGanttItem(
  const QColor& colorMid, 
  const QColor& colorEdge, 
  QWidget* WidgetParent, 
  const char* cName)
  : QFrame(WidgetParent, cName), 
    colorFace(colorMid), 
    colorStretcher(colorEdge)
{
  nMaxLen = 0;
  nLeftDiff = 0;
  nRightDiff = 0;

  mouseState = Suspended;
  setMaximumHeight(20);
  setMinimumWidth(11);
  setPaletteBackgroundColor(colorStretcher);
  setMouseTracking(true);
  setCursor(Qt::SizeHorCursor);

  FrameFace = new QLabel("", this);
  FrameFace->move(FrameFace->x() + 5, FrameFace->y());
  FrameFace->resize(width() - 10, FrameFace->height());
  FrameFace->setPaletteBackgroundColor(colorFace);
  FrameFace->setMouseTracking(true);
  FrameFace->setCursor(Qt::SizeAllCursor);
}

/////////////////////////////////////////////////////////////////////////////

WGanttItem::~WGanttItem()
{
}

/////////////////////////////////////////////////////////////////////////////

int 
WGanttItem::startPosition() const
{
  return nLeftDiff;
}

/////////////////////////////////////////////////////////////////////////////

int 
WGanttItem::offset() const
{
  return x();
}

/////////////////////////////////////////////////////////////////////////////

int 
WGanttItem::length() const
{
  return FrameFace->width();
}

/////////////////////////////////////////////////////////////////////////////

int 
WGanttItem::maximumLength() const
{
  return nMaxLen;
}

/////////////////////////////////////////////////////////////////////////////

void 
WGanttItem::slotSetStartPosition(int nStartPosition)
{
  if ( nStartPosition < 0 ) {
    return;
  } else if ( nStartPosition > length() ) {
    return;
  } else if ( nStartPosition == startPosition() ) {
    return;
  }

  slotSetLength(nMaxLen - (nStartPosition + nRightDiff), true);

  //!! need to emit??
}

/////////////////////////////////////////////////////////////////////////////

void 
WGanttItem::slotSetOffset(int nOffset)
{
  if ( nOffset == offset() ) {
    return;
  }

  move(nOffset, y());

  //!! need to emit??
}

/////////////////////////////////////////////////////////////////////////////

void 
WGanttItem::slotSetLength(int nLen, bool bLeft/* =false */)
{
  if ( nLen > nMaxLen ) {
    return;
  } else if ( nLen == length() ) {
    return;
  }

  resize(nLen + 10, height());
  FrameFace->resize(nLen, height());
  if ( bLeft ) {
    nLeftDiff = nMaxLen - nLen;
  } else {
    nRightDiff = nMaxLen - nLen;
  }

  //!! need to emit??
}

/////////////////////////////////////////////////////////////////////////////

void 
WGanttItem::slotSetMaximumLength(int nLen)
{
  if ( nLen < 0 ) {
    return;
  } else if ( nLen == maximumLength() ) {
    return;
  }

  nMaxLen = nLen;
  setMaximumWidth(nMaxLen + 10);
  reset();

  //!! need to emit??
}

/////////////////////////////////////////////////////////////////////////////

void 
WGanttItem::slotSetText(const QString& strCaption)
{
  FrameFace->setText(strCaption);
}

/////////////////////////////////////////////////////////////////////////////

void 
WGanttItem::reset()
{
  slotSetStartPosition(0);
  slotSetLength(nMaxLen);
  slotSetOffset(0);
  nLeftDiff = 0;
  nRightDiff = 0;
}

/////////////////////////////////////////////////////////////////////////////

void 
WGanttItem::setPaletteEdgeColor(const QColor& color)
{
  FrameFace->setPaletteBackgroundColor(color);
}

/////////////////////////////////////////////////////////////////////////////

void
WGanttItem::mousePressEvent(QMouseEvent* Event)
{
  // ignore
  {
    if ( mouseState != Suspended ) {
      return;
    }
    if ( Event->button() != QMouseEvent::LeftButton ) {
      return;
    }
  }

  if ( FrameFace->hasMouse() ) {
    mouseState = Moving;
  } else {
    if ( Event->x() <= 5 ) {
      mouseState = LeftResizing;
    } else {
      mouseState = RightResizing;
    }
    nWidthResizeStart = width();
  }
  nXMoveStart      = x();
  nXCursorMoveStart = QCursor::pos().x();
}

/////////////////////////////////////////////////////////////////////////////

void
WGanttItem::mouseReleaseEvent(QMouseEvent*)
{
  mouseState = Suspended;
}

/////////////////////////////////////////////////////////////////////////////

void
WGanttItem::mouseMoveEvent(QMouseEvent*)
{
  if ( mouseState == Suspended ) {
    return;
  }

  // Do not use functoins argument to get cursor position!!
  // This event is difficult to manage synchronous.
  int nXCursor = QCursor::pos().x();

  // move
  if ( mouseState == Moving ) {
    if ( nXMoveStart + nXCursor - nXCursorMoveStart < 0 ) {
      move(0, y());
    } else {
      move(nXMoveStart + nXCursor - nXCursorMoveStart, y());
    }
    emit offsetChanged(x());

  // resize
  } else {
    if ( mouseState == LeftResizing ) {
      if ( nWidthResizeStart + nXCursorMoveStart - nXCursor < 11 ) {
        return;
      }

      nLeftDiff = nMaxLen + 10 - 
                  (nWidthResizeStart + nRightDiff + nXCursorMoveStart - nXCursor);
      if ( nLeftDiff < 0 ) {
        nXCursor = (nWidthResizeStart + nRightDiff) + 
                   nXCursorMoveStart - (nMaxLen + 10);
        nLeftDiff = 0;
      }
      
      if ( nXMoveStart + nXCursor - nXCursorMoveStart < 0 ) {
        move(0, y());
      } else {
        move(nXMoveStart + nXCursor - nXCursorMoveStart, y());
      }
      emit offsetChanged(x());
      resize(nWidthResizeStart + nXCursorMoveStart - nXCursor, height());
      FrameFace->move(5, y());
      emit startPositionChanged(startPosition());
    } else if ( mouseState == RightResizing) {
      nRightDiff = (nMaxLen + 10) - 
                   (nWidthResizeStart + nLeftDiff + nXCursor - nXCursorMoveStart);
      if ( nRightDiff < 0 ) {
        nXCursor = (nMaxLen + 10) - 
                   (nWidthResizeStart + nLeftDiff) + nXCursorMoveStart;
        nRightDiff = 0;
      }

      resize(nWidthResizeStart + nXCursor - nXCursorMoveStart, height());
    }
    FrameFace->resize(width() - 10, height());
    emit lengthChanged(length());
  }
}

/////////////////////////////////////////////////////////////////////////////

#include "wganttitem.moc"
