/*
  up̃NCAgvO
  Satofumi KAMIMURA
  $Id$
*/

#include "robotServer.h"
#include "mRunCtrl.h"
#include "mURGCtrl.h"
#include "joystickCtrl.h"
#include "inputHandle.h"
#include <stdlib.h>


int main(int argc, char *argv[]) {
  try {
    char* host = NULL;
    for (int i = 1; i < argc; ++i) {
      if (!strncmp("--host=", argv[i], 7)) {
	host = &argv[i][7];
      }
    }
    if (!host) {
      printf("specify connection host: --host=<host name>\n");
      exit(1);
    }

    mRunCtrl run;
    mURGCtrl urg;
    vmonitor::connect(argc, argv);
    if (run.connectSocket(host, RunVirtualPort) < 0) {
      printf("RunCtrl::connectSocket: %s\n", run.what());
      exit(1);
    }
    if (urg.connectSocket(host, URGVirtualPort, true) < 0) {
      printf("URGCtrl::connectSocket: %s\n", run.what());
      exit(1);
    }

    // ʐMݒ
    enum { TcpipTimeout = 5000 };
    run.set_sendRetryTimes(0);
    run.set_recvTimeout(TcpipTimeout);
    urg.set_recvTimeout(TcpipTimeout);
    run.set_watchDogTimer(TcpipTimeout + 1000);

    urg.setOwnCrdToObject(&run);
    run.adjustSubTreeTicks(0);

    vmonitor::show();

    // Joystick Ώ
    JoystickCtrl js;
    if (js.size() > 0) {
      js.activate();
    }

    // C̐䃋[v
    UserInput::userInput_t ui;
    int pre_times = -1;
    do {
      ui = UserInput::getInputed();
      robotInput_t ri = inputHandle(js, ui);
      drawJetMode(ri);
      robotCtrl(run, ri);

      // ̎擾
      int times = urg.capture();
      if (times != pre_times) {
	drawCaptures(urg, run);
      }
      VXV::Delay(1);
    } while (!ui.quit);
  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
