/*
  Mf[^̃_uobt@
  Satofumi KAMIMURA
  $Id$
*/

#include <urgCtrl.h>
#include <stdio.h>
#include <stdlib.h>


static void capture(int argc, char *argv[], bool autoCapture) {
  URGCtrl urg;
  if (urg.connect(argc, argv, autoCapture) < 0) {
    printf("URG::connect: %s\n", urg.what());
    exit(1);
  }
  unsigned long begin = VXV::GetTicks();
  unsigned long pre_ticks = 0;
  for (int i = 0; i < 10; ++i) {
    VXV::Delay(20);
    int n = urg.capture();
    int times = urg.getCaptureTimes();
    unsigned long ticks = VXV::GetTicks() - begin;
    unsigned long diff = ticks - pre_ticks;
    printf("%d:(%lu +%lu), %d\n", times, ticks, diff, n);
    pre_ticks = ticks;
  }
}


int main(int argc, char *argv[]) {
  try {
    printf("manual\n");
    capture(argc, argv, URG::ManualCapture);
    
    printf("\nauto\n");
    capture(argc, argv, URG::AutoCapture);
    
  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
