#ifndef COOTRDINATE_CTRL_H
#define COOTRDINATE_CTRL_H

/*!
  \file
  \brief WnNX
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "typeUtils.h"
#include <vector>
#include <list>
#include <string>

class ObjCoordinateCtrl;


/*!
  \brief WnNX
*/
class CoordinateCtrl {
  static std::list<CoordinateCtrl*> nortify_crd;

  CoordinateCtrl* parent_crd;
  std::list<CoordinateCtrl*> child_crd;
  VXV::Position3D parent_offset;

protected:
  /*!
    \brief WnCxg̒`
  */
  enum {
    Create,			/*!< Wn̒ǉCxg */
    Remove,			/*!< Wn̍폜Cxg */
    Update,			/*!< Wn̍XVCxg */
  };

  /*!
    \brief WnΏۂɓ\tꂽԂ

    ObjCoordinateCtrl ł̃I[o[Chp

    \param crd [i] WnIuWFNgւ̃|C^
    \return ΏۂɍWn𒣂tĂꍇ true / ȊȌꍇ false
  */
  virtual bool isObjectCrdMode(const CoordinateCtrl* crd) const {
    return false;
  }

  /*!
    \brief W[ΏۂƂ镨̂̈ʒuԂ

    ΏۂꍇÄʒuԂ

    \return W[̐Ώۂ̈ʒu
  */
  virtual VXV::Position3D getLocalPosition(void) {
    return VXV::Position3D();
  }

  /*!
    \brief Wn̓o^폜
  */
  virtual void remove_crd(CoordinateCtrl* crd);

  /*!
    \brief Nortify v郂W[ƂĐ\

    Wnc[ɑ΂AWn̒ǉA폜AWn̑Ί֌W̍XVsꂽꍇɁAʒm\郂W[NX̃\bhĂяoB

    \attention P̃IuWFNgŁA񂱂̃\bhĂяoĂ͂ȂȂ
  */
  void registerCrdNortifyClient(void);

  /*!
    \brief Nortify ̗v艺
  */
  void unregisterCrdNortifyClient(void);

  /*!
    \brief Nortify Cxg̑M
  */
  void sendCrdNortify(int event);

  /*!
    \brief Nortify Cxg̒ʒm\bh

    WnCxgƂɁACxgʒm\IuWFNgɂ̃\bh]B

    \param event [i] Cxg̎
    \param crd [i] WnIuWFNgւ̃|C^
  */
  virtual void crdNortify(int event, const CoordinateCtrl* crd) {}

public:
  unsigned long crd_ticks; /*!< ^CX^v */
  VXV::Position3D crd_position; /*!< ʒuf[^ */
  std::vector<VXV::Grid3D> crd_points; /*!< _Qf[^ */

  /*!
    \brief 
  */
  typedef struct {
    VXV::Position3D position;	/*!< ̎n_ */
    long length;		/*!< ̒ */
  } line_t;
  std::vector<line_t> crd_lines; /*!< Q */
  typedef std::vector<VXV::Grid3D> polygon_t; /*!< |S` */
  std::vector<polygon_t> crd_polygons; /*!< |SQ */

  CoordinateCtrl(void);
  virtual ~CoordinateCtrl(void);

  /*!
    \brief Wň_ʒuԂ

    Wn̎wʒuAw肵Wn̂ǂ̈ʒuɑ邩Ԃ

    \param crd [i] WnIuWFNgւ̃|C^
    \param position [i] Wnɂʒu

    \return wWnɂAWn̎wʒu
  */
  VXV::Position3D getCrdPosition(const CoordinateCtrl* crd = NULL,
				 const VXV::Position3D& position
				 = VXV::Position3D()) const;

  /*!
    \brief eWñ|C^Ԃ

    \return eWnIuWFNgւ̃|C^
  */
  CoordinateCtrl* getParentCrd(void);

  /*!
    \brief c[̃[gWnւ̃|C^Ԃ

    \return [gWnIuWFNgւ̃|C^
  */
  CoordinateCtrl* getRootCrd(void);

  /*!
    \brief eWn̐ݒ

    wWn̎wʒuɁAWň_`

    \param parent [i] WnIuWFNgւ̃|C^
    \param offset [i] Wnɂʒu
  */
  void setOwnCrdToCrd(CoordinateCtrl* parent, const VXV::Position3D&
		      offset = VXV::Position3D());

  /*!
    \brief qWñ|C^i[XgԂ

    \return qWnIuWFNgւ̃|C^i[Xg
  */
  std::list<CoordinateCtrl*>& getChildCrd(void);

  /*!
    \brief eWn̂ǂɌ_ʒu`Ă邩Ԃ

    \return eWnɂ鎩Wň_ʒu
  */
  VXV::Position3D getParentCrdOffset(void);

  /*!
    \brief eWnɒ`錴_ʒuݒ

    \param offset [i] eWnɂ鎩Wň_ʒu
  */
  void updateParentCrdOffset(const VXV::Position3D& offset);

  /*!
    \brief Wnʒu̒

    wWn̎wʒuƎWň_ʒuɂȂ悤ɁAWn̐eƂ̑Ί֌WXV

    \param crd [i] WnIuWFNgւ̃|C^
    \param position [i] Wnɂ鎩Wň_ʒu

    \attention ȉ̍Wnɑ΂Ẵ\bhĂł͂ȂȂ
  */
  void adjustCrdPosition(const VXV::Position3D& position,
			 const CoordinateCtrl* crd = NULL);

  /*!
    \brief W[Ǘ鐧ΏۂɍWn`

    W[ ObjCoordinateCtrl ̏ꍇA̐Ώۂ̑ΈʒuɎWn`邱ƂłB̏ꍇAWn̓W[̐ΏۈʒuړɔAړ邱ƂɂȂB

    \param crd [i] ΏۂWnIuWFNgւ̃|C^
    \param offset [i] Wnɂʒu
  */
  void setOwnCrdToObject(ObjCoordinateCtrl* crd, const VXV::Position3D&
			 offset = VXV::Position3D());
};


/*!
  \brief Wn䃂W[̗O
*/
class CrdCtrl_Exception : public std::exception {
  std::string error_message;

public:
  /*!
    \brief bZ[Ww肵ėO𓊂
  */
  CrdCtrl_Exception(const char* message) throw ()
    : error_message(message){}
  virtual ~CrdCtrl_Exception(void) throw () {}

  /*!
    \brief O̕Ԃ

    \todo Lq
  */
  virtual const char* what(void) const throw() {
    return error_message.c_str();
  }
};

#endif /* !COOTRDINATE_CTRL_H */
