/*
  Aj[VT[tF[X̕`NX
  Satofumi KAMIMURA
  $Id$
*/

#include "animationSurface.h"
#include "deleteObjects.h"


AnimationSurface::AnimationSurface(void) : ticks_msec(0), cycle(0) {
  w = 0;
  h = 0;
}


AnimationSurface::~AnimationSurface(void) {
  for_each(cells.begin(), cells.end(), DeleteObjects());
  cells.clear();
}


bool AnimationSurface::draw(const VXV::Rect& size, const VXV::Grid& pos,
			    unsigned long ticks) {
  if (cycle <= 0) {
    return false;
  }

  long time = ticks % cycle;
  for (std::vector<CellInformation>::iterator it = cell_info.begin();
       it != cell_info.end(); ++it) {
    time -= it->ticks * ticks_msec;
    if (time < 0) {
      // `
      DrawSurface *surface = cells[it->index];
      surface->draw(VXV::Rect(surface->w, surface->h),
		    pos + it->offset, ticks);
      break;
    }
  }
  return true;
}


void AnimationSurface::sizeUpdate(DrawSurface* surface) {
  w = (w < surface->w) ? surface->w : w;
  h = (h < surface->h) ? surface->h : h;
}


int AnimationSurface::addCell(const char* bmpFile, bool transparent) {
  DrawSurface* surface = new DrawSurface(bmpFile, transparent);
  cells.push_back(surface);
  sizeUpdate(surface);

  return static_cast<int>(cells.size() -1);
}


int AnimationSurface::addCell(SDL_Surface* sdlSurface, bool transparent) {
  DrawSurface* surface = new DrawSurface(sdlSurface, transparent);
  cells.push_back(surface);
  sizeUpdate(surface);

  return static_cast<int>(cells.size() -1);
}


void AnimationSurface::addCellInformation(const CellInformation& info) {
  cell_info.push_back(info);
}


void AnimationSurface::setTicksMsec(unsigned long msec) {
  ticks_msec = msec;
  cycle = static_cast<int>(cells.size() * ticks_msec);

  // CellInformation ]āAZ̕`ꏊ
  for (std::vector<CellInformation>::iterator it = cell_info.begin();
       it != cell_info.end(); ++it) {
    DrawSurface* surface = cells[it->index];

    it->offset.x = 0;
    if (it->align & VXV::Center) {
      it->offset.x = w/2 - surface->w/2;
    } else if (it->align & VXV::Right) {
      it->offset.x = w - surface->w;
    }
    it->offset.y = 0;
    if (it->align & VXV::Middle) {
      it->offset.y = h/2 - surface->h/2;
    } else if (it->align & VXV::Bottom) {
      it->offset.y = h - surface->h;
    }
  }
}
