#ifndef BASIC_DRAW_H
#define BASIC_DRAW_H

/*!
  \file
  \brief {}`̕`
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "ttfDraw.h"
#include "drawSurface.h"
#include "labelComponent.h"
#include <vector>
#include <deque>


/*!
  \brief {}``̃C^[tF[X

  \todo ӖsȂ̂ǂɂ
  \todo DrawAreaCtrl ÃNX폜
*/
class BasicDrawInterface {
protected:
  static VXV::Grid view_pos;	/*!< `ʒu */
  static VXV::Rect view_range;	/*!< `͈ */
  static double view_magnify;	/*!< pixel ̊g嗦 */

public:
  virtual ~BasicDrawInterface(void) {}

  /*!
    \brief `ʒu̐ݒ

    \param pos [i] `ʒu
    \param range [i] `͈
    \param magnify [i] pixel ̊g嗦
  */
  static void setDrawPosition(const VXV::Grid& pos, const VXV::Rect& range,
			      double magnify);

  /*!
    \brief `
  */
  virtual void draw(void) = 0;

  /*!
    \brief {}`̕`

    \param pos [i] `ʒu
    \param range [i] \ WindowʒuA`͈ [pixel]
    \param magnify [i] pixel̊g嗦 [1]
  */
  void draw(const VXV::Grid& pos, const VXV::Rect& range, double magnify);

  /*!
    \brief `_̈ʒuA傫vZ

    \param pos [i] `ʒu
    \param range [i] `͈
    \param magnify [i] pixel ̊g嗦
    \return `悷ׂ`
  */
  VXV::Rect calcPixelRange(const VXV::Grid& pos, const VXV::Rect& range,
			   double magnify);

  /*!
    \brief _̕`

    \param pixel_range [i] _̕`͈
    \param x [i] Xʒu
    \param y [i] Yʒu
  */
  void drawRangedPixel(const VXV::Rect& pixel_range, int x, int y);
};


/*!
  \brief _̕`
*/
class PixelDraw : public BasicDrawInterface {
  VXV::Grid draw_pos;
  unsigned long draw_color;
  static unsigned long static_draw_color;

public:
  /*!
    \brief _̕`

    \param x [i] Xl
    \param y [i] Yl
    \param color [i] F
  */
  PixelDraw(int x, int y, unsigned long color = White);
  virtual ~PixelDraw(void) {}
  void draw(void);

  /*!
    \brief `F̓o^

    \param color [i] `F
  */
  static void setColor(unsigned long color);

  /*!
    \brief `ƈʒu̓o^

    \param x [i] Xl
    \param y [i] Yl
  */
  static void setPixel(int x, int y);
};


/*!
  \brief _Q̕`
*/
class PixelGroupDraw : public BasicDrawInterface {
  std::vector<VXV::Grid> draw_points;
  unsigned long draw_color;

public:
  /*!
    \brief _Q̕`

    \param points [i] _Q
    \param color [i] F
  */
  PixelGroupDraw(std::vector<VXV::Grid>& points,
		 unsigned long color = White);
  virtual ~PixelGroupDraw(void) {}
  void draw(void);
};


/*!
  \brief ̕`
*/
class LineDraw : public BasicDrawInterface {
  VXV::Grid draw_p0, draw_p1;
  unsigned long draw_color;

public:
  /*!
    \brief `

    \param p0 [i] n_
    \param p1 [i] I_
    \param color [i] F
  */
  LineDraw(const VXV::Grid& p0, const VXV::Grid& p1,
	   unsigned long color = White);
  virtual ~LineDraw(void) {}
  void draw(void);
};


/*!
  \brief A̕`
*/
class ContLineDraw : public BasicDrawInterface {
  std::deque<LineDraw*> draw_lines;

public:
  /*!
    \brief A̕`

    \param points [i] ̍\_Q
    \param color [i] F
  */
  ContLineDraw(const std::deque<VXV::Grid>& points,
	       unsigned long color = White);
  virtual ~ContLineDraw(void);
  void draw(void);
};


/*!
  \brief ~̕`
*/
class CircleDraw : public BasicDrawInterface {
  VXV::Grid draw_p;
  int draw_r;
  unsigned long draw_color;

public:
  /*!
    \brief ~̕`

    \param p [i] S_
    \param r [i] a
    \param color [i] F
  */
  CircleDraw(const VXV::Grid& p, int r, unsigned long color = White);
  virtual ~CircleDraw(void) {}
  void draw(void);
};


/*!
  \brief ̕`
*/
class TextDraw : public BasicDrawInterface {
  DrawSurface* surface;
  LabelComponent* label;
  VXV::Grid draw_pos;
  bool pined;

public:
  /*!
    \brief ̕`

    \param ttf [i] TrueTypeFont 
    \param text [i] `敶
    \param text_pos [i] `ʒu
    \param pxSize [i] TCY
    \param pin [i] WnɌŒ肷ꍇ true
    \param color [i] F
    \param background [i] wiF
  */
  TextDraw(TTF_Draw& ttf, const char* text,
	   const VXV::Grid& text_pos, int pxSize = 16, bool pin = false,
	   unsigned long color = White, unsigned long background = Black,
	   bool transparent = false);
  virtual ~TextDraw(void);
  void draw(void);
};

#endif /* !BASIC_DRAW_H */
