/*
  `FbN{bNX̃R|[lg
  Satofumi KAMIMURA
  $Id$
*/

#include "checkBoxComponent.h"


DrawSurface* CheckBoxComponent::check_surface = NULL;


CheckBoxComponent::CheckBoxComponent(TTF_Draw& ttf_obj)
  : ttf(ttf_obj), now_state(false), length(16), activated(false),
    text_color(White), box_back(Black), box_border(White),
    box_label(NULL), check_label(NULL), draw_label(NULL),
    inner_box(NULL), outer_box(NULL), box(NULL) {
  w = 0;
  h = 0;
  position = VXV::Grid(0, 0);
}


CheckBoxComponent::~CheckBoxComponent(void) {
  delete box_label;
  delete draw_label;
  delete check_label;

  delete box;
  delete inner_box;
  delete outer_box;
}


void CheckBoxComponent::setLabel(LabelComponent* label) {
  draw_label = label;
}


void CheckBoxComponent::setLength(int box_length) {
  length = box_length;
}


void CheckBoxComponent::setColor(unsigned long text,
				 unsigned long back, unsigned long border) {
  text_color = text;
  box_back = back;
  box_border = border;
}


void CheckBoxComponent::activate(void) {
  if (activated) {
    return;
  }

  // `FbNT[tFX̍쐬
  if (!check_surface) {
    Uint16 check_str[] = { 0x30ec, 0x0000 }; // 
    check_surface = new DrawSurface(ttf.createText(check_str, length *2/3, Red,
						   Red -0x04000000), true);
  }
  check_label = new LabelComponent(check_surface);

  // {bNXT[tFX̍쐬
  outer_box = new FillSurface(VXV::Rect(length, length), box_border);
  inner_box = new FillSurface(VXV::Rect(length *4/5, length *4/5), box_back);
  box = new MultiSurface(VXV::Rect(length, length));
  box->addSurface(outer_box);
  box->addSurface(inner_box, VXV::Center | VXV::Middle);
  box_label = new LabelComponent(box);
  w = box->w * 3/2;

  if (draw_label) {
    w += draw_label->w;
    h += draw_label->h;
  }
  activated = true;
}


bool CheckBoxComponent::draw(unsigned long ticks, const UserInput& ui) {
  if (!activated) {
    return true;
  }

  // Og̕`
  VXV::Grid box_offset;
  if (draw_label) {
    box_offset = VXV::Grid(0, (draw_label->h - length)/2);
  }
  box_label->setPosition(position + box_offset);
  box_label->draw(ticks, ui);

  // gNbNꂽǂ
  int mx = ui.mpos.x;
  int my = ui.mpos.y;
  VXV::Rect judge_rect =
    VXV::Rect(position.x + box_offset.x, position.y + box_offset.y,
	      position.x + box_offset.x + length,
	      position.y + box_offset.y + length);
  if (ui.left_release &&
      (mx >= judge_rect.x) && (mx <= judge_rect.w) &&
      (my >= judge_rect.y) && (my <= judge_rect.h)) {
    now_state = !now_state;
  }

  // `FbN̕`
  if (now_state) {
    VXV::Grid check_offset = VXV::Grid((box_label->w - check_label->w)/2,
				       (box_label->h - check_label->h)/2 +1);
    VXV::Grid check_pos = position + box_offset + check_offset;
    check_label->setPosition(check_pos);
    check_label->draw(ticks, ui);

    check_label->setPosition(check_pos + VXV::Grid(1, 0));
    check_label->draw(ticks, ui);
  }

  // x̕`
  if (draw_label) {
    draw_label->setPosition(position + VXV::Grid(length *3/2, 0));
    draw_label->draw(ticks, ui);
  }
  return true;
}


void CheckBoxComponent::beginFocus(void) {
}


void CheckBoxComponent::endFocus(void) {
}


bool CheckBoxComponent::getNowChecked(void) {
  return now_state;
}


void CheckBoxComponent::setNowChecked(bool on) {
  now_state = on;
}
