#ifndef CHECK_BOX_COMPONENT_H
#define CHECK_BOX_COMPONENT_H

/*!
  \file
  \brief `FbN{bNX̃R|[lg
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "labelComponent.h"
#include "multiSurface.h"
#include "fillSurface.h"
#include "drawSurface.h"
#include "ttfDraw.h"


/*!
  \brief `FbN{bNX̕`NX
*/
class CheckBoxComponent : public FocusComponentInterface {
  TTF_Draw& ttf;
  bool now_state;
  int length;
  bool activated;
  unsigned long text_color;
  unsigned long box_back;
  unsigned long box_border;
  LabelComponent* box_label;
  LabelComponent* check_label;
  LabelComponent* draw_label;

  static DrawSurface* check_surface;
  FillSurface* inner_box;
  FillSurface* outer_box;
  MultiSurface* box;

public:
  /*!
    \brief TTF \[Xw̃RXgN^

    \param ttf_obj [i] TTF \[X
  */
  CheckBoxComponent(TTF_Draw& ttf_obj);
  ~CheckBoxComponent(void);

  /*!
    \brief `FbN{bNXɃx`

    \param label [i] `FbN{bNXƈꏏɕ`悷郉x
  */
  void setLabel(LabelComponent* label);

  /*!
    \brief `FbN{bNX̃{bNX

    \param box_length [i] `FbN{bNX̊O̕ [pixel]
  */
  void setLength(int box_length);
  void setColor(unsigned long text,
		unsigned long back = Black, unsigned long border = White);
  void activate(void);
  bool draw(unsigned long ticks, const UserInput& ui);
  void beginFocus(void);
  void endFocus(void);
  bool getNowChecked(void);
  void setNowChecked(bool on);
};

#endif /* !CHECK_BOX_COMPONENT_H */
