/*
  R{{bNX̃R|[lg
  Satofumi KAMIMURAJ
  $Id$
*/

#include "comboBoxComponent.h"
#include "deleteObjects.h"


ComboBoxComponent::ComboBoxComponent(TTF_Draw& ttf_resource)
  : ttf(ttf_resource),
    fore_color(Black), back_color(White),
    focused_fore_color(White), focused_back_color(Blue),
    menu(NULL), selected_item(NULL), selected_surface(NULL),
    button_label(NULL), button_surface(NULL), button_offset(VXV::Grid(0,0)),
    fill_normal(NULL), fill_focused(NULL), now_index(0), view_list(false),
    font_size(DefaultFontSize), focused(false), decided(false) {
  w = 0;
  h = 0;
  position = VXV::Grid(0, 0);
}


ComboBoxComponent::~ComboBoxComponent(void) {
  deleteObject();
}


void ComboBoxComponent::deleteObject(void) {
  for_each(items_normal.begin(), items_normal.end(), DeleteObjects());
  items_normal.clear();

  for_each(items_focused.begin(), items_focused.end(), DeleteObjects());
  items_focused.clear();

  for_each(surface_normal.begin(), surface_normal.end(), DeleteObjects());
  surface_normal.clear();

  for_each(surface_focused.begin(), surface_focused.end(), DeleteObjects());
  surface_focused.clear();

  delete selected_item;
  selected_item = NULL;

  delete button_label;
  button_label = NULL;

  delete button_surface;
  button_surface = NULL;

  delete selected_surface;
  selected_surface = NULL;

  delete fill_normal;
  fill_normal = NULL;

  delete fill_focused;
  fill_focused = NULL;

  delete menu;
  menu = NULL;
}


bool ComboBoxComponent::draw(unsigned long ticks, const UserInput& ui) {
  // ڂȂ΁A߂
  if (items.empty()) {
    return true;
  }

  // ڂ̕`
  selected_item->setPosition(position);
  selected_item->draw(ticks, ui);

  // {^̕`
  button_label->setPosition(position + button_offset, VXV::Middle);
  button_label->draw(ticks, ui);

  // Iڂ̕`
  menu->setPosition(position + VXV::Grid(0, selected_item->h));
  menu->draw(ticks, ui);

  // Xg̕`掞̏
  if (selected_item->isPressed() ||
      (!view_list && focused &&
       ((ui.state.isPressedCode(SDLK_DOWN) ||
	 (ui.state.ctrl_pressed && ui.state.isPressedCode(SDLK_n)))))) {
    view_list = !view_list;
    menu->hide(!view_list);

  } else if (menu->isDecided()) {
    // Ȉ
    decided = true;
    view_list = !view_list;
    int index = menu->getNowIndex();
    if (index >= 0) {
      setNowIndex(index);
    }
    menu->hide(!view_list);
    menu->activate(true);

  } else if (ui.state.left_released) {
    view_list = false;
    menu->hide(true);
  }
  return true;
}


void ComboBoxComponent::add(const Uint16* text) {
  add_text.push_back(text);
}


void ComboBoxComponent::add(const char* text) {
  int n = static_cast<int>(strlen(text)) +1;
  Uint16* p = new Uint16[n];
  for (int i = 0; i < n; ++i) {
    p[i] = text[i];
  }
  add_text.push_back(p);
  char_text.push_back(p);
}


void ComboBoxComponent::setColor(unsigned long fore, unsigned long back,
				 unsigned long focused_fore,
				 unsigned long focused_back) {
  fore_color = fore;
  back_color = back;
  focused_fore_color = focused_fore;
  focused_back_color = focused_back;
}


void ComboBoxComponent::setFontSize(int size) {
  font_size = size;
}


void ComboBoxComponent::updateSelected(void) {
  if (items.empty()) {
    return;
  }

  delete selected_surface;
  selected_surface = new MultiSurface(VXV::Rect(fill_normal->w,
						fill_normal->h));
  selected_surface->addSurface(fill_normal);
  selected_surface->addSurface(surface_normal[now_index]);

  delete selected_item;
  selected_item = new ButtonComponent(selected_surface);
}


void ComboBoxComponent::activate(bool on) {

  // T[tFX̍쐬
  deleteObject();
  for (std::vector<const Uint16*>::iterator it = add_text.begin();
       it != add_text.end(); ++it) {
    DrawSurface* normal =
      new DrawSurface(ttf.createText(*it, font_size, fore_color, back_color));
    DrawSurface* focused =
      new DrawSurface(ttf.createText(*it, font_size,
				     focused_fore_color, focused_back_color));
    surface_normal.push_back(normal);
    surface_focused.push_back(focused);

    w = (normal->w > w) ? normal->w : w;
    h = (normal->h > h) ? normal->h : h;
  }
  for (std::vector<Uint16*>::iterator it = char_text.begin();
       it != char_text.end(); ++it) {
    delete [] *it;
  }
  add_text.clear();
  char_text.clear();

  // {^̍쐬
  int btn_size = font_size >> 1;
  btn_size = (btn_size < 12) ? 12 : btn_size;
  if (!button_surface) {
    Uint16 button_text[] = { 0x25bc, 0x0000 }; //  ̕
    button_surface = new DrawSurface(ttf.createText(button_text, btn_size,
						    fore_color, back_color));
    button_label = new LabelComponent(button_surface);
    button_offset = VXV::Grid(w + btn_size/3, h/2);
  }
  w += button_surface->w + btn_size/2;

  // wi̍쐬
  delete fill_normal;
  VXV::Rect fill_rect = VXV::Rect(w, h);
  fill_normal = new FillSurface(fill_rect, back_color);
  delete fill_focused;
  fill_focused = new FillSurface(fill_rect, focused_back_color);


  // ڃ{^̍쐬
  menu = new MenuComponent();
  menu->defaultSelection(false);
  std::vector<DrawSurface*>::iterator focused = surface_focused.begin();
  for (std::vector<DrawSurface*>::iterator normal = surface_normal.begin();
       normal != surface_normal.end(); ++normal, ++focused) {

    MultiSurface* multi = new MultiSurface(VXV::Rect(w, h));
    multi->addSurface(fill_normal);
    multi->addSurface(*normal);
    items_normal.push_back(multi);
    ButtonComponent* button = new ButtonComponent(multi);

    multi = new MultiSurface(VXV::Rect(w, h));
    multi->addSurface(fill_focused);
    multi->addSurface(*focused);
    items_focused.push_back(multi);
    button->setFocusedSurface(multi);
    items.push_back(button);

    menu->add(button);
  }

  // menu ̐
  menu->hide(true);
  menu->activate(true);

  updateSelected();
}


void ComboBoxComponent::setNowIndex(int index) {
  now_index = index;
  if (menu) {
    menu->setNowIndex(index);
  }
  updateSelected();
}


bool ComboBoxComponent::isDecided(void) {
  return decided;
}


unsigned int ComboBoxComponent::getNowIndex(void) {
  decided = false;
  return now_index;
}


void ComboBoxComponent::beginFocus(void) {
  focused = true;
  view_list = true;
  menu->hide(false);
}


void ComboBoxComponent::endFocus(void) {
  focused = false;
  view_list = false;
  menu->hide(true);
}
