/*
  T[tFX̕`NX
  Satofumi KAMIMURA
  $Id$
*/

#include "drawSurface.h"


DrawSurface::DrawSurface(void) : surface(NULL) {
}


DrawSurface::DrawSurface(const char* bmpFile, bool transparent) {
  load(bmpFile, transparent);
}


DrawSurface::DrawSurface(SDL_Surface* sdlSurface, bool transparent) {
  load(sdlSurface, transparent);
}


DrawSurface::~DrawSurface(void) {
  if (surface) {
    SDL_FreeSurface(surface);
  }
}


bool DrawSurface::draw(const VXV::Rect& size, const VXV::Grid& pos,
		       unsigned long ticks) {
  if (!surface) {
    return false;
  } else {

    SDL_Video::blitSurface(surface, size, pos);
    return true;
  }
}


void DrawSurface::setSize(void) {
  if (surface) {
    w = surface->w;
    h = surface->h;
  } else {
    w = 0;
    h = 0;
  }
}


SDL_Surface* DrawSurface::surfaceTransparent(SDL_Surface* sdlSurface) {
  if (surface->format->palette) {
    SDL_SetColorKey(surface, (SDL_SRCCOLORKEY | SDL_RLEACCEL),
		    *(Uint8 *)surface->pixels);
  }
  SDL_Surface *temp = SDL_DisplayFormat(surface);
  SDL_FreeSurface(surface);

  return temp;
}


void DrawSurface::load(const char* bmpFile, bool transparent) {
  surface = SDL_LoadBMP(bmpFile);
  if (!surface) {
    throw SDL_Exception();
  }
  if (transparent) {
    surface = surfaceTransparent(surface);
  }
  setSize();
}


void DrawSurface::load(SDL_Surface* sdlSurface, bool transparent) {
  surface = sdlSurface;
  if (transparent) {
    surface = surfaceTransparent(sdlSurface);
  }
  setSize();
}
