#ifndef SURFACE_DRAW_H
#define SURFACE_DRAW_H

/*!
  \file
  \brief T[tFX̕`NX
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "surfaceInterface.h"
#include "sdlVideo.h"


/*!
  \brief T[tFX̕`NX
*/
class DrawSurface : public SurfaceInterface {
  SDL_Surface* surface;
  void setSize(void);
  SDL_Surface* surfaceTransparent(SDL_Surface* sdlSurface);

public:
  DrawSurface(void);

  /*!
    \brief T[tFXw̃RXgN^

    \param bmpFile [i] rbg}bvt@C
    \param transparent [i] ߏ{ꍇ true
  */
  DrawSurface(const char* bmpFile, bool transparent = false);

  /*!
    \brief SDLT[tFXw̃RXgN^

    \param sdlSurface [i] SDLT[tFX
    \param transparent [i] ߏ{ꍇ true
  */
  DrawSurface(SDL_Surface* sdlSurface, bool transparent = false);
  virtual ~DrawSurface(void);
  bool draw(const VXV::Rect& size,
	    const VXV::Grid& pos, unsigned long ticks);

  /*!
    \brief T[tFX̓ǂݍ

    \param bmpFile [i] rbg}bvt@C
    \param transparent [i] ߏ{ꍇ true
  */
  void load(const char* bmpFile, bool transparent = false);

  /*!
    \brief T[tFX̓ǂݍ

    \param sdlSurface [i] SDLT[tFX
    \param transparent [i] ߏ{ꍇ true
  */
  void load(SDL_Surface* sdlSurface, bool transparent = false);
};

#endif /* !SURFACE_DRAW_H */
