#ifndef SCROLL_AREA_COMPONENT_H
#define SCROLL_AREA_COMPONENT_H

/*!
  \file
  \brief XN[eLXg\

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ttfDraw.h"
#include "typeUtils.h"
#include "sdlWindow.h"
#include <stdarg.h>
#include <deque>


/*!
  \brief XN[eLXg̈̕`NX

  \todo ListViewComponent ÃNX폜
*/
class ScrollAreaComponent : public ComponentInterface {
  enum { InvalidEndl = -1 };

  TTF_Draw& ttf;
  int px_size;
  typedef struct {
    unsigned long fore;
    unsigned long back;
  } colors_t;
  colors_t set_color;
  VXV::Rect draw_rect;
  typedef struct {
    Uint16 ch;
    char width;
    colors_t color;
  } draws_t;
  std::deque<draws_t> texts;

  VXV::Grid drawChar(draws_t& dch,
		     const VXV::Grid& position, VXV::Grid& cursor);
  void setCh(const Uint16 ch, int width = 1);
  void createEndl(VXV::Grid& cursor, int& first_endl,
		  std::deque<draws_t>::iterator& it);

public:
  ScrollAreaComponent(TTF_Draw& ttfObj, const VXV::Rect& drawRect);
  ~ScrollAreaComponent(void);
  bool draw(unsigned long ticks, const UserInput& ui);

  void setColor(unsigned long color, unsigned long back = Gray4);
  void setPxelSize(int pxelSize);

  // ̂ 1byte ̂
  int printf(const char *fmt, ...);
  int printf(const char *fmt, va_list ap);
  void drawUnicode(const Uint16* text);
  void clear(void);
};

#endif /* !SCROLL_AREA_COMPONENT_H */
