#ifndef SDL_WINDOW_H
#define SDL_WINDOW_H

/*!
  \file
  \brief SDL  Window NX
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "sdlVideo.h"
#include "windowInterface.h"


/*!
  \brief SDL  Window NX
*/
class SDL_Window : public SDL_Video, public WindowInterface {
public:
  /*!
    \brief tXN[w̃RXgN^

    \param fullscreen [i] tXN[ŋNꍇ true
  */
  SDL_Window(bool fullscreen = false);
  ~SDL_Window(void);

  void setTitle(const char *title, const char *icon);
  void autoHideCursor(int waitMsec);
  void activate(bool on);
  unsigned long getTicks(void);
  void delay(unsigned long ticks);
  void lock(void);
  void unlock(void);
  void add(ComponentInterface* component, char depth);
  void del(ComponentInterface* component, char depth);
  void clear(char depth);
  void addInputComponent(FocusComponentInterface* component, char depth);
  void toggleFocus(void);
  void setFocus(FocusComponentInterface* component);
  void setFullscreen(bool on);
  bool getNowFullscreen(void);
};

#endif /* !SDL_WINDOW_H */
