#ifndef TEXT_INPUT_COMPONENT_H
#define TEXT_INPUT_COMPONENT_H

/*!
  \file
  \brief L[͗p̃R|[lg
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "ttfDraw.h"
#include "fillSurface.h"
#include "labelComponent.h"
#include "focusComponentInterface.h"


/*!
  \brief eLXg͘g
*/
class TextInputComponent : public FocusComponentInterface {
  enum { BufferSize = 256 };
  TTF_Draw& ttf;
  int px_size;
  VXV::Rect draw_rect;
  unsigned long fore_color;
  unsigned long back_color;
  int buffer_max;
  bool decided;
  bool ctrl_disable;

public:
  std::list<unsigned short> inputed;

private:
  std::list<unsigned short>::iterator cursor_it;

  FillSurface* back_surface;

  void addInputToBuffer(const UserInput& ui);
  bool drawChar(Uint16 ch, unsigned long fore,
		unsigned long back, VXV::Grid& next);
  TextInputComponent(void);

public:
  TextInputComponent(TTF_Draw& ttfObj, int pxSize, const VXV::Rect& size,
		     unsigned long color = White, unsigned long back = Black);
  ~TextInputComponent(void);
  void setBufferMax(int maxSize);
  bool draw(unsigned long ticks, const UserInput& ui);
  // !!! ϊIuWFNg̎󂯎
  void clear(void);
  void setText(const char* text);
  // setColor
  // !!! J[\[܂ōsƂɁAXN[镝Zbg

  void activate(bool on);
  bool isDecided(void);
  void disable(bool on);
  void beginFocus(void);
  void endFocus(void);
};

#endif /* !TEXT_INPUT_COMPONENT_H */
