/*
  Ot@C
  Satofumi KAMIMURA
  $Id$
*/

#include "logCtrl.h"
#include "vexception.h"


LogCtrl::LogCtrl(const char *fname, bool write)
  : mutex(SDL_CreateMutex()), logfile(fname), moduleTagTerminated(false),
    now_stream(""), now_line(0), line(""),
    fin(NULL), fd(NULL) {
  if (!logfile && write) {
    logfile = "/dev/null";
  }

  lock();
  if (write) {
    fd = fopen(logfile, "w");
  } else {
    fin = new std::ifstream(logfile);
  }
  if ((write && !fd) || (!write && !*fin)) {
    perror("");
    std::string error_message = std::string("Couldn't open: ") + logfile;
    throw VMonitor_Exception(error_message.c_str());
  }

  unlock();
}


LogCtrl::~LogCtrl(void) {
  flush();
  if (fd) {
    fclose(fd);
  }
  if (fin) {
    fin->close();
  }
  SDL_DestroyMutex(mutex);
}


void LogCtrl::lock(void) {
  SDL_LockMutex(mutex);
}


void LogCtrl::unlock(void) {
  SDL_UnlockMutex(mutex);
}


void LogCtrl::flush(void) {
  if (fd) {
    terminateModuleTag();
    fflush(fd);
  }
}


void LogCtrl::terminateModuleTag(void) {
  if (!moduleTagTerminated) {
    fprintf(fd, "</%s>\n", now_stream.c_str());
    now_stream = "";
    moduleTagTerminated = true;
  }
}


void LogCtrl::writeTag(const char *module,
		       const char* command, unsigned long ticks) {

  if (now_stream.compare(module)) {
    if (!now_stream.empty()) {
      terminateModuleTag();
    }
    now_stream.assign(module);
    fprintf(fd, "<%s>\n", module);
    moduleTagTerminated = false;
  }
  fprintf(fd, "  <%s ticks=%ld", command, ticks);
}


void LogCtrl::writeTagEnd(void) {
  fprintf(fd, ">\n");
}


const char* LogCtrl::readLine(void) {
  ++now_line;
  getline(*fin, line);
  return line.c_str();
}


const char* LogCtrl::getLineBuffer(void) {
  return line.c_str();
}


void LogCtrl::readModuleTag(const char* line) {
  char module_tag[] = { '\0','\0','\0','\0','\0','\0','\0','\0','\0','\0' };
  sscanf(line, "<%s", module_tag);
  module_tag[strlen(module_tag) -1] = '\0';
  now_stream.assign(module_tag);
}


bool LogCtrl::checkModuleEnd(const char* line) {
  if ((strlen(line) > 2) && !strncmp("</", line, 2)) {
    return true;
  } else {
    return false;
  }
}


void LogCtrl::throwMissmathException(void) {

  char *message = new char [80 + strlen(logfile)];
  if (fin->eof()) {
    sprintf(message, "%s:%d: Log data is terminated", logfile, now_line);
  } else {
    sprintf(message, "%s:%d: Missmatch log between program and data",
	    logfile, now_line);
  }
  std::string error_message = message;
  delete [] message;
  throw VMonitor_Exception(error_message.c_str());
}


unsigned long LogCtrl::readTag(const char *module, const char* command) {

  if (now_stream.empty()) {
    readModuleTag(readLine());
  }

  // ǂݏoāA</module> łȂ΁A̍s̓eێ
  if (checkModuleEnd(readLine())) {
    now_stream.assign("");
    return readTag(module, command);
  } else {
    // module̓ǂݏo
    if (now_stream.compare(module)) {
      fprintf(stderr, "expected: %s, actual: %s\n", module,now_stream.c_str());
      throwMissmathException();
    }
    // commandAticksl̓ǂݏo
    char command_buf[80];
    unsigned long ticks = 0;
    sscanf(line.c_str(), "%s ticks=%ld", command_buf, &ticks);
    char* command_name = &command_buf[1];
    if (strcmp(command, command_name)) {
      fprintf(stderr, "expected: %s, actual: %s\n", command, command_name);
      throwMissmathException();
    }
    return ticks;
  }
}
