#ifndef M_RUN_CTROL_H
#define M_RUN_CTROL_H

/*!
  \file
  \brief j^Ή̑sNX

  \author Satofumi KAMIMURA

  $Id$
*/

#include "vmonitor.h"
#include "tRunCtrlSimulator.h"


/*!
  \brief j^Ή̑sNX
*/
class mRunCtrl : public RunCtrl {
  vmonitor* mon;
  int MonitorMode;
  SDL_cond* cond;
  SDL_mutex* mutex;
  tRunCtrl_Simulator* simulator;
  static bool isVersionPrinted;
  static bool isHelpPrinted;
  void printVersion(void);
  void printHelp(void);
  void parseArgs(int argc, char* argv[]);
  unsigned long getHostTicks(void);

  void writeLocalPosition(const VXV::Position3D& ret_pos, unsigned long ticks);
  void readLocalPosition(VXV::Position& ret_pos);
  void writeIsStable(bool ret_value, unsigned long ticks);
  bool readIsStable(void);
  void pauseLock(void);
  void pauseUnlock(void);

public:
  tRunCtrl_Simulator::TicksPosition& ticksPos; /*!< V~[^ߋʒu */

  mRunCtrl(void);
  virtual ~mRunCtrl(void);

  /*!
    \overload
  */
  int connect(void);

  /*!
    \overload

    \param device [i] ڑfoCX
    \param baudrate [i] ڑ{[[g
  */
  int connect(const char* device, long baudrate = Baudrate);

  /*!
    \overload

    \param argc [i] ̌
    \param argv [i] i[z
  */
  int connect(int argc, char *argv[]);

  /*!
    \overload

    \param setTicks [i] W[Ɏw肷^CX^v [msec]
  */
  void adjustOwnTicks(unsigned long setTicks);

  /*!
    \overload
  */
  VXV::Position3D getLocalPosition(void);

  /*!
    \overload
  */
  void stop(void);

  /*!
    \overload

    \param position [i] Ǐ]w
    \param crd [i] Wn
  */
  void followLine(const VXV::Position& position,
		  const CoordinateCtrl* crd = VXV::GL);

  /*!
    \overload

    \param center [i] Ǐ]~ʂ̒Sʒu
    \param radius [i] Ǐ]~̔a (radius > 0  CW, radius < 0  CCW)
    \param crd [i] Wn
  */
  void followCircle(const VXV::Grid& center, int radius,
		    const CoordinateCtrl* crd = VXV::GL);

  /*!
    \overload

    \param position [i] ړ_w
    \param radius [i] Ǐ]~̔a (radius > 0  CW, radius < 0  CCW)
    \param crd [i] Wn
  */
  void followCircleOnTangent(const VXV::Position& position, int radius,
			     const CoordinateCtrl* crd = VXV::GL);

  /*!
    \overload

    \param position [i] w蒼w
    \param crd [i] Wn
  */
  void stopToLine(const VXV::Position& position,
		  const CoordinateCtrl* crd = VXV::GL);

  /*!
    \overload

    \param direction [i] Ǐ]px
    \param crd [i] Wn
  */
  void rotateToDirection(const VXV::Direction& direction,
			 const CoordinateCtrl* crd = VXV::GL);


  /*!
    \overload

    \param direction [i] ]px
  */
  void rotateAngle(const VXV::Direction& direction);

  /*!
    \overload

    \param velocity [i] ]񑬓x
  */
  void spin(const VXV::Direction& velocity);

  /*!
    \overload

    \param crd [i] Wn
  */
  void lastMoveCommand(const CoordinateCtrl* crd = VXV::GL);


  /*!
    \overload
  */
  bool isStable(void);

  void servoCtrl(bool on);

  /*!
    \overload

    \param id [i] [^ID
    \param duty [i] PWM  [0, 255]
  */
  void setMotorPwm(int id, unsigned char duty);

  /*!
    \overload

    \param id [i] [^ID
    \param duty [i] PWM i[z
    \param nums [i] [^ID 牽̃[^ PWM w肷邩
  */
  void setMotorPwm(int id, unsigned char duty[], int nums);

  /*!
    \overload

    \param id [i] [^ID
    \param mode [i] [^̐䃂[h
  */
  void setMotorMode(int id, unsigned char mode);

  /*!
    \overload

    \param id [i] [^ID
    \param mode [i] 䃂[hi[z
    \param nums [i] [^ID 牽̃[^̐䃂[hw肷邩
  */
  void setMotorMode(int id, unsigned char mode[], int nums);
  //void getEncoderVel(int id, int *cnt);
  //void getEncoderVel(int id, int cnt[], int nums);
  //void getEncoderValue(int id, unsigned short *cnt);
  //void getEncoderValue(int id, unsigned short cnt[], int nums);

  /*!
    \overload

    \param id [i] ԗID
    \param mm_vel [i] ԗւ̈ړx [mm/sec]
  */
  void setWheelVel(int id, int mm_vel);

  /*!
    \overload

    \param id [i] ԗID
    \param mm_vel [i] ԗւ̈ړxi[z
    \param nums [i] ԗID 牽̈ړxw肷邩
  */
  void setWheelVel(int id, int mm_vel[], int nums);
};

#endif /* !M_RUN_CTROL_H */
