#ifndef MONITO_TASK_H
#define MONITO_TASK_H

/*!
  \file
  \brief ^XN̏Xbh
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "taskInterface.h"
#include "sdlBase.h"
#include <vector>
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#if !HAVE_CONFIG_H || HAVE_LIBSDL
#include <SDL_thread.h>
#endif
#include "runCtrl.h"

class vmonitor;
class ScreenTask;


/*!
  \brief j^^XN̐NX
*/
class MonitorTask : private SDL_Base {
  friend class ScreenTask;
  friend class URG_Simulator;
  friend class mRunCtrl;

  SDL_mutex* mutex;
  SDL_Thread* thread;
  static std::vector<TaskInterface*> tasks;
  static ScreenTask* scr;
  bool active;
  bool is_pause;
  unsigned long pre_total;
  unsigned long pre_ticks;
  double time_magnify;
  static VXV::Position3D bodyPosition;
  static RunCtrl* runObj;

  typedef struct {
    unsigned long ticks;
    SDL_cond* cond;
    SDL_mutex* mutex;
  } waits_t;
  std::vector<waits_t> waits;

  static unsigned long ticks;
  static int taskThread(void* args);

public:
  MonitorTask(void);
  ~MonitorTask(void);

  /*!
    \brief j^̃bN
  */
  void lock(void);

  /*!
    \brief j^̃AbN
  */
  void unlock(void);

  /*!
    \brief N̓o^

    \param wait_ticks [i] ҋ@ [msec]
    \param wait_cond [o] ϐ
    \param wait_mutex [o] bN
  */
  SDL_cond* setWakeupTicks(unsigned long wait_ticks,
			   SDL_cond* wait_cond, SDL_mutex* wait_mutex);

  /*!
    \brief ^CX^v̎擾

    \return ^CX^v [msec]
  */
  unsigned long getTicks(void);

  /*!
    \brief ^XN̓o^

    \param task [i] ^XN
  */
  void add(TaskInterface* task);

  /*!
    \brief ^XN̍폜

    \param task [i] ^XN
  */
  void del(TaskInterface* task);

  /*!
    \brief ꎞ~
  */
  void pause(void);

  /*!
    \brief ĊJ
  */
  void start(void);

  /*!
    \brief Ԃ̐is{ύX

    \param magnify [i] Ԃ̐is{
  */
  void setTimeMagnify(double magnify);

  /*!
    \brief w^CX^v܂őҋ@

    \param ticks [i] ^CX^v
    \param cond [o] ϐ
    \param wait_mutex [i] bN
  */
  void waitToTicks(unsigned long ticks, SDL_cond* cond, SDL_mutex* wait_mutex);

  /*!
    \brief R}hǂݏo܂őҋ@
  */
  void waitOnlyCommand(vmonitor* mon, int monitorMode,
		       SDL_cond* cond, SDL_mutex* wait_mutex,
		       const char* module, const char* command);

  void setRunObject(RunCtrl* run_obj);

  void setScreenObject(ScreenTask* scr_obj);

  static VXV::Position getRunPosition(void);
};

#endif /* !MONITO_TASK_H */
