/*
  s̕⏕֐
  Satofumi KAMIMURA
  $Id$
*/
#define C_RUNCTRL_SOURCE

#include "run_utils.h"
#include "detect_os.h"
#if defined Linux || defined NoSDL_Linux
#include <unistd.h>
#elif defined WINDOWS
#include <windows.h>
#endif

#include <math.h>
#include "math_util.h"


/*!
  \brief div16 ւ̊pxϊ

  \param degree [i] px [degree]
  \retval div16
*/
int deg(int degree) {
  return (int)(65536 * degree / 360);
}


/*!
  \brief div16 ւ̊pxϊ

  \param radian [i] px [radian]
  \retval div16
*/
int rad(double radian) {
  return (int)(65536 * radian / (2.0 * M_PI));
}


/*!
  \brief div16 ̊pxϊ

  \param div16 [i] px [div16]
  \retval px [degree]
*/
int to_deg(int div16) {
  return (360 * div16 / 65536);
}


/*!
  \brief div16 ̊pxϊ

  \param div16 [i] px [div16]
  \retval px [radian]
*/
double to_rad(int div16) {
  return (2.0 * M_PI * div16 / 65536.0);
}


/*!
  \brief mWait()p̕ϊ֐

  \param second [i]  [sec]
  \retval  [msec]
*/
int sec(double second) {
  return (1000.0 * second);
}


/*!
  \brief w莞Ԃҋ@

  \param msec [i] ҋ@ [msec]
  \retval Ȃ
*/
void mWait(int msec) {
#ifdef __linux__
  usleep(1000 * msec);
#elif __WIN32__ || _MBCS
  Sleep(msec);
#endif
}
