/*
  ړ
  Satofumi KAMIMURA
  $Id$
*/

#include "movingAverage.h"


void initMovingAverage(movingAverage_t *ma, int *buffer, int size_shift) {
  int i;

  ma->size = 1 << size_shift;
  ma->size_shift = size_shift;
  ma->index = 0;
  ma->buffer = buffer;
  ma->total = 0;
  for (i = 0; i < ma->size; ++i) {
    ma->buffer[i] = 0;
  }
}


void setMovingAverage(movingAverage_t *ma, int value) {
  ma->total += -ma->buffer[ma->index] + value;
  ma->buffer[ma->index] = value;
  ma->index = (ma->index + 1) & (ma->size - 1);
}


int getAverageValue(movingAverage_t *ma) {
  return ma->total >> ma->size_shift;
}
