#ifndef SERIAL_DEVICE_H
#define SERIAL_DEVICE_H

/*!
  \file
  \brief VAڑ

  \author Satofumi KAMIMURA
  \author Tomoaki YOSHIDA

  $Id$
*/

#include "connectionDevice.h"
#include "detect_os.h"
#ifdef Linux
#include <sys/poll.h>
#include <termios.h>
#else
#include <windows.h>
#include <string>
#include <vector>
#endif


/*!
  \brief RS232 ʐM
*/
class SerialDevice : public ConnectionDevice {
  int fd;
#ifdef Linux
  struct termios sio;           /*!< ʐM */
  struct pollfd nfds;           /*!< ^CAEg */
#else
  HANDLE hComm;
#endif

  std::string error_message;
  int raw_connect(const char* device, long baudrate);
  int raw_setBaudrate(long baudrate);
  void raw_flush(void);
  void raw_check(int size, long timeout);

protected:
  virtual void raw_disconnect(void);
  virtual int raw_send(const char* data, int len);

public:
  /*!
    \brief obt@TCYw̃RXgN^

    \param buffer_size [i] obt@TCY
  */
  SerialDevice(int buffer_size = BufferSize -1);
  ~SerialDevice(void);

  const char* what(void);
  bool isConnected(void);

#ifdef Windows
  //static std::vector<std::string> getComPorts(void);
#endif
};

#endif /* !SERIAL_DEVICE_H */
