/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kayo.io;

import jp.co.kayo.io.ReplayBuffer;

class ReplayHeader {
    ReplaySubHeader sub;
    byte[] header = new byte[28];
    long m_blocks;
    long m_header_ver;
    long m_offset;
    long m_size;
    long m_uncomp_size;

    ReplayHeader(ReplayBuffer replay) {
        replay.get(this.header, 0, 28);
        this.m_offset = replay.getInt();
        this.m_size = replay.getInt();
        this.m_header_ver = replay.getInt();
        this.m_uncomp_size = replay.getInt();
        this.m_blocks = replay.getInt();
        this.sub = this.m_header_ver == 0L ? new ReplaySubHeaderVer0(replay) : new ReplaySubHeaderVer1(replay);
    }

    public int getBuild() {
        return this.sub.getBuild();
    }

    public long getGameTime() {
        return this.sub.getGameTime();
    }

    public String getHeader() {
        return new String(this.header, 0, 26);
    }

    public String getMajorVer() {
        return "1." + this.sub.getMajorVer();
    }

    private static interface ReplaySubHeader {
        public int getBuild();

        public long getGameTime();

        public int getMajorVer();
    }

    private static class ReplaySubHeaderVer0
    implements ReplaySubHeader {
        int build;
        int flags;
        int major_ver;
        int minor_ver;
        long checksum;
        long length_ms;

        ReplaySubHeaderVer0(ReplayBuffer replay) {
            this.minor_ver = replay.getShort();
            this.major_ver = replay.getShort();
            this.build = replay.getShort();
            this.flags = replay.getShort();
            this.length_ms = replay.getInt();
            this.checksum = replay.getInt();
        }

        public int getBuild() {
            return this.build;
        }

        public long getGameTime() {
            return this.length_ms;
        }

        public int getMajorVer() {
            return this.major_ver;
        }
    }

    private static class ReplaySubHeaderVer1
    implements ReplaySubHeader {
        int build;
        int flags;
        int major_ver;
        int ver_str;
        long checksum;
        long length_ms;

        ReplaySubHeaderVer1(ReplayBuffer replay) {
            this.ver_str = replay.getInt();
            this.major_ver = replay.getInt();
            this.build = replay.getShort();
            this.flags = replay.getShort();
            this.length_ms = replay.getInt();
            this.checksum = replay.getInt();
        }

        public int getBuild() {
            return this.build;
        }

        public long getGameTime() {
            return this.length_ms;
        }

        public int getMajorVer() {
            return this.major_ver;
        }

        String getVerstr() {
            String hex = Long.toHexString(this.ver_str);
            byte[] b = new byte[]{Byte.parseByte(hex.substring(0, 2), 16), Byte.parseByte(hex.substring(2, 4), 16), Byte.parseByte(hex.substring(4, 6), 16), Byte.parseByte(hex.substring(6, 8), 16)};
            return new String(b);
        }
    }
}

