/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kayo.io;

import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import jp.co.kayo.action.Chat;
import jp.co.kayo.io.PlayerRecord;
import jp.co.kayo.io.ReplayBlockHeader;
import jp.co.kayo.io.ReplayBuffer;
import jp.co.kayo.io.ReplayHeader;
import jp.co.kayo.io.ReplayRecord;
import jp.co.kayo.io.XMLUtil;
import org.w3c.dom.Document;

public class W3GReader {
    private ReplayRecord m_replay;
    private ReplayBuffer m_replayfile;
    private ReplayHeader m_header;

    public W3GReader(String filename) throws Exception {
        this.m_replayfile = new ReplayBuffer(filename);
        this.m_header = new ReplayHeader(this.m_replayfile);
        byte[] packdata = this.zunpack_data(this.m_replayfile, this.m_header.m_blocks);
        ReplayBuffer decompressed = new ReplayBuffer(ByteBuffer.wrap(packdata, 4, packdata.length - 4));
        this.m_replay = new ReplayRecord(decompressed);
    }

    public ReplayHeader getHeader() {
        return this.m_header;
    }

    public ReplayRecord getReplay() {
        return this.m_replay;
    }

    public Document getXML() throws Exception {
        StringBuffer xml = new StringBuffer().append("<Replay>");
        xml.append("<Basic>").append("<FileSize>").append(this.m_replayfile.getFilesize()).append("</FileSize>").append("<TimeStamp msec='").append(this.m_replayfile.getTimestamp()).append("' >").append(this.getFormatTime(this.m_replayfile.getTimestamp())).append("</TimeStamp>").append("<Version>").append(this.m_header.getMajorVer()).append("</Version>").append("<Build>").append(this.m_header.getBuild()).append("</Build>").append("<ReplayLength msec='").append(this.m_header.getGameTime()).append("' >").append(this.getFormatTime(this.m_header.getGameTime())).append("</ReplayLength>").append("<Map img='").append(this.m_replay.getMapImage()).append("' >").append(this.m_replay.getMapname()).append("</Map>").append("<Type>").append(this.m_replay.getType()).append("</Type>").append("<Creator>").append(this.m_replay.getCreator()).append("</Creator>").append("<StartSpot>").append(this.m_replay.getGamestartrecord().getStartspotcount()).append("</StartSpot>").append("</Basic>");
        xml.append("<PlayerList>");
        Iterator<Object> ite = this.m_replay.getPlayermap().values().iterator();
        while (ite.hasNext()) {
            PlayerRecord player = (PlayerRecord)ite.next();
            xml.append("<Player>").append("<ID>").append(player.getId()).append("</ID>").append("<Color>").append(player.getColor()).append("</Color>").append("<Name>").append(player.getName()).append("</Name>").append("<Controller>").append(player.getController()).append("</Controller>").append("<Race>").append(player.getRace()).append("</Race>").append("<Team>").append(player.getTeam()).append("</Team>").append("<Handicap>").append(player.getHandicap()).append("</Handicap>").append("<Actions>").append(player.getActioncount()).append("</Actions>").append("<APM>").append(player.getAPM()).append("</APM>").append("<TimePlayed msec='").append(player.getGametime()).append("' >").append(this.getFormatTime(player.getGametime())).append("</TimePlayed>").append("<TimeLogin msec='").append(player.getPlaytime()).append("' >").append(this.getFormatTime(player.getPlaytime())).append("</TimeLogin>");
            xml.append("<HeroOrder>");
            Iterator heros = player.getHeros();
            while (heros.hasNext()) {
                String hero = (String)heros.next();
                xml.append("<Hero>").append(hero).append("</Hero>");
            }
            xml.append("</HeroOrder>");
            xml.append("<HeroSkillOrder>");
            heros = player.getHeroskills();
            while (heros.hasNext()) {
                String skill = (String)heros.next();
                xml.append("<Skill>").append(skill).append("</Skill>");
            }
            xml.append("</HeroSkillOrder>");
            xml.append("</Player>");
        }
        xml.append("</PlayerList>");
        xml.append("<Chat>");
        ite = this.m_replay.getChats().iterator();
        while (ite.hasNext()) {
            Chat chat = (Chat)ite.next();
            xml.append(chat.toXML());
        }
        xml.append("</Chat>");
        xml.append("</Replay>");
        return XMLUtil.parse(xml.toString());
    }

    private String getFormatTime(long msec) {
        SimpleDateFormat df = null;
        df = msec > 86400000L ? new SimpleDateFormat("yyyy/MM/dd HH:mm:ss") : (msec > 3600000L ? new SimpleDateFormat("HH:mm:ss") : new SimpleDateFormat("mm:ss"));
        return df.format(new Date(msec));
    }

    private byte[] zunpack_data(ReplayBuffer replay, long blocknum) {
        byte[] data = null;
        int i = 0;
        while ((long)i < blocknum) {
            ReplayBlockHeader h = new ReplayBlockHeader(replay);
            byte[] tempdata = new byte[h.size];
            replay.get(tempdata, 0, h.size);
            int pos = 0;
            if (data == null) {
                data = new byte[h.uncomp_size];
            } else {
                pos = data.length;
                byte[] tmp = null;
                tmp = new byte[data.length + h.uncomp_size];
                System.arraycopy(data, 0, tmp, 0, data.length);
                data = tmp;
            }
            Inflater inflater = new Inflater();
            inflater.setInput(tempdata);
            try {
                inflater.inflate(data, pos, h.uncomp_size);
            }
            catch (DataFormatException e) {
                e.printStackTrace();
            }
            inflater.end();
            ++i;
        }
        return data == null ? new byte[]{} : data;
    }
}

