#!/bin/bash
SRC_ROOT=`pwd`
TEMP_DIR=${SRC_ROOT}/temp
BRANCH_TAG=cws_srx645_ooo111fix3
PREFIX=/opt
JV_HOME=/cygdrive/c/progra~1/java/j2sdk1.4.1_06
ANT_HOME=/usr/local/apache-ant-1.5.4
MingW32_HOME=/mingw
GPC_LOCATE=ftp://ftp.cs.man.ac.uk/pub/toby/gpc
GPC_ARCHIVE=gpc231.zip
HELPCONTENT_LOCATE=http://ftp.services.openoffice.org/pub/OpenOffice.org/contrib/helpcontent/
HELPCONTENT_ARCHIVE=helpcontent_81
CONFIG_OPT="--with-lang=JAPN --with-jdk-home=${JV_HOME} --with-dict=ALL"
LIBGCC=/usr/local/lib
PDF=${TEMP_DIR}/pdf

OSTYPE=`uname -s`
ARCH=`uname -p`

#CVS_UPDATE=True
SPLASH_REPLACE=True
SYMBOL_COPY=True
#USE_CCACHE=True
#USE_4NT=True
#CRASHDUMP=True
#USE_MINGWIN=True
USE_ORIGINALICON=True

# ==================================================
# OS Type & Java Home Directory & configure option Setting
# ==================================================

echo "OSTYPE is ${OSTYPE}."

if [ -e "${JV_HOME}" ]; then
    case ${OSTYPE} in
	Linux)
	    OS_TYPE=unx
	    CONFIG_OPT="${CONFIG_OPT} --enable-gcc3 --prefix=${PREFIX}"
	    ;;
	SunOS)
	    OS_TYPE=unx
	    CONFIG_OPT="${CONFIG_OPT} --prefix=${PREFIX}"
	    ;;
	CYGWIN*)
	    OS_TYPE=wnt
	    if [ ! "${USE_4NT}" = "True" ]; then
		CONFIG_OPT="${CONFIG_OPT} --with-use-shell=tcsh"
	    fi
	    if [ "${USE_MINGWIN}" = "True" ]; then
		CONFIG_OPT="${CONFIG_OPT} --with-mingwin=${MingW32_HOME}"
	    fi
	    if [ "${USE_ORIGINALICON}" = "True" ]; then
		cp -f ${TEMP_DIR}/OriginalIcon/* ${SRC_ROOT}/sysui/oowin32/office/icons
	    fi
	    ;;
    esac
else
    echo "Java Home Directory Not Found !!"
    exit 0
fi
if [ -e "${ANT_HOME}" ]; then
    CONFIG_OPT="${CONFIG_OPT} --with-ant-home=${ANT_HOME}"
fi
if [ "${CRASHDUMP}" = "True" ]; then
    CONFIG_OPT="${CONFIG_OPT} --enable-crashdump --enable-symbols=SMALL"
fi

# =================================================
# create a tempolary directory
# =================================================
echo "Creating tempolary directory."
mkdir -p ${TEMP_DIR}
mkdir -p ${TEMP_DIR}/help_${OS_TYPE}

# =================================================
# Download gpc and extract to ${SRC_ROOT}/external/gpc
# =================================================
cd ${TEMP_DIR}

if [ ! -f ${TEMP_DIR}/${GPC_ARCHIVE} ]; then
    echo "Getting GPC."
    wget ${GPC_LOCATE}/${GPC_ARCHIVE} -O ${TEMP_DIR}/${GPC_ARCHIVE}
fi

echo "Unpacking GPC."
unzip -o -d ${TEMP_DIR} ${TEMP_DIR}/${GPC_ARCHIVE}

echo "Moving GPC files."
cp -f ${TEMP_DIR}/`basename ${GPC_ARCHIVE} .zip`/gpc.c ${SRC_ROOT}/external/gpc
cp -f ${TEMP_DIR}/`basename ${GPC_ARCHIVE} .zip`/gpc.h ${SRC_ROOT}/external/gpc

echo "Cleaning up GPC."
rm -fr ${TEMP_DIR}/`basename ${GPC_ARCHIVE} .zip`

# ==================================================
# Download Japanese Help content and extract to ${SRC_ROOT}/helpcontent/${OS_TYPE}
# ==================================================
echo "Download, unpack and copying Japanges Help contents."
case ${OS_TYPE} in
    unx)
	if [ ! -f ${TEMP_DIR}/${HELPCONTENT_ARCHIVE}_unix.tgz ]; then
	    wget ${HELPCONTENT_LOCATE}/${HELPCONTENT_ARCHIVE}_unix.tgz -O ${TEMP_DIR}/${HELPCONTENT_ARCHIVE}_unix.tgz
	fi
	gzip -dc ${TEMP_DIR}/${HELPCONTENT_ARCHIVE}_unix.tgz|(cd ${TEMP_DIR}/help_${OS_TYPE};  tar xvf - )
	;;
    wnt)/usr/local/lib
	if [ ! -f ${TEMP_DIR}/${HELPCONTENT_ARCHIVE}_wnt.zip ]; then
	    wget ${HELPCONTENT_LOCATE}/${HELPCONTENT_ARCHIVE}_${OS_TYPE}.zip -O ${TEMP_DIR}/${HELPCONTENT_ARCHIVE}_${OS_TYPE}.zip
	fi
	unzip -o -d ${TEMP_DIR}/help_${OS_TYPE} ${TEMP_DIR}/${HELPCONTENT_ARCHIVE}_${OS_TYPE}.zip
	;;
esac

mkdir -p ${SRC_ROOT}/helpcontent/${OS_TYPE}/common/japanese
unzip -o -d ${SRC_ROOT}/helpcontent/${OS_TYPE}/common/japanese ${TEMP_DIR}/help_${OS_TYPE}/shared81.zip

mkdir -p ${SRC_ROOT}/helpcontent/${OS_TYPE}/swriter/japanese
unzip -o -d ${SRC_ROOT}/helpcontent/${OS_TYPE}/swriter/japanese ${TEMP_DIR}/help_${OS_TYPE}/swriter81.zip

mkdir -p ${SRC_ROOT}/helpcontent/${OS_TYPE}/scalc/japanese
unzip -o -d ${SRC_ROOT}/helpcontent/${OS_TYPE}/scalc/japanese ${TEMP_DIR}/help_${OS_TYPE}/scalc81.zip

mkdir -p ${SRC_ROOT}/helpcontent/${OS_TYPE}/schart/japanese
unzip -o -d ${SRC_ROOT}/helpcontent/${OS_TYPE}/schart/japanese ${TEMP_DIR}/help_${OS_TYPE}/schart81.zip

mkdir -p ${SRC_ROOT}/helpcontent/${OS_TYPE}/sbasic/japanese
unzip -o -d ${SRC_ROOT}/helpcontent/${OS_TYPE}/sbasic/japanese ${TEMP_DIR}/help_${OS_TYPE}/sbasic81.zip

mkdir -p ${SRC_ROOT}/helpcontent/${OS_TYPE}/smath/japanese
unzip -o -d ${SRC_ROOT}/helpcontent/${OS_TYPE}/smath/japanese ${TEMP_DIR}/help_${OS_TYPE}/smath81.zip

mkdir -p ${SRC_ROOT}/helpcontent/${OS_TYPE}/simpress/japanese
unzip -o -d ${SRC_ROOT}/helpcontent/${OS_TYPE}/simpress/japanese ${TEMP_DIR}/help_${OS_TYPE}/simpress81.zip

mkdir -p ${SRC_ROOT}/helpcontent/${OS_TYPE}/sdraw/japanese
unzip -o -d ${SRC_ROOT}/helpcontent/${OS_TYPE}/sdraw/japanese ${TEMP_DIR}/help_${OS_TYPE}/sdraw81.zip

cp -f ${TEMP_DIR}/help/common.tree ${SRC_ROOT}/helpcontent/${OS_TYPE}/common/japanese
cp -f ${TEMP_DIR}/help/schart.tree ${SRC_ROOT}/helpcontent/${OS_TYPE}/schart/japanese

echo "Clean up helpcontent"
rm -fr ${TEMP_DIR}/help_${OS_TYPE}

# ==================================================
# Copy InstallSet Require Files ${SRC_ROOT}/external
# ==================================================
echo "Copy InstallSet Require Files"
case ${OSTYPE} in
    CYGWIN*)
	cp -fv ${TEMP_DIR}/unicows/* ${SRC_ROOT}/external/unicows
	cp -fv ${TEMP_DIR}/dbghelp/* ${SRC_ROOT}/external/dbghelp
#	cp -fv ${TEMP_DIR}/msvcp70/* ${SRC_ROOT}/external/msvcp70
	mkdir ${SRC_ROOT}/external/msvcp71
	cp -fv ${TEMP_DIR}/msvcp71/* ${SRC_ROOT}/external/msvcp71
	;;
esac

# ==================================================
# Fixed Japanese original issues
# For the detail, see issue #10718
# ==================================================
cd ${SRC_ROOT}/extras/source/wordbook/lang
mkdir -p japanese
cp -f english_us/soffice.dic japanese

# ==================================================
# CVS Update
# ==================================================
if [ "${CVS_UPDATE}" = "True" ]; then
    echo "Updating source fiSRC_ROOTles from CVS."
    cd ${SRC_ROOT}
    for dir in *; do
        if [ -d ${dir} ] && [ -d ${dir}/CVS ]; then
            cd ${SRC_ROOT}/${dir}
            cvs update -dP -r ${BRANCH_TAG}
	    cd ${SRC_ROOT}
        fi
    done
fi

# ==================================================
# Splash Bitmap Replace from ${TEMP_DIR}/bmp/*.bmp to ${SRC_ROOT}/offmgr/res
# --------------------------------------------------
# intro bitmap : openintro.bmp, cjkintro.bmp, soffice.bmp
# about bitmap : openabout.bmp, cjkabout.bmp
# ==================================================
if [ "${SPLASH_REPLACE}" = "True" ]; then
    echo "Copying splash images."
    cp -f ${TEMP_DIR}/bmp/*.bmp ${SRC_ROOT}/offmgr/res
fi

# ==================================================
# Page Style Icon & PagePreview Icon
# Merge Cells Icon & Split Cells Icon
# Copy from ${TEMP_DIR}/icon/*.bmp to ${SRC_ROOT}/extras/source/symbols
# ==================================================
if [ "${SYMBOL_COPY}" = "True" ]; then
    echo "Copying symbols and icons."
    cp -f ${TEMP_DIR}/icon/*.bmp ${SRC_ROOT}/extras/source/symbols
fi

# ==================================================
# configure
# ==================================================
echo "Running configure script."
cd ${SRC_ROOT}/config_office
./configure ${CONFIG_OPT}

# ==================================================
# Set enviroment values and bootstrap
# ==================================================
cd ${SRC_ROOT}
echo

case ${OSTYPE} in
    Linux)
# Optional: use ccache to shorten compilation time
	if [ "${USE_CCACHE}" = "True" ]; then
	    sed -e 's/=\"gcc/=\"ccache gcc/' -e 's/=\"c++/=\"ccache c++/' -e 's/=\"g++/=\"ccache g++/' -e 's/LD_LIBRARY_PATH=\".:$SOLARENV/LD_LIBRARY_PATH=\".:\/usr\/local\/lib:$SOLARENV/' LinuxIntelEnv.Set.sh > ${TEMP_DIR}/LinuxIntelEnv.Set.sh
	    sed -e 's/=\"gcc/=\"ccache gcc/' -e 's/=\"c++/=\"ccache c++/' -e 's/=\"g++/=\"ccache g++/' -e 's/LD_LIBRARY_PATH \".:$SOLARENV/LD_LIBRARY_PATH \".:\/usr\/local\/lib:$SOLARENV/' LinuxIntelEnv.Set > ${TEMP_DIR}/LinuxIntelEnv.Set
	else
	    sed -e 's/LD_LIBRARY_PATH=\".:$SOLARENV/LD_LIBRARY_PATH=\".:\/usr\/local\/lib:$SOLARENV/' LinuxIntelEnv.Set.sh > ${TEMP_DIR}/LinuxIntelEnv.Set.sh
	    sed -e 's/LD_LIBRARY_PATH \".:$SOLARENV/LD_LIBRARY_PATH \".:\/usr\/local\/lib:$SOLARENV/' LinuxIntelEnv.Set > ${TEMP_DIR}/LinuxIntelEnv.Set
	fi
	mv -v -f ${TEMP_DIR}/LinuxIntelEnv.Set.sh ${SRC_ROOT}/LinuxIntelEnv.Set.sh
	mv -v -f ${TEMP_DIR}/LinuxIntelEnv.Set ${SRC_ROOT}/LinuxIntelEnv.Set
	echo "source ./LinuxIntelEnv.Set.sh"
	source ./LinuxIntelEnv.Set.sh
	echo "Bootstrapping."
	./bootstrap
	SOLVERLIB=`find ${SRC_ROOT}/solver -name inc | sed 's/inc/lib/'`
	mkdir -v ${SOLVERLIB}
	install -v -m644 ${LIBGCC}/libgcc_s.so.1 ${SOLVERLIB}
	install -v -m644 ${LIBGCC}/libstdc++.so.5 ${SOLVERLIB}
	SOLVERBIN=`find ${SRC_ROOT}/solver -name inc | sed 's/inc/bin/'`
	mkdir -v ${SOLVERBIN}
	install -v -m644 ${PDF}/InstGuide_111_linux_solaris.pdf ${SOLVERBIN}
	;;
    SunOS)
	cd ${SRC_ROOT}
	case ${ARCH} in
	    sparc)
		echo "source ./SolarisSparcEnv.Set.sh"
		source ./SolarisSparcEnv.Set.sh
		;;
	    i?86)
		echo "source ./SolarisIntelEnv.Set.sh"
		source ./SolarisIntelEnv.Set.sh
		;;
	esac
	echo "Bootstrapping."
	./bootstrap
	;;
    CYGWIN*)
	if [ ! "${USE_4NT}" = "True" ]; then
	    if [ "${USE_MINGWIN}" = "True" ]; then
# Optional: use ccache to shorten compilation time
		if [ "${USE_CCACHE}" = "True" ]; then
		    sed -e 's/=\"gcc /=\"ccache gcc /' -e 's/=\"c++ /=\"ccache c++ /' -e 's/=\"g++ /=\"ccache g++ /' winmingw.set.sh > ${TEMP_DIR}/winmingw.set.sh
		    sed -e 's/ \"gcc / \"ccache gcc /' -e 's/ \"c++ / \"ccache c++ /' -e 's/ \"g++/ \"ccache g++ /' winmingw.set > ${TEMP_DIR}/winmingw.set
		    sed -e 's/DMAKEROOT=\"$SOLARENVINC\/startup\"/DMAKEROOT=`cygpath -w \"$SOLARENVINC\/startup\"`/' ${TEMP_DIR}/winmingw.set.sh > ${SRC_ROOT}/winmingw.set.sh
		    sed -e 's/setenv DMAKEROOT \"$SOLARENVINC\/startup\"/setenv DMAKEROOT `cygpath -w \"$SOLARENVINC\/startup\"`/' ${TEMP_DIR}/winmingw.set > ${SRC_ROOT}/winmingw.set
		else
		    sed -e 's/DMAKEROOT=\"$SOLARENVINC\/startup\"/DMAKEROOT=`cygpath -w \"$SOLARENVINC\/startup\"`/' ${SRC_ROOT}/winmingw.set.sh > ${TEMP_DIR}/winmingw.set.sh
		    sed -e 's/setenv DMAKEROOT \"$SOLARENVINC\/startup\"/setenv DMAKEROOT `cygpath -w \"$SOLARENVINC\/startup\"`/' ${SRC_ROOT}/winmingw.set > ${TEMP_DIR}/winmingw.set
		    mv -v -f ${TEMP_DIR}/winmingw.set.sh ${SRC_ROOT}/winmingw.set.sh
		    mv -v -f ${TEMP_DIR}/winmingw.set ${SRC_ROOT}/winmingw.set
		fi

		cp -v ${SRC_ROOT}/psprint/util/libpsp_linux.map ${SRC_ROOT}/psprint/util/libpsp_mingw.map
		cp -v ${SRC_ROOT}/cppuhelper/source/gcc3_linux_intel.map ${SRC_ROOT}/cppuhelper/source/mingw.map
#		cp -v ${SRC_ROOT}/tools/source/fsys/wntmsc.hxx ${SRC_ROOT}/tools/source/fsys/wntgcc.hxx
		cp -v ${SRC_ROOT}/sal/systools/win32/uwinapi/unicows.dxp ${SRC_ROOT}/sal/systools/win32/uwinapi/unicows_mingw.dxp
		cp -v ${SRC_ROOT}/sal/systools/win32/uwinapi/uwinapi.dxp ${SRC_ROOT}/sal/systools/win32/uwinapi/uwinapi_mingw.dxp
		cp -vr ${SRC_ROOT}/bridges/source/cpp_uno/gcc3_linux_intel ${SRC_ROOT}/bridges/source/cpp_uno/mingw_intel

		echo "source ./winmingw.set.sh"
		source ./winmingw.set.sh
	    else
		echo "source ./winenv.set.sh"
		source ./winenv.set.sh
	    fi
	    echo "Bootstrapping."
	    ./bootstrap
	    SOLVERBIN=`find ${SRC_ROOT}/solver -name inc | sed 's/inc/bin/'`
	    mkdir -v ${SOLVERBIN}
	    install -v -m644 ${PDF}/InstGuide_111_win.pdf ${SOLVERBIN}
	fi
	;;
esac

# ==================================================
# Output the preparation finished
# ==================================================
echo 'The preparation completed.'
echo 'Please type dmake'
