/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.CurrentTransaction;
import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataDb;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.KeyRange;
import com.sleepycat.bdb.KeyRangeException;
import com.sleepycat.bdb.RecordNumberFormat;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbc;
import java.io.IOException;
import java.util.Collection;

public final class DataView
implements Cloneable {
    private static final KeyRange NULL_RANGE = new KeyRange();
    DataDb db;
    DataStore store;
    DataIndex index;
    KeyRange range;
    boolean writeAllowed;
    boolean dirtyRead;
    boolean transactional;
    boolean dirtyReadAllowed;
    boolean autoCommit;
    DataBinding keyBinding;
    DataBinding valueBinding;
    EntityBinding entityBinding;
    boolean recNumAccess;
    boolean btreeRecNumAccess;

    public DataView(DataStore dataStore, DataIndex dataIndex, DataBinding dataBinding, DataBinding dataBinding2, EntityBinding entityBinding, boolean bl) throws IllegalArgumentException {
        if (dataIndex != null) {
            this.db = dataIndex.db;
            this.index = dataIndex;
            this.store = dataIndex.store;
        } else {
            if (dataStore == null) {
                throw new IllegalArgumentException("both store and index are null");
            }
            this.db = dataStore.db;
            this.store = dataStore;
        }
        this.writeAllowed = bl;
        this.range = NULL_RANGE;
        this.keyBinding = dataBinding;
        this.valueBinding = dataBinding2;
        this.entityBinding = entityBinding;
        this.transactional = this.db.isTransactional();
        boolean bl2 = this.dirtyReadAllowed = !(!this.transactional || dataStore != null && !dataStore.db.isDirtyReadAllowed() || dataIndex != null && !dataIndex.db.isDirtyReadAllowed());
        if (dataBinding2 != null && entityBinding != null) {
            throw new IllegalArgumentException("both valueBinding and entityBinding are non-null");
        }
        if (dataBinding != null && dataBinding.getDataFormat() instanceof RecordNumberFormat) {
            if (!this.db.hasRecNumAccess()) {
                throw new IllegalArgumentException("RecordNumberFormat requires DB_BTREE/DB_RECNUM, DB_RECNO, or DB_QUEUE");
            }
            this.recNumAccess = true;
            if (this.db.type == 1) {
                this.btreeRecNumAccess = true;
            }
        }
        this.checkBindingFormats();
    }

    private DataView cloneView() {
        try {
            return (DataView)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public DataView keySetView() {
        if (this.keyBinding == null) {
            throw new UnsupportedOperationException("must have keyBinding");
        }
        DataView dataView = this.cloneView();
        dataView.valueBinding = null;
        dataView.entityBinding = null;
        return dataView;
    }

    public DataView valueSetView() {
        if (this.valueBinding == null && this.entityBinding == null) {
            throw new UnsupportedOperationException("must have valueBinding or entityBinding");
        }
        DataView dataView = this.cloneView();
        dataView.keyBinding = null;
        return dataView;
    }

    public DataView valueSetView(Object object) throws DbException, IOException, KeyRangeException {
        KeyRange keyRange = this.subRange(object);
        DataView dataView = this.valueSetView();
        dataView.range = keyRange;
        return dataView;
    }

    public DataView subView(Object object, boolean bl, Object object2, boolean bl2, DataBinding dataBinding) throws DbException, IOException, KeyRangeException {
        DataView dataView = this.cloneView();
        dataView.setRange(object, bl, object2, bl2);
        if (dataBinding != null) {
            dataView.keyBinding = dataBinding;
        }
        return dataView;
    }

    public DataView dirtyReadView(boolean bl) {
        if (!this.isDirtyReadAllowed()) {
            return this;
        }
        DataView dataView = this.cloneView();
        dataView.dirtyRead = bl;
        return dataView;
    }

    public DataView autoCommitView(boolean bl) {
        if (!this.isTransactional()) {
            return this;
        }
        DataView dataView = this.cloneView();
        dataView.autoCommit = bl;
        return dataView;
    }

    public CurrentTransaction getCurrentTxn() {
        return this.isTransactional() ? this.db.env : null;
    }

    private void setRange(Object object, boolean bl, Object object2, boolean bl2) throws DbException, IOException, KeyRangeException {
        this.range = this.subRange(object, bl, object2, bl2);
    }

    public DataThang getSingleKeyThang() {
        return this.range.getSingleKey();
    }

    public DataDb getDb() {
        return this.db;
    }

    public final DbEnv getEnv() {
        return this.db.env.getEnv();
    }

    public final boolean isAutoCommit() {
        return this.autoCommit || this.db.env.isAutoCommit();
    }

    public final DataStore getStore() {
        return this.store;
    }

    public final DataIndex getIndex() {
        return this.index;
    }

    public final DataBinding getKeyBinding() {
        return this.keyBinding;
    }

    public final DataBinding getValueBinding() {
        return this.valueBinding;
    }

    public final EntityBinding getValueEntityBinding() {
        return this.entityBinding;
    }

    public final boolean areDuplicatesAllowed() {
        return this.db.areDuplicatesAllowed();
    }

    public final boolean areDuplicatesOrdered() {
        return this.db.areDuplicatesOrdered();
    }

    public final boolean areKeysRenumbered() {
        return this.btreeRecNumAccess || this.db.areKeysRenumbered();
    }

    public final boolean isOrdered() {
        return this.db.isOrdered();
    }

    public final boolean isWriteAllowed() {
        return this.writeAllowed;
    }

    public final boolean isDirtyReadAllowed() {
        return this.dirtyReadAllowed;
    }

    public final boolean isDirtyReadEnabled() {
        return this.dirtyRead;
    }

    public final boolean isTransactional() {
        return this.transactional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() throws DbException, IOException {
        Dbc dbc = this.db.openCursor(false);
        try {
            int n;
            DataThang dataThang = DataThang.getDiscardDataThang();
            DataThang dataThang2 = this.range.hasBound() ? new DataThang() : dataThang;
            int n2 = Db.DB_FIRST;
            if (this.dirtyRead) {
                n2 |= Db.DB_DIRTY_READ;
            }
            boolean bl = (n = this.range.get(this.db, dbc, dataThang2, dataThang, n2)) != 0 && n != 12;
            return bl;
        }
        finally {
            this.db.closeCursor(dbc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(Object object, Object object2, int n, boolean bl, Object[] objectArray) throws DbException, IOException {
        if (n == 0) {
            n = Db.DB_SET;
        } else if (n != Db.DB_SET && n != Db.DB_GET_BOTH) {
            throw new IllegalArgumentException("flag not allowed");
        }
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this, false);
            int n2 = dataCursor.get(object, object2, n, bl);
            if (n2 == 0 && objectArray != null) {
                objectArray[0] = dataCursor.getCurrentValue();
            }
            int n3 = n2;
            return n3;
        }
        finally {
            if (dataCursor != null) {
                dataCursor.close();
            }
        }
    }

    public int consume(int n, Object[] objectArray, Object[] objectArray2) throws DbException, IOException {
        if (!this.writeAllowed) {
            throw new UnsupportedOperationException("write not allowed");
        }
        if (n != Db.DB_CONSUME && n != Db.DB_CONSUME_WAIT) {
            throw new IllegalArgumentException("flag not allowed");
        }
        DataThang dataThang = new DataThang();
        DataThang dataThang2 = new DataThang();
        int n2 = this.store.db.get(dataThang, dataThang2, n);
        if (n2 == 0) {
            this.store.applyChange(dataThang, dataThang2, null);
            this.returnPrimaryKeyAndValue(dataThang, dataThang2, objectArray, objectArray2);
        }
        return n2;
    }

    public int put(Object object, Object object2, int n, Object[] objectArray) throws DbException, IOException {
        if (!this.writeAllowed) {
            throw new UnsupportedOperationException("write not allowed");
        }
        if (n != 0 && n != Db.DB_NOOVERWRITE && n != Db.DB_NODUPDATA) {
            throw new IllegalArgumentException("flags not allowed: " + n);
        }
        if (this.index != null) {
            throw new UnsupportedOperationException("cannot put() with index");
        }
        if (objectArray != null) {
            objectArray[0] = null;
        }
        DataThang dataThang = new DataThang();
        DataThang dataThang2 = new DataThang();
        DataThang dataThang3 = null;
        int n2 = this.useKey(object, object2, dataThang, this.range);
        if (n2 != 0) {
            throw new IllegalArgumentException("primaryKey out of range " + dataThang + this.range);
        }
        if (n == 0 && !this.areDuplicatesAllowed()) {
            dataThang3 = new DataThang();
            n2 = this.store.db.get(dataThang, dataThang3, this.db.env.getWriteLockFlag());
            if (n2 == 0) {
                if (objectArray != null) {
                    objectArray[0] = this.makeValue(dataThang, dataThang3);
                }
            } else {
                dataThang3 = null;
            }
        }
        this.useValue(object2, dataThang2, null);
        n2 = this.store.db.put(dataThang, dataThang2, n);
        if (n2 == 0) {
            this.store.applyChange(dataThang, dataThang3, dataThang2);
        }
        return n2;
    }

    public int addValue(DataThang dataThang, Object object, int n) throws DbException, IOException {
        if (!this.writeAllowed) {
            throw new UnsupportedOperationException("write not allowed");
        }
        if (!this.areDuplicatesAllowed()) {
            throw new UnsupportedOperationException("duplicates required");
        }
        if (n != 0 && n != Db.DB_NODUPDATA && n != Db.DB_KEYFIRST && n != Db.DB_KEYLAST) {
            throw new IllegalArgumentException("flags not allowed: " + n);
        }
        DataThang dataThang2 = new DataThang();
        if (!this.range.check(dataThang)) {
            throw new IllegalArgumentException("primaryKey out of range");
        }
        this.useValue(object, dataThang2, null);
        int n2 = this.store.db.put(dataThang, dataThang2, n);
        if (n2 == 0) {
            this.store.applyChange(dataThang, null, dataThang2);
        }
        return n2;
    }

    public int append(Object object, Object[] objectArray, Object[] objectArray2) throws DbException, IOException {
        int n;
        if (!this.writeAllowed) {
            throw new UnsupportedOperationException("write not allowed");
        }
        DataThang dataThang = new DataThang();
        DataThang dataThang2 = new DataThang();
        if (this.store.keyAssigner != null) {
            this.store.keyAssigner.assignKey(dataThang);
            if (!this.range.check(dataThang)) {
                throw new IllegalArgumentException("assigned key out of range");
            }
            n = Db.DB_NOOVERWRITE;
        } else {
            if (this.db.type != 4 && this.db.type != 3) {
                throw new UnsupportedOperationException("DB_QUEUE or DB_RECNO type is required");
            }
            n = Db.DB_APPEND;
        }
        this.useValue(object, dataThang2, null);
        int n2 = this.store.db.put(dataThang, dataThang2, n);
        if (n2 == 0) {
            if (this.store.keyAssigner == null && !this.range.check(dataThang)) {
                this.store.db.delete(dataThang, 0);
                throw new IllegalArgumentException("appended record number out of range");
            }
            this.store.applyChange(dataThang, null, dataThang2);
            this.returnPrimaryKeyAndValue(dataThang, dataThang2, objectArray, objectArray2);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Collection collection) throws DbException, IOException {
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this, true);
            int n = this.areKeysRenumbered() ? Db.DB_FIRST : Db.DB_NEXT;
            int n2 = 0;
            while (n2 == 0) {
                n2 = dataCursor.get(null, null, n, true);
                if (n2 != 0) continue;
                if (collection != null) {
                    collection.add(dataCursor.getCurrentValue());
                }
                if ((n2 = dataCursor.delete()) == 0) continue;
                throw new DbException("Unexpected error on delete", n2);
            }
        }
        finally {
            if (dataCursor != null) {
                dataCursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCursor join(DataView[] dataViewArray, Object[] objectArray, boolean bl) throws DbException, IOException {
        DataCursor dataCursor;
        block9: {
            DataCursor dataCursor2 = null;
            DataCursor[] dataCursorArray = new DataCursor[dataViewArray.length];
            try {
                for (int i = 0; i < dataViewArray.length; ++i) {
                    dataCursorArray[i] = new DataCursor(dataViewArray[i], false);
                    dataCursorArray[i].get(objectArray[i], null, Db.DB_SET, false);
                }
                dataCursor = dataCursor2 = new DataCursor(this, dataCursorArray, bl, true);
                Object var8_8 = null;
                if (dataCursor2 != null) break block9;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (dataCursor2 == null) {
                    for (int i = 0; i < dataCursorArray.length; ++i) {
                        if (dataCursorArray[i] == null) continue;
                        try {
                            dataCursorArray[i].close();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < dataCursorArray.length; ++i) {
                if (dataCursorArray[i] == null) continue;
                try {
                    dataCursorArray[i].close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return dataCursor;
    }

    public DataCursor join(DataCursor[] dataCursorArray, boolean bl) throws DbException, IOException {
        return new DataCursor(this, dataCursorArray, bl, false);
    }

    private void returnPrimaryKeyAndValue(DataThang dataThang, DataThang dataThang2, Object[] objectArray, Object[] objectArray2) throws DbException, IOException {
        if (objectArray != null) {
            if (this.keyBinding == null) {
                throw new IllegalArgumentException("returning key requires primary key binding");
            }
            if (this.index != null) {
                throw new IllegalArgumentException("returning key requires unindexed view");
            }
            objectArray[0] = this.keyBinding.dataToObject(dataThang);
        }
        if (objectArray2 != null) {
            objectArray2[0] = this.makeValue(dataThang, dataThang2);
        }
    }

    int useKey(Object object, Object object2, DataThang dataThang, KeyRange keyRange) throws DbException, IOException {
        if (object != null) {
            if (this.keyBinding == null) {
                throw new IllegalArgumentException("non-null key with null key binding");
            }
            this.keyBinding.objectToData(object, dataThang);
        } else {
            if (object2 == null) {
                throw new IllegalArgumentException("null key and null value");
            }
            if (this.index == null) {
                if (this.entityBinding == null) {
                    throw new UnsupportedOperationException("null key, null index, and null entity binding");
                }
                this.entityBinding.objectToKey(object2, dataThang);
            } else {
                KeyExtractor keyExtractor = this.index.getKeyExtractor();
                DataThang dataThang2 = null;
                DataThang dataThang3 = null;
                if (this.entityBinding != null) {
                    if (keyExtractor.getPrimaryKeyFormat() != null) {
                        dataThang2 = new DataThang();
                        this.entityBinding.objectToKey(object2, dataThang2);
                    }
                    if (keyExtractor.getValueFormat() != null) {
                        dataThang3 = new DataThang();
                        this.entityBinding.objectToValue(object2, dataThang3);
                    }
                } else {
                    if (keyExtractor.getPrimaryKeyFormat() != null) {
                        throw new IllegalStateException("primary key needed by index extractor");
                    }
                    if (keyExtractor.getValueFormat() != null) {
                        dataThang3 = new DataThang();
                        this.valueBinding.objectToData(object2, dataThang3);
                    }
                }
                keyExtractor.extractIndexKey(dataThang2, dataThang3, dataThang);
            }
        }
        if (keyRange != null) {
            return keyRange.check(dataThang) ? 0 : -30990;
        }
        return 0;
    }

    public boolean canDeriveKeyFromValue() {
        if (this.index == null) {
            return this.entityBinding != null;
        }
        KeyExtractor keyExtractor = this.index.getKeyExtractor();
        if (keyExtractor.getPrimaryKeyFormat() != null && this.entityBinding == null) {
            return false;
        }
        return keyExtractor.getValueFormat() == null || this.entityBinding != null || this.valueBinding != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    void useValue(Object object, DataThang dataThang, DataThang dataThang2) throws DbException, IOException {
        if (object == null) {
            dataThang.set_data(new byte[0]);
            dataThang.set_offset(0);
            dataThang.set_size(0);
            return;
        }
        if (this.valueBinding != null) {
            this.valueBinding.objectToData(object, dataThang);
            return;
        }
        if (this.entityBinding == null) throw new IllegalArgumentException("non-null value with null value/entity binding");
        this.entityBinding.objectToValue(object, dataThang);
        if (dataThang2 == null) return;
        DataThang dataThang3 = new DataThang();
        this.entityBinding.objectToKey(object, dataThang3);
        if (dataThang3.equals(dataThang2)) return;
        throw new IllegalArgumentException("cannot change primary key");
    }

    Object makeKey(DataThang dataThang) throws DbException, IOException {
        if (dataThang.get_size() == 0) {
            return null;
        }
        return this.keyBinding.dataToObject(dataThang);
    }

    Object makeValue(DataThang dataThang, DataThang dataThang2) throws DbException, IOException {
        Object object;
        if (this.valueBinding != null) {
            object = this.valueBinding.dataToObject(dataThang2);
        } else if (this.entityBinding != null) {
            object = this.entityBinding.dataToObject(dataThang, dataThang2);
        } else {
            throw new UnsupportedOperationException("requires valueBinding or entityBinding");
        }
        return object;
    }

    KeyRange subRange(Object object) throws DbException, IOException, KeyRangeException {
        return this.range.subRange(this.makeRangeKey(object));
    }

    KeyRange subRange(Object object, boolean bl, Object object2, boolean bl2) throws DbException, IOException, KeyRangeException {
        if (object == object2 && bl && bl2) {
            return this.subRange(object);
        }
        if (!this.isOrdered()) {
            throw new UnsupportedOperationException("Cannot use key ranges on an unsorted database");
        }
        DataThang dataThang = object != null ? this.makeRangeKey(object) : null;
        DataThang dataThang2 = object2 != null ? this.makeRangeKey(object2) : null;
        return this.range.subRange(dataThang, bl, dataThang2, bl2);
    }

    private void checkBindingFormats() {
        if (this.keyBinding != null && !this.recNumAccess) {
            DataFormat dataFormat;
            DataFormat dataFormat2 = dataFormat = this.index != null ? this.index.keyFormat : this.store.keyFormat;
            if (!dataFormat.equals(this.keyBinding.getDataFormat())) {
                throw new IllegalArgumentException(this.db.toString() + " key binding format mismatch");
            }
        }
        if (this.valueBinding != null && !this.store.valueFormat.equals(this.valueBinding.getDataFormat())) {
            throw new IllegalArgumentException(this.store.toString() + " value binding format mismatch");
        }
        if (this.entityBinding != null) {
            if (!this.store.keyFormat.equals(this.entityBinding.getKeyFormat())) {
                throw new IllegalArgumentException(this.store.toString() + " value entity binding keyFormat mismatch");
            }
            if (!this.store.valueFormat.equals(this.entityBinding.getValueFormat())) {
                throw new IllegalArgumentException(this.store.toString() + " value entity binding valueFormat mismatch");
            }
        }
    }

    private DataThang makeRangeKey(Object object) throws DbException, IOException {
        DataThang dataThang = new DataThang();
        if (this.keyBinding != null) {
            this.useKey(object, null, dataThang, null);
        } else {
            this.useKey(null, object, dataThang, null);
        }
        return dataThang;
    }
}

