/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.serial;

import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.serial.ClassCatalog;
import com.sleepycat.bdb.bind.serial.SerialInput;
import com.sleepycat.bdb.bind.serial.SerialOutput;
import com.sleepycat.bdb.util.FastInputStream;
import com.sleepycat.bdb.util.FastOutputStream;
import com.sleepycat.bdb.util.IOExceptionWrapper;
import java.io.IOException;

public class SerialFormat
implements DataFormat {
    private ClassCatalog classCatalog;
    private Class baseClass;

    public SerialFormat(ClassCatalog classCatalog, Class clazz) {
        this.classCatalog = classCatalog;
        this.baseClass = clazz;
    }

    public final Class getBaseClass() {
        return this.baseClass;
    }

    public final Object dataToObject(DataBuffer dataBuffer) throws IOException {
        Object object = dataBuffer.getDataFormation();
        if (object != null) {
            return object;
        }
        int n = dataBuffer.getDataLength();
        byte[] byArray = SerialOutput.getStreamHeader();
        byte[] byArray2 = new byte[n + byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(dataBuffer.getDataBytes(), dataBuffer.getDataOffset(), byArray2, byArray.length, n);
        SerialInput serialInput = new SerialInput(new FastInputStream(byArray2, 0, byArray2.length), this.classCatalog);
        try {
            object = serialInput.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOExceptionWrapper(classNotFoundException);
        }
        dataBuffer.setDataFormation(object);
        return object;
    }

    public final void objectToData(Object object, DataBuffer dataBuffer) throws IOException {
        if (this.baseClass != null && !this.baseClass.isInstance(object)) {
            throw new IllegalArgumentException("Data object class (" + object.getClass() + ") not an instance of format's base class (" + this.baseClass + ')');
        }
        FastOutputStream fastOutputStream = new FastOutputStream();
        SerialOutput serialOutput = new SerialOutput(fastOutputStream, this.classCatalog);
        serialOutput.writeObject(object);
        byte[] byArray = SerialOutput.getStreamHeader();
        dataBuffer.setData(fastOutputStream.getBufferBytes(), byArray.length, fastOutputStream.getBufferLength() - byArray.length);
        dataBuffer.setDataFormation(object);
    }
}

