/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.serial;

import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.bind.serial.SerialFormat;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import java.io.IOException;

public abstract class TupleSerialBinding
implements EntityBinding {
    protected TupleFormat keyFormat;
    protected SerialFormat valueFormat;

    public TupleSerialBinding(TupleFormat tupleFormat, SerialFormat serialFormat) {
        this.keyFormat = tupleFormat;
        this.valueFormat = serialFormat;
    }

    public Object dataToObject(DataBuffer dataBuffer, DataBuffer dataBuffer2) throws IOException {
        return this.dataToObject(this.keyFormat.dataToInput(dataBuffer), this.valueFormat.dataToObject(dataBuffer2));
    }

    public void objectToKey(Object object, DataBuffer dataBuffer) throws IOException {
        TupleOutput tupleOutput = this.keyFormat.newOutput();
        this.objectToKey(object, tupleOutput);
        this.keyFormat.outputToData(tupleOutput, dataBuffer);
    }

    public void objectToValue(Object object, DataBuffer dataBuffer) throws IOException {
        object = this.objectToValue(object);
        this.valueFormat.objectToData(object, dataBuffer);
    }

    public DataFormat getKeyFormat() {
        return this.keyFormat;
    }

    public DataFormat getValueFormat() {
        return this.valueFormat;
    }

    public abstract Object dataToObject(TupleInput var1, Object var2) throws IOException;

    public abstract void objectToKey(Object var1, TupleOutput var2) throws IOException;

    public abstract Object objectToValue(Object var1) throws IOException;
}

