/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import java.io.IOException;

public abstract class TupleTupleKeyExtractor
implements KeyExtractor {
    protected TupleFormat primaryKeyFormat;
    protected TupleFormat valueFormat;
    protected TupleFormat indexKeyFormat;

    public TupleTupleKeyExtractor(TupleFormat tupleFormat, TupleFormat tupleFormat2, TupleFormat tupleFormat3) {
        this.primaryKeyFormat = tupleFormat;
        this.valueFormat = tupleFormat2;
        this.indexKeyFormat = tupleFormat3;
    }

    public DataFormat getPrimaryKeyFormat() {
        return this.primaryKeyFormat;
    }

    public DataFormat getValueFormat() {
        return this.valueFormat;
    }

    public DataFormat getIndexKeyFormat() {
        return this.indexKeyFormat;
    }

    public void extractIndexKey(DataBuffer dataBuffer, DataBuffer dataBuffer2, DataBuffer dataBuffer3) throws IOException {
        TupleOutput tupleOutput = this.indexKeyFormat.newOutput();
        TupleInput tupleInput = this.primaryKeyFormat != null ? this.primaryKeyFormat.dataToInput(dataBuffer) : null;
        TupleInput tupleInput2 = this.valueFormat != null ? this.valueFormat.dataToInput(dataBuffer2) : null;
        this.extractIndexKey(tupleInput, tupleInput2, tupleOutput);
        this.indexKeyFormat.outputToData(tupleOutput, dataBuffer3);
    }

    public void clearIndexKey(DataBuffer dataBuffer) throws IOException {
        TupleOutput tupleOutput = this.valueFormat.newOutput();
        this.clearIndexKey(this.valueFormat.dataToInput(dataBuffer), tupleOutput);
        this.valueFormat.outputToData(tupleOutput, dataBuffer);
    }

    public abstract void extractIndexKey(TupleInput var1, TupleInput var2, TupleOutput var3) throws IOException;

    public abstract void clearIndexKey(TupleInput var1, TupleOutput var2) throws IOException;
}

