/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.collection;

import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataView;
import com.sleepycat.bdb.KeyRangeException;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.collection.StoredContainer;
import com.sleepycat.bdb.collection.StoredEntrySet;
import com.sleepycat.bdb.collection.StoredIterator;
import com.sleepycat.bdb.collection.StoredKeySet;
import com.sleepycat.bdb.collection.StoredSortedEntrySet;
import com.sleepycat.bdb.collection.StoredSortedKeySet;
import com.sleepycat.bdb.collection.StoredSortedValueSet;
import com.sleepycat.bdb.collection.StoredValueSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StoredMap
extends StoredContainer
implements Map {
    private StoredKeySet keySet;
    private StoredEntrySet entrySet;
    private StoredValueSet valueSet;

    public StoredMap(DataStore dataStore, DataBinding dataBinding, DataBinding dataBinding2, boolean bl) {
        super(new DataView(dataStore, null, dataBinding, dataBinding2, null, bl));
    }

    protected Object clone() throws CloneNotSupportedException {
        StoredMap storedMap = (StoredMap)super.clone();
        storedMap.keySet = null;
        storedMap.entrySet = null;
        storedMap.valueSet = null;
        return storedMap;
    }

    public StoredMap(DataStore dataStore, DataBinding dataBinding, EntityBinding entityBinding, boolean bl) {
        super(new DataView(dataStore, null, dataBinding, null, entityBinding, bl));
    }

    public StoredMap(DataIndex dataIndex, DataBinding dataBinding, DataBinding dataBinding2, boolean bl) {
        super(new DataView(null, dataIndex, dataBinding, dataBinding2, null, bl));
    }

    public StoredMap(DataIndex dataIndex, DataBinding dataBinding, EntityBinding entityBinding, boolean bl) {
        super(new DataView(null, dataIndex, dataBinding, null, entityBinding, bl));
    }

    StoredMap(DataView dataView) {
        super(dataView);
    }

    public Object get(Object object) {
        return super.get(object);
    }

    public Object put(Object object, Object object2) {
        return super.put(object, object2);
    }

    public Object append(Object object) {
        boolean bl = this.beginAutoCommit();
        try {
            Object[] objectArray = new Object[1];
            this.view.append(object, objectArray, null);
            this.commitAutoCommit(bl);
            return objectArray[0];
        }
        catch (Exception exception) {
            throw this.handleException(exception, bl);
        }
    }

    public Object remove(Object object) {
        Object[] objectArray = new Object[1];
        this.removeKey(object, objectArray);
        return objectArray[0];
    }

    public boolean containsKey(Object object) {
        return super.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    public void putAll(Map map) {
        boolean bl = this.beginAutoCommit();
        Iterator iterator = null;
        try {
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.put(entry.getKey(), entry.getValue());
            }
            StoredIterator.close(iterator);
            this.commitAutoCommit(bl);
        }
        catch (Exception exception) {
            StoredIterator.close(iterator);
            throw this.handleException(exception, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        if (this.keySet == null) {
            StoredMap storedMap = this;
            synchronized (storedMap) {
                if (this.keySet == null) {
                    DataView dataView = this.view.keySetView();
                    this.keySet = this.isOrdered() ? new StoredSortedKeySet(dataView) : new StoredKeySet(dataView);
                }
            }
        }
        return this.keySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        if (this.entrySet == null) {
            StoredMap storedMap = this;
            synchronized (storedMap) {
                if (this.entrySet == null) {
                    this.entrySet = this.isOrdered() ? new StoredSortedEntrySet(this.view) : new StoredEntrySet(this.view);
                }
            }
        }
        return this.entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        if (this.valueSet == null) {
            StoredMap storedMap = this;
            synchronized (storedMap) {
                if (this.valueSet == null) {
                    DataView dataView = this.view.valueSetView();
                    this.valueSet = this.isOrdered() && dataView.canDeriveKeyFromValue() ? new StoredSortedValueSet(dataView) : new StoredValueSet(dataView);
                }
            }
        }
        return this.valueSet;
    }

    public Collection duplicates(Object object) {
        try {
            DataView dataView = this.view.valueSetView(object);
            return new StoredValueSet(dataView, true);
        }
        catch (KeyRangeException keyRangeException) {
            return Collections.EMPTY_SET;
        }
        catch (Exception exception) {
            throw StoredContainer.convertException(exception);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Map) {
            return ((Object)this.entrySet()).equals(((Map)object).entrySet());
        }
        return false;
    }

    public String toString() {
        return this.entrySet().toString();
    }
}

