/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jarpackager.util;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import org.netbeans.modules.jarpackager.ArchiveDescriptor;
import org.netbeans.modules.jarpackager.ContentMember;
import org.netbeans.modules.jarpackager.ContentMemberList;
import org.netbeans.modules.jarpackager.JarContent;
import org.netbeans.modules.jarpackager.JarDataObject;
import org.netbeans.modules.jarpackager.options.JarPackagerOption;
import org.openide.TopManager;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.NbClassPath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;

public final class JarUtils {
    public static final String MANIFEST_VERSION = "1.0";
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$jarpackager$JarDataObject;

    private JarUtils() {
    }

    public static boolean canAdd(ArchiveDescriptor archiveDescriptor, Node[] nodeArray, String string) {
        if (nodeArray.length == 0) {
            return false;
        }
        Node node = null;
        int n = 0;
        while (n < nodeArray.length) {
            node = nodeArray[n].getParentNode();
            if (node != null && node.getCookie(class$org$openide$loaders$DataFolder == null ? JarUtils.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder) == null && nodeArray[n].getCookie(class$org$openide$loaders$DataFolder == null ? JarUtils.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder) == null) {
                return false;
            }
            ++n;
        }
        DataObject dataObject = null;
        Object var6_6 = null;
        File file = string == null ? null : new File(string);
        FileSystem fileSystem = null;
        int n2 = 0;
        while (n2 < nodeArray.length) {
            dataObject = (DataObject)nodeArray[n2].getCookie(class$org$openide$loaders$DataObject == null ? JarUtils.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dataObject != null) {
                if (dataObject instanceof JarDataObject && JarUtils.isEqual(file, NbClassPath.toFile((FileObject)dataObject.getPrimaryFile()))) {
                    return false;
                }
                try {
                    fileSystem = dataObject.getPrimaryFile().getFileSystem();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    return false;
                }
                if (fileSystem instanceof JarFileSystem && JarUtils.isEqual(file, ((JarFileSystem)fileSystem).getJarFile())) {
                    return false;
                }
            } else {
                return false;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < nodeArray.length) {
            if (nodeArray[n3].getDisplayName().equalsIgnoreCase("META-INF")) {
                return false;
            }
            if (nodeArray[n3].getParentNode().getDisplayName() != null && nodeArray[n3].getParentNode().getDisplayName().equalsIgnoreCase("META-INF")) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private static boolean isEqual(File file, File file2) {
        int n;
        if (file == null) {
            return file2 == null;
        }
        if (file2 == null) {
            return file == null;
        }
        String string = file.getPath();
        String string2 = file2.getPath();
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            n2 = string.length();
        }
        if ((n = string2.lastIndexOf(46)) < 0) {
            n = string2.length();
        }
        return new File(string.substring(0, n2)).equals(new File(string2.substring(0, n)));
    }

    public static void addFileList(JarContent jarContent, Node[] nodeArray) {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(nodeArray.length * 2);
        DataObject dataObject = null;
        int n = 0;
        while (n < nodeArray.length) {
            dataObject = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? JarUtils.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dataObject != null) {
                arrayList.add(dataObject.getPrimaryFile());
            }
            ++n;
        }
        jarContent.putFiles(arrayList);
    }

    public static void removeFileList(JarContent jarContent, Node[] nodeArray) {
        DataObject dataObject = null;
        int n = 0;
        while (n < nodeArray.length) {
            dataObject = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? JarUtils.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dataObject != null) {
                jarContent.removeFile(dataObject.getPrimaryFile());
            }
            ++n;
        }
    }

    public static void addNodes(ArchiveDescriptor archiveDescriptor, Node[] nodeArray) {
        DataObject dataObject = null;
        ContentMemberList contentMemberList = archiveDescriptor.getContentList();
        int n = 0;
        while (n < nodeArray.length) {
            dataObject = (DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? JarUtils.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dataObject != null) {
                if (dataObject.getNodeDelegate().getDisplayName().length() == 0) {
                    dataObject.getNodeDelegate().setDisplayName(nodeArray[n].getDisplayName());
                }
            } else {
                throw new NullPointerException("Added node doesn't support DataObject cookie");
            }
            contentMemberList.addMember(dataObject);
            ++n;
        }
    }

    public static void removeNodes(ArchiveDescriptor archiveDescriptor, Node[] nodeArray) {
        ContentMemberList contentMemberList = archiveDescriptor.getContentList();
        Object var3_3 = null;
        int n = 0;
        while (n < nodeArray.length) {
            contentMemberList.removeMember((DataObject)nodeArray[n].getCookie(class$org$openide$loaders$DataObject == null ? JarUtils.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject));
            ++n;
        }
    }

    public static FileSystem addJarFSToRepository(File file, boolean bl) throws IOException, PropertyVetoException {
        Repository repository = TopManager.getDefault().getRepository();
        FileSystem fileSystem = JarUtils.getMountedJarFS(file);
        if (fileSystem == null) {
            JarFileSystem jarFileSystem = new JarFileSystem();
            jarFileSystem.setJarFile(file);
            repository.addFileSystem((FileSystem)jarFileSystem);
            return jarFileSystem;
        }
        return fileSystem;
    }

    public static FileSystem getMountedJarFS(File file) {
        Repository repository = TopManager.getDefault().getRepository();
        FileSystem[] fileSystemArray = repository.toArray();
        int n = 0;
        while (n < fileSystemArray.length) {
            if (fileSystemArray[n] instanceof JarFileSystem && file.equals(((JarFileSystem)fileSystemArray[n]).getJarFile())) {
                return fileSystemArray[n];
            }
            ++n;
        }
        return null;
    }

    public static JarContent jarContentFromNode(Node node) {
        JarDataObject jarDataObject = (JarDataObject)node.getCookie(class$org$netbeans$modules$jarpackager$JarDataObject == null ? (class$org$netbeans$modules$jarpackager$JarDataObject = JarUtils.class$("org.netbeans.modules.jarpackager.JarDataObject")) : class$org$netbeans$modules$jarpackager$JarDataObject);
        return jarDataObject != null ? jarDataObject.getJarContent() : null;
    }

    public static DataObject resolve(DataObject dataObject) {
        if (dataObject instanceof DataShadow) {
            return ((DataShadow)dataObject).getOriginal();
        }
        return dataObject;
    }

    public static CompilerJob createCompilerJob(ArchiveDescriptor archiveDescriptor, DataObject dataObject) {
        CompilerJobBuilder compilerJobBuilder = new CompilerJobBuilder();
        JarUtils.addToCompilerJob(compilerJobBuilder, archiveDescriptor, dataObject);
        return compilerJobBuilder.getJob();
    }

    private static void addToCompilerJob(CompilerJobBuilder compilerJobBuilder, ArchiveDescriptor archiveDescriptor, DataObject dataObject) {
        if (dataObject != null && !compilerJobBuilder.ignoreDataObject(dataObject)) {
            return;
        }
        ContentMemberList contentMemberList = archiveDescriptor.getContentList();
        int n = 0;
        while (n < contentMemberList.size()) {
            DataObject dataObject2 = ((ContentMember)contentMemberList.get(n)).getDataObject();
            compilerJobBuilder.addDataObject(dataObject2);
            ++n;
        }
    }

    public static String defaultContentName(ArchiveDescriptor archiveDescriptor) {
        String string = archiveDescriptor.getTargetResource().getFile();
        int n = string.lastIndexOf(".");
        if (n < 0) {
            n = string.length();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(0, n));
        stringBuffer.append(".");
        stringBuffer.append(JarPackagerOption.singleton().getContentExt());
        return stringBuffer.toString();
    }

    public static File urlToFile(URL uRL) {
        return new File(uRL.getFile());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class CompilerJobBuilder {
        private HashSet seen = new HashSet();
        private CompilerJob job = new CompilerJob(Compiler.DEPTH_INFINITE);
        static /* synthetic */ Class class$org$openide$loaders$DataFolder;
        static /* synthetic */ Class class$org$openide$cookies$CompilerCookie$Compile;

        CompilerJobBuilder() {
        }

        boolean ignoreDataObject(DataObject dataObject) {
            return this.seen.add(dataObject);
        }

        void addDataObject(DataObject dataObject) {
            if ((dataObject = JarUtils.resolve(dataObject)) == null || this.seen.contains(dataObject)) {
                return;
            }
            if (dataObject instanceof JarDataObject) {
                JarUtils.addToCompilerJob(this, ((JarDataObject)dataObject).getJarContent(), dataObject);
            } else {
                DataFolder dataFolder = (DataFolder)dataObject.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = CompilerJobBuilder.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                if (dataFolder == null) {
                    this.addScalarObjectToJob(dataObject);
                } else {
                    if (this.seen.contains(dataFolder)) {
                        return;
                    }
                    this.seen.add(dataFolder);
                    Enumeration enumeration = dataFolder.children();
                    while (enumeration.hasMoreElements()) {
                        DataObject dataObject2 = (DataObject)enumeration.nextElement();
                        this.addDataObject(dataObject2);
                    }
                }
            }
        }

        private void addScalarObjectToJob(DataObject dataObject) {
            this.seen.add(dataObject);
            CompilerCookie compilerCookie = (CompilerCookie)dataObject.getCookie(class$org$openide$cookies$CompilerCookie$Compile == null ? (class$org$openide$cookies$CompilerCookie$Compile = CompilerJobBuilder.class$("org.openide.cookies.CompilerCookie$Compile")) : class$org$openide$cookies$CompilerCookie$Compile);
            if (compilerCookie != null) {
                compilerCookie.addToJob(this.job, Compiler.DEPTH_INFINITE);
                if (dataObject instanceof JarDataObject) {
                    new Throwable().printStackTrace();
                }
            }
        }

        CompilerJob getJob() {
            return this.job;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

