/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.text.Keymap;
import org.openide.DialogDescriptor;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.Places;
import org.openide.ServiceType;
import org.openide.actions.ActionManager;
import org.openide.compiler.CompilationEngine;
import org.openide.cookies.ProjectCookie;
import org.openide.debugger.Debugger;
import org.openide.debugger.DebuggerNotFoundException;
import org.openide.execution.ExecutionEngine;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataLoaderPool;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.options.ControlPanel;
import org.openide.util.HelpCtx;
import org.openide.util.UserCancelException;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.openide.windows.WindowManager;

public abstract class TopManager {
    public static final String PROP_DEBUGGER = "debugger";
    public static final String PROP_GLOBAL_KEYMAP = "globalKeymap";
    public static final String PROP_PLACES = "places";
    private static TopManager defaultTopManager;

    public static TopManager getDefault() {
        if (defaultTopManager != null) {
            return defaultTopManager;
        }
        return TopManager.initializeTopManager();
    }

    public static void setDefault(TopManager topManager) throws SecurityException {
        throw new SecurityException();
    }

    public static synchronized boolean isInitialized() {
        return defaultTopManager != null;
    }

    private static synchronized TopManager initializeTopManager() {
        if (defaultTopManager != null) {
            return defaultTopManager;
        }
        String string = System.getProperty("org.openide.TopManager", "org.netbeans.core.Plain");
        try {
            Class<?> clazz = Class.forName(string);
            defaultTopManager = (TopManager)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new InternalError();
        }
        if (defaultTopManager instanceof Runnable) {
            ((Runnable)((Object)defaultTopManager)).run();
        }
        return defaultTopManager;
    }

    public abstract Repository getRepository();

    public abstract void showHelp(HelpCtx var1);

    public abstract void showUrl(URL var1);

    public abstract OutputWriter getStdOut();

    public InputOutput getIO(String string) {
        return this.getIO(string, true);
    }

    public abstract InputOutput getIO(String var1, boolean var2);

    public abstract ExClipboard getClipboard();

    public abstract ControlPanel getControlPanel();

    public abstract ServiceType.Registry getServices();

    public abstract ActionManager getActionManager();

    public void notifyException(Throwable throwable) {
        ErrorManager.getDefault().notify(throwable);
    }

    public abstract Object notify(NotifyDescriptor var1);

    public abstract Dialog createDialog(DialogDescriptor var1);

    public abstract void setStatusText(String var1);

    public abstract Keymap getGlobalKeymap();

    public CompilationEngine getCompilationEngine() {
        return CompilationEngine.getDefault();
    }

    public ExecutionEngine getExecutionEngine() {
        return ExecutionEngine.getDefault();
    }

    public abstract Debugger getDebugger() throws DebuggerNotFoundException;

    public abstract void saveAll();

    public abstract void exit();

    public abstract DataLoaderPool getLoaderPool();

    public abstract NodeOperation getNodeOperation();

    public abstract Places getPlaces();

    public abstract void openProject(ProjectCookie var1) throws IOException, UserCancelException;

    public ErrorManager getErrorManager() {
        return ErrorManager.getDefault();
    }

    public abstract WindowManager getWindowManager();

    public abstract ClassLoader systemClassLoader();

    public abstract ClassLoader currentClassLoader();

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    public static abstract class NodeOperation {
        public abstract boolean customize(Node var1);

        public abstract void explore(Node var1);

        public abstract void showProperties(Node var1);

        public abstract void showProperties(Node[] var1);

        public abstract Node[] select(String var1, String var2, Node var3, NodeAcceptor var4, Component var5) throws UserCancelException;

        public Node[] select(String string, String string2, Node node, NodeAcceptor nodeAcceptor) throws UserCancelException {
            return this.select(string, string2, node, nodeAcceptor, null);
        }

        public final Node select(String string, String string2, Node node) throws UserCancelException {
            return this.select(string, string2, node, new NodeAcceptor(this){
                private final /* synthetic */ NodeOperation this$0;
                {
                    this.this$0 = nodeOperation;
                }

                public boolean acceptNodes(Node[] nodeArray) {
                    return nodeArray.length == 1;
                }
            })[0];
        }
    }
}

