/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;
import org.openide.awt.EnabledButtonModel;
import org.openide.awt.ToolbarButtonUI;

public class ToolbarButton
extends JButton {
    static final long serialVersionUID = 6564434578524381134L;
    boolean disabled;

    public ToolbarButton(Icon icon) {
        super(null, icon);
        this.setModel(new EnabledButtonModel());
        this.setMargin(new Insets(2, 1, 0, 1));
    }

    public void updateUI() {
        this.setUI(UIManager.getLookAndFeel().getName().equals("Windows") ? ToolbarButtonUI.createUI(this) : UIManager.getUI(this));
    }

    public Icon getDisabledIcon() {
        if (!this.disabled) {
            this.setDisabledIcon(ToolbarButton.createDisabledIcon(this.getIcon()));
            this.disabled = true;
        }
        return super.getDisabledIcon();
    }

    public boolean isFocusTraversable() {
        return super.isFocusTraversable();
    }

    static Icon createDisabledIcon(Icon icon) {
        if (!(icon instanceof ImageIcon)) {
            return null;
        }
        ImageIcon imageIcon = (ImageIcon)icon;
        Image image = imageIcon.getImage();
        if (!(image instanceof BufferedImage)) {
            return null;
        }
        BufferedImage bufferedImage = (BufferedImage)image;
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = n * n2;
        int[] nArray = bufferedImage.getRGB(0, 0, n, n2, new int[n3], 0, n);
        GrayFilter grayFilter = new GrayFilter(true, 50);
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = grayFilter.filterRGB(0, 0, nArray[n4]);
            ++n4;
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        bufferedImage2.setRGB(0, 0, n, n2, nArray, 0, n);
        return new ImageIcon(bufferedImage2);
    }
}

