/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.datatransfer.Transferable;
import org.openide.nodes.Node;

final class ExplorerDnDManager {
    private static ExplorerDnDManager defaultDnDManager;
    private Node[] draggedNodes;
    private Transferable draggedTransForCut;
    private Transferable draggedTransForCopy;
    private boolean isDnDActive = false;
    private int allowedActions = 0;
    private int supportedActions = 0x40000003;

    private ExplorerDnDManager() {
    }

    static synchronized ExplorerDnDManager getDefault() {
        if (defaultDnDManager == null) {
            defaultDnDManager = new ExplorerDnDManager();
        }
        return defaultDnDManager;
    }

    void setDraggedNodes(Node[] nodeArray) {
        this.draggedNodes = nodeArray;
    }

    Node[] getDraggedNodes() {
        return this.draggedNodes;
    }

    void setDraggedTransferable(Transferable transferable, boolean bl) {
        if (bl) {
            this.draggedTransForCut = transferable;
        } else {
            this.draggedTransForCopy = transferable;
        }
    }

    Transferable getDraggedTransferable(boolean bl) {
        if (bl) {
            return this.draggedTransForCut;
        }
        return this.draggedTransForCopy;
    }

    void setAllowedDragActions(int n) {
        this.allowedActions = n;
    }

    int getAllowedDragActions() {
        if (this.allowedActions == 0) {
            return 0;
        }
        return this.allowedActions;
    }

    void setSupportedDragActions(int n) {
        this.supportedActions = n;
    }

    int getSupportedDragActions() {
        if (this.supportedActions == 0) {
            return 0;
        }
        return this.supportedActions;
    }

    void setDnDActive(boolean bl) {
        this.isDnDActive = bl;
    }

    boolean isDnDActive() {
        return this.isDnDActive;
    }
}

