/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import javax.swing.JList;
import org.openide.explorer.view.ExplorerDragSupport;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;

class ListViewDragSupport
extends ExplorerDragSupport {
    protected ListView view;
    protected JList list;

    public ListViewDragSupport(ListView listView, JList jList) {
        this.comp = jList;
        this.view = listView;
        this.list = jList;
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        super.dragGestureRecognized(dragGestureEvent);
    }

    Node[] obtainNodes(DragGestureEvent dragGestureEvent) {
        Point point = dragGestureEvent.getDragOrigin();
        int n = this.list.locationToIndex(dragGestureEvent.getDragOrigin());
        Object object = this.list.getModel().getElementAt(n);
        if (object instanceof VisualizerNode) {
            object = ((VisualizerNode)object).node;
        }
        if (n < 0) {
            return null;
        }
        if (!(object instanceof Node)) {
            return null;
        }
        Node[] nodeArray = null;
        if (this.list.isSelectedIndex(n)) {
            Object[] objectArray = this.list.getSelectedValues();
            nodeArray = new Node[objectArray.length];
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (objectArray[n2] instanceof VisualizerNode) {
                    nodeArray[n2] = ((VisualizerNode)objectArray[n2]).node;
                } else {
                    if (!(objectArray[n2] instanceof Node)) {
                        return null;
                    }
                    nodeArray[n2] = (Node)objectArray[n2];
                }
                ++n2;
            }
        } else {
            nodeArray = new Node[]{(Node)object};
        }
        return nodeArray;
    }
}

