/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.ErrorManager;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.AutoscrollSupport;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.explorer.view.TreeViewDragSupport;
import org.openide.explorer.view.TreeViewDropSupport;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;

public abstract class TreeView
extends JScrollPane {
    static final long serialVersionUID = -1639001987693376168L;
    private static final int TIME_TO_COLLAPSE = System.getProperty("netbeans.debug.heap") != null ? 0 : 15000;
    private static final int MIN_TREEVIEW_WIDTH = 400;
    private static final int MIN_TREEVIEW_HEIGHT = 400;
    protected transient JTree tree;
    transient NodeTreeModel treeModel;
    transient ExplorerManager manager;
    transient PopupSupport defaultActionListener;
    transient boolean defaultActionEnabled;
    transient PopupAdapter popupListener;
    transient TreePropertyListener managerListener = null;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    transient boolean dragActive = false;
    transient boolean dropActive = false;
    transient TreeViewDragSupport dragSupport;
    transient TreeViewDropSupport dropSupport;
    transient boolean dropTargetPopupAllowed = true;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$java$awt$event$ActionEvent;
    static /* synthetic */ Class class$org$openide$actions$PopupAction;

    public TreeView() {
        this(true, true);
    }

    public TreeView(boolean bl, boolean bl2) {
        this.initializeTree();
        if (DragDropUtilities.dragAndDropEnabled) {
            this.setDragSource(true);
            this.setDropTarget(true);
        }
        this.setPopupAllowed(bl2);
        this.setDefaultActionAllowed(bl);
        Dimension dimension = null;
        try {
            dimension = this.getPreferredSize();
            if (dimension == null) {
                dimension = new Dimension(400, 400);
            }
        }
        catch (NullPointerException nullPointerException) {
            dimension = new Dimension(400, 400);
        }
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        if (dimension.height < 400) {
            dimension.height = 400;
        }
        this.setPreferredSize(dimension);
    }

    void initializeTree() {
        this.treeModel = this.createModel();
        this.tree = new ExplorerTree(this.treeModel);
        NodeRenderer nodeRenderer = NodeRenderer.sharedInstance();
        this.tree.setCellRenderer(nodeRenderer);
        this.tree.setCellEditor(new TreeViewCellEditor(this.tree, new NodeRenderer.Tree()));
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.tree.setEditable(true);
        this.setViewportView(this.tree);
        this.setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.managerListener = new TreePropertyListener();
        this.tree.addTreeExpansionListener(this.managerListener);
        this.setRequestFocusEnabled(false);
        this.defaultActionListener = new PopupSupport();
        this.tree.addFocusListener(this.defaultActionListener);
        this.tree.addMouseListener(this.defaultActionListener);
    }

    public boolean isPopupAllowed() {
        return this.popupListener != null;
    }

    public void setPopupAllowed(boolean bl) {
        if (this.popupListener == null && bl) {
            this.popupListener = new PopupAdapter();
            this.tree.addMouseListener(this.popupListener);
            return;
        }
        if (this.popupListener != null && !bl) {
            this.tree.removeMouseListener(this.popupListener);
            this.popupListener = null;
            return;
        }
    }

    void setDropTargetPopupAllowed(boolean bl) {
        this.dropTargetPopupAllowed = bl;
        if (this.dropSupport != null) {
            this.dropSupport.setDropTargetPopupAllowed(bl);
        }
    }

    boolean isDropTargetPopupAllowed() {
        return this.dropSupport != null ? this.dropSupport.isDropTargetPopupAllowed() : this.dropTargetPopupAllowed;
    }

    public boolean isDefaultActionEnabled() {
        return this.defaultActionEnabled;
    }

    public void requestFocus() {
        this.tree.requestFocus();
    }

    public void setDefaultActionAllowed(boolean bl) {
        this.defaultActionEnabled = bl;
        if (bl) {
            this.tree.registerKeyboardAction(this.defaultActionListener, KeyStroke.getKeyStroke(10, 0, false), 0);
        } else {
            this.tree.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        }
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
        this.tree.setShowsRootHandles(!bl);
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean bl) {
        if (bl == this.dragActive) {
            return;
        }
        this.dragActive = bl;
        if (this.dragActive && this.dragSupport == null) {
            this.dragSupport = new TreeViewDragSupport(this, this.tree);
        }
        this.dragSupport.activate(this.dragActive);
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean bl) {
        if (bl == this.dropActive) {
            return;
        }
        this.dropActive = bl;
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new TreeViewDropSupport(this, this.tree, this.dropTargetPopupAllowed);
        }
        this.dropSupport.activate(this.dropActive);
    }

    public int getAllowedDragActions() {
        return 0x40000003;
    }

    public void setAllowedDragActions(int n) {
    }

    public int getAllowedDropActions() {
        return 0x40000003;
    }

    public void setAllowedDropActions(int n) {
    }

    public void collapseNode(Node node) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
        this.tree.collapsePath(treePath);
    }

    public void expandNode(Node node) {
        this.lookupExplorerManager();
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
        this.tree.expandPath(treePath);
    }

    public boolean isExpanded(Node node) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
        return this.tree.isExpanded(treePath);
    }

    public void expandAll() {
        int n;
        int n2 = 0;
        int n3 = this.tree.getRowCount();
        do {
            n = this.tree.getRowCount();
            this.tree.expandRow(n2);
        } while (n != this.tree.getRowCount() || ++n2 < this.tree.getRowCount());
    }

    public void addNotify() {
        super.addNotify();
        this.lookupExplorerManager();
    }

    private void lookupExplorerManager() {
        ExplorerManager explorerManager = ExplorerManager.find(this);
        if (explorerManager != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = explorerManager;
            this.wlvc = WeakListener.vetoableChange(this.managerListener, this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListener.propertyChange(this.managerListener, this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.synchronizeRootContext();
            this.synchronizeExploredContext();
            this.synchronizeSelectedNodes();
        }
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
        this.tree.getSelectionModel().addTreeSelectionListener(this.managerListener);
    }

    public void removeNotify() {
        super.removeNotify();
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
    }

    protected abstract NodeTreeModel createModel();

    protected abstract void selectionChanged(Node[] var1, ExplorerManager var2) throws PropertyVetoException;

    protected abstract boolean selectionAccept(Node[] var1);

    protected abstract void showPath(TreePath var1);

    protected abstract void showSelection(TreePath[] var1);

    protected boolean useExploredContextMenu() {
        return false;
    }

    private boolean isSelectionModeBroken(Node[] nodeArray) {
        int n;
        Object object;
        if (nodeArray.length <= 1 || this.getSelectionMode() == 4) {
            return false;
        }
        if (this.getSelectionMode() == 1) {
            return true;
        }
        TreePath[] treePathArray = new TreePath[nodeArray.length];
        RowMapper rowMapper = this.tree.getSelectionModel().getRowMapper();
        if (rowMapper == null) {
            return false;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(3);
        int n2 = 0;
        while (n2 < nodeArray.length) {
            TreePath treePath;
            arrayList.clear();
            object = nodeArray[n2];
            while (((Node)object).getParentNode() != null) {
                if (!this.isExpanded((Node)object)) {
                    arrayList.add(object);
                }
                object = ((Node)object).getParentNode();
            }
            n = arrayList.size() - 1;
            while (n >= 0) {
                this.expandNode((Node)arrayList.get(n));
                --n;
            }
            treePathArray[n2] = treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, nodeArray[n2])));
            ++n2;
        }
        object = rowMapper.getRowsForPaths(treePathArray);
        Arrays.sort((int[])object);
        n = 1;
        while (n < ((Object)object).length) {
            if (object[n] != object[n - 1] + true) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void callSelectionChanged(Node[] nodeArray) {
        this.manager.removePropertyChangeListener(this.wlpc);
        this.manager.removeVetoableChangeListener(this.wlvc);
        try {
            try {
                this.selectionChanged(nodeArray, this.manager);
            }
            catch (PropertyVetoException propertyVetoException) {
                this.synchronizeSelectedNodes();
                Object var4_3 = null;
                this.manager.addPropertyChangeListener(this.wlpc);
                this.manager.addVetoableChangeListener(this.wlvc);
            }
            Object var4_2 = null;
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
            throw throwable;
        }
    }

    final void synchronizeRootContext() {
        this.treeModel.setNode(this.manager.getRootContext());
    }

    final void synchronizeExploredContext() {
        Node node = this.manager.getExploredContext();
        if (node != null) {
            TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
            this.showPath(treePath);
        }
    }

    public void setSelectionMode(int n) {
        this.tree.getSelectionModel().setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this.tree.getSelectionModel().getSelectionMode();
    }

    final void synchronizeSelectedNodes() {
        Node[] nodeArray = this.manager.getSelectedNodes();
        TreePath[] treePathArray = new TreePath[nodeArray.length];
        int n = 0;
        while (n < nodeArray.length) {
            TreePath treePath;
            treePathArray[n] = treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, nodeArray[n])));
            ++n;
        }
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
        this.showSelection(treePathArray);
        this.tree.getSelectionModel().addTreeSelectionListener(this.managerListener);
    }

    void scrollTreeToVisible(TreePath treePath, TreeNode treeNode) {
        Rectangle rectangle = this.tree.getVisibleRect();
        Rectangle rectangle2 = this.tree.getPathBounds(treePath);
        Rectangle rectangle3 = this.tree.getPathBounds(new TreePath(this.treeModel.getPathToRoot(treeNode)));
        if (rectangle != null && rectangle2 != null && rectangle3 != null) {
            this.tree.scrollRectToVisible(new Rectangle(rectangle.x, rectangle2.y, 1, rectangle3.y - rectangle2.y + rectangle3.height));
        }
    }

    static boolean shouldPopupBeDisplayed(Component component) {
        try {
            Class<?> clazz = Class.forName("org.openide.windows.TopComponent$Registry");
            Object object = Lookup.getDefault().lookup(clazz);
            if (object == null) {
                return true;
            }
            Method method = clazz.getMethod("getActivated", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            boolean bl = SwingUtilities.isDescendingFrom(component, (Component)object2);
            if (bl) {
                return true;
            }
            Window window = SwingUtilities.getWindowAncestor(component);
            return window instanceof Dialog;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, exception);
            return true;
        }
    }

    private void createPopup(int n, int n2, JPopupMenu jPopupMenu) {
        if (jPopupMenu != null && jPopupMenu.getSubElements().length > 0 && TreeView.shouldPopupBeDisplayed(this)) {
            Point point;
            Point point2 = new Point(n, n2);
            JViewport jViewport = this.getViewport();
            Container container = this.tree.getParent();
            if (container != jViewport && container instanceof JViewport) {
                jViewport = (JViewport)container;
                point = this.getLocationOnScreen();
                Point point3 = jViewport.getLocationOnScreen();
                point2.x += point3.x - point.x;
                point2.y += point3.y - point.y;
            }
            point = jViewport.getViewPosition();
            point2.x -= point.x;
            point2.y -= point.y;
            jPopupMenu.show(this, point2.x, point2.y);
        }
    }

    void createPopup(int n, int n2) {
        if (this.isPopupAllowed()) {
            this.createPopup(n, n2, NodeOp.findContextMenu(this.manager.getSelectedNodes()));
        }
    }

    void createExtendedPopup(int n, int n2, JMenu jMenu) {
        JPopupMenu jPopupMenu = NodeOp.findContextMenu(this.manager.getSelectedNodes());
        int n3 = 0;
        if (jPopupMenu != null && (n3 = jPopupMenu.getComponentCount()) > 1) {
            jPopupMenu.insert(jMenu, n3 - 1);
            jPopupMenu.insert(new JPopupMenu.Separator(), n3);
        } else {
            if (jPopupMenu == null) {
                jPopupMenu = SystemAction.createPopupMenu(new SystemAction[0]);
            }
            jPopupMenu.add(jMenu);
        }
        this.createPopup(n, n2, jPopupMenu);
    }

    static void invokeAction(SystemAction systemAction, ActionEvent actionEvent) {
        Exception exception = null;
        try {
            Class<?> clazz = Class.forName("org.openide.actions.ActionManager");
            Object object = Lookup.getDefault().lookup(clazz);
            if (object != null) {
                Method method = clazz.getMethod("invokeAction", class$javax$swing$Action == null ? (class$javax$swing$Action = TreeView.class$("javax.swing.Action")) : class$javax$swing$Action, class$java$awt$event$ActionEvent == null ? (class$java$awt$event$ActionEvent = TreeView.class$("java.awt.event.ActionEvent")) : class$java$awt$event$ActionEvent);
                method.invoke(object, systemAction, actionEvent);
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
        }
        catch (LinkageError linkageError) {
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            exception = noSuchMethodException;
        }
        catch (IllegalAccessException illegalAccessException) {
            exception = illegalAccessException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exception = illegalArgumentException;
        }
        catch (InvocationTargetException invocationTargetException) {
            exception = invocationTargetException;
        }
        if (exception != null) {
            ErrorManager.getDefault().notify(1, exception);
        }
        systemAction.actionPerformed(actionEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class ExplorerTree
    extends JTree
    implements Autoscroll {
        AutoscrollSupport support;

        ExplorerTree(TreeModel treeModel) {
            super(treeModel);
            this.toggleClickCount = 0;
            if (System.getProperty("java.version").startsWith("1.4")) {
                this.getInputMap().put(KeyStroke.getKeyStroke("control C"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("control V"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("control X"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("COPY"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("PASTE"), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke("CUT"), "none");
            } else {
                this.getActionMap().put("cancel", new OurTreeCancelEditingAction());
            }
        }

        public void autoscroll(Point point) {
            this.getSupport().autoscroll(point);
        }

        public Insets getAutoscrollInsets() {
            return this.getSupport().getAutoscrollInsets();
        }

        AutoscrollSupport getSupport() {
            if (this.support == null) {
                this.support = new AutoscrollSupport(this, new Insets(15, 10, 15, 10));
            }
            return this.support;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (mouseEvent != null) {
                Point point = mouseEvent.getPoint();
                int n = this.getRowForLocation(point.x, point.y);
                if (n != -1) {
                    TreePath treePath = this.getPathForRow(n);
                    VisualizerNode visualizerNode = (VisualizerNode)treePath.getLastPathComponent();
                    String string = visualizerNode.getShortDescription();
                    String string2 = visualizerNode.displayName;
                    if (string != null && !string.equals(string2)) {
                        return string;
                    }
                }
            }
            return null;
        }

        protected TreeModelListener createTreeModelListener() {
            return new ModelHandler();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleExplorerTree();
            }
            return this.accessibleContext;
        }

        private class OurTreeCancelEditingAction
        extends AbstractAction {
            private OurTreeCancelEditingAction() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (((ExplorerTree)ExplorerTree.this).TreeView.this.tree != null) {
                    ((ExplorerTree)ExplorerTree.this).TreeView.this.tree.cancelEditing();
                }
            }

            public boolean isEnabled() {
                return ((ExplorerTree)ExplorerTree.this).TreeView.this.tree != null && ((ExplorerTree)ExplorerTree.this).TreeView.this.tree.isEnabled() && ExplorerTree.this.getUI().isEditing(((ExplorerTree)ExplorerTree.this).TreeView.this.tree);
            }
        }

        private class ModelHandler
        extends JTree.TreeModelHandler {
            ModelHandler() {
                super(ExplorerTree.this);
            }

            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TreePath[] treePathArray = ExplorerTree.this.getSelectionPaths();
                Enumeration<TreePath> enumeration = ExplorerTree.this.getExpandedDescendants(treeModelEvent.getTreePath());
                super.treeStructureChanged(treeModelEvent);
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        ExplorerTree.this.expandPath(enumeration.nextElement());
                    }
                }
                if (treePathArray != null && treePathArray.length > 0) {
                    boolean bl = ExplorerTree.this.isPathSelected(treePathArray[0]);
                    ExplorerTree.this.setSelectionPaths(treePathArray);
                    if (!bl) {
                        ExplorerTree.this.scrollPathToVisible(treePathArray[0]);
                    }
                }
            }
        }

        private class AccessibleExplorerTree
        extends JTree.AccessibleJTree {
            AccessibleExplorerTree() {
                super(ExplorerTree.this);
            }

            public String getAccessibleName() {
                return TreeView.this.getAccessibleContext().getAccessibleName();
            }

            public String getAccessibleDescription() {
                return TreeView.this.getAccessibleContext().getAccessibleDescription();
            }
        }
    }

    final class PopupSupport
    extends MouseAdapter
    implements ActionPerformer,
    Runnable,
    FocusListener,
    ActionListener {
        CallbackSystemAction csa;

        PopupSupport() {
        }

        public void performAction(SystemAction systemAction) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            int n = TreeView.this.tree.getLeadSelectionRow();
            if (n < 0) {
                return;
            }
            Rectangle rectangle = TreeView.this.tree.getRowBounds(n);
            if (rectangle == null) {
                return;
            }
            TreeView.this.createPopup(rectangle.x, rectangle.y);
        }

        public void focusGained(FocusEvent focusEvent) {
            if (this.csa == null) {
                this.csa = (CallbackSystemAction)SystemAction.get(class$org$openide$actions$PopupAction == null ? (class$org$openide$actions$PopupAction = TreeView.class$("org.openide.actions.PopupAction")) : class$org$openide$actions$PopupAction);
            }
            this.csa.setActionPerformer(this);
        }

        public void focusLost(FocusEvent focusEvent) {
            if (this.csa != null && this.csa.getActionPerformer() instanceof PopupSupport) {
                this.csa.setActionPerformer(null);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = TreeView.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n != -1 && SwingUtilities.isLeftMouseButton(mouseEvent) && MouseUtils.isDoubleClick(mouseEvent)) {
                TreePath treePath;
                Node node;
                SystemAction systemAction;
                if (TreeView.this.defaultActionEnabled && (systemAction = (node = Visualizer.findNode((treePath = TreeView.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())).getLastPathComponent())).getDefaultAction()) != null) {
                    TreeView.invokeAction(systemAction, new ActionEvent(node, 1001, ""));
                    mouseEvent.consume();
                    return;
                }
                if (TreeView.this.tree.isExpanded(n)) {
                    TreeView.this.tree.collapseRow(n);
                } else {
                    TreeView.this.tree.expandRow(n);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SystemAction systemAction;
            Node[] nodeArray = TreeView.this.manager.getSelectedNodes();
            if (nodeArray.length == 1 && (systemAction = nodeArray[0].getDefaultAction()) != null) {
                TreeView.invokeAction(systemAction, new ActionEvent(nodeArray[0], 1001, ""));
            }
        }
    }

    class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            int n = TreeView.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (!TreeView.this.tree.isRowSelected(n)) {
                TreeView.this.tree.setSelectionRow(n);
            }
            if (n != -1) {
                TreeView.this.createPopup(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class TreePropertyListener
    implements VetoableChangeListener,
    PropertyChangeListener,
    TreeExpansionListener,
    TreeSelectionListener,
    Runnable {
        private RequestProcessor.Task scheduled;
        private TreePath[] readAccessPaths;

        TreePropertyListener() {
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                if (TreeView.this.isSelectionModeBroken((Node[])propertyChangeEvent.getNewValue())) {
                    throw new PropertyVetoException("", propertyChangeEvent);
                }
                if (!TreeView.this.selectionAccept((Node[])propertyChangeEvent.getNewValue())) {
                    throw new PropertyVetoException("", propertyChangeEvent);
                }
            }
        }

        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (TreeView.this.manager == null) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                this.react2VisualPropChange(propertyChangeEvent);
            } else {
                SwingUtilities.invokeLater(new Runnable(this, propertyChangeEvent){
                    private final /* synthetic */ PropertyChangeEvent val$evt;
                    private final /* synthetic */ TreePropertyListener this$1;
                    {
                        this.this$1 = treePropertyListener;
                        this.val$evt = propertyChangeEvent;
                    }

                    public void run() {
                        TreePropertyListener.access$100(this.this$1, this.val$evt);
                    }
                });
            }
        }

        private void react2VisualPropChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("rootContext")) {
                TreeView.this.synchronizeRootContext();
            }
            if (propertyChangeEvent.getPropertyName().equals("exploredContext")) {
                TreeView.this.synchronizeExploredContext();
            }
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                TreeView.this.synchronizeSelectedNodes();
            }
        }

        public synchronized void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            RequestProcessor.Task task = this.scheduled;
            if (task != null) {
                task.cancel();
            }
            this.scheduled = RequestProcessor.getDefault().post(new Runnable(this, treePath){
                private final /* synthetic */ TreePath val$path;
                private final /* synthetic */ TreePropertyListener this$1;
                {
                    this.this$1 = treePropertyListener;
                    this.val$path = treePath;
                }

                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    if (!TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.isVisible(this.val$path)) {
                        return;
                    }
                    if (TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel == null) {
                        return;
                    }
                    TreeNode treeNode = (TreeNode)this.val$path.getLastPathComponent();
                    if (TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel.getPathToRoot(treeNode)[0] != TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel.getRoot()) {
                        return;
                    }
                    int n = treeNode.getChildCount() - 1;
                    if (n >= 0) {
                        TreeNode treeNode2 = treeNode.getChildAt(n);
                        Rectangle rectangle = TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.getVisibleRect();
                        Rectangle rectangle2 = TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.getPathBounds(this.val$path);
                        Rectangle rectangle3 = TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.getPathBounds(new TreePath(TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel.getPathToRoot(treeNode2)));
                        if (rectangle != null && rectangle2 != null && rectangle3 != null) {
                            TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.scrollRectToVisible(new Rectangle(rectangle.x, rectangle2.y, 1, rectangle3.y - rectangle2.y + rectangle3.height));
                        }
                    }
                }
            }, 250);
        }

        public synchronized void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            TreePath treePath = treeExpansionEvent.getPath();
            RequestProcessor.Task task = this.scheduled;
            if (task != null) {
                task.cancel();
            }
            this.scheduled = RequestProcessor.getDefault().post(new Runnable(this, treePath){
                private final /* synthetic */ TreePath val$path;
                private final /* synthetic */ TreePropertyListener this$1;
                {
                    this.this$1 = treePropertyListener;
                    this.val$path = treePath;
                }

                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    if (TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.isExpanded(this.val$path)) {
                        return;
                    }
                    if (!TreePropertyListener.access$200((TreePropertyListener)this.this$1).tree.isVisible(this.val$path)) {
                        return;
                    }
                    if (TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel == null) {
                        return;
                    }
                    TreeNode treeNode = (TreeNode)this.val$path.getLastPathComponent();
                    if (TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel.getPathToRoot(treeNode)[0] != TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel.getRoot()) {
                        return;
                    }
                    TreePropertyListener.access$200((TreePropertyListener)this.this$1).treeModel.nodeStructureChanged(treeNode);
                }
            }, TIME_TO_COLLAPSE);
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath[] treePathArray = TreeView.this.tree.getSelectionPaths();
            if (treePathArray == null) {
                TreeView.this.callSelectionChanged(new Node[0]);
            } else {
                this.readAccessPaths = treePathArray;
                Children.MUTEX.postReadRequest(this);
            }
        }

        public void run() {
            if (this.readAccessPaths == null) {
                return;
            }
            TreePath[] treePathArray = this.readAccessPaths;
            this.readAccessPaths = null;
            ArrayList<Node> arrayList = new ArrayList<Node>(treePathArray.length);
            int n = 0;
            while (n < treePathArray.length) {
                Node node = Visualizer.findNode(treePathArray[n].getLastPathComponent());
                if (node == TreeView.this.manager.getRootContext() || node.getParentNode() != null) {
                    arrayList.add(node);
                }
                ++n;
            }
            TreeView.this.callSelectionChanged(arrayList.toArray(new Node[arrayList.size()]));
        }

        static /* synthetic */ void access$100(TreePropertyListener treePropertyListener, PropertyChangeEvent propertyChangeEvent) {
            treePropertyListener.react2VisualPropChange(propertyChangeEvent);
        }

        static /* synthetic */ TreeView access$200(TreePropertyListener treePropertyListener) {
            return treePropertyListener.TreeView.this;
        }
    }
}

