/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.util.EventObject;
import org.openide.TopManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class OperationEvent
extends EventObject {
    static final int COPY = 1;
    static final int MOVE = 2;
    static final int DELETE = 3;
    static final int RENAME = 4;
    static final int SHADOW = 5;
    static final int TEMPL = 6;
    static final int CREATE = 7;
    private DataObject obj;
    static final long serialVersionUID = -3884037468317843808L;

    OperationEvent(DataObject dataObject) {
        super(TopManager.getDefault().getLoaderPool());
        this.obj = dataObject;
    }

    public DataObject getObject() {
        return this.obj;
    }

    public static final class Copy
    extends OperationEvent {
        private DataObject orig;
        static final long serialVersionUID = -2768331988864546290L;

        Copy(DataObject dataObject, DataObject dataObject2) {
            super(dataObject);
            this.orig = dataObject2;
        }

        public DataObject getOriginalDataObject() {
            return this.orig;
        }
    }

    public static final class Move
    extends OperationEvent {
        private FileObject file;
        static final long serialVersionUID = -7753279728025703632L;

        Move(DataObject dataObject, FileObject fileObject) {
            super(dataObject);
            this.file = fileObject;
        }

        public FileObject getOriginalPrimaryFile() {
            return this.file;
        }
    }

    public static final class Rename
    extends OperationEvent {
        private String name;
        static final long serialVersionUID = -1584168503454848519L;

        Rename(DataObject dataObject, String string) {
            super(dataObject);
            this.name = string;
        }

        public String getOriginalName() {
            return this.name;
        }
    }
}

