/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.openide.util.WeakListener;

class BackwardPosition
implements Position,
DocumentListener {
    private int offset;

    private BackwardPosition(int n) {
        this.offset = n;
    }

    public static Position create(Document document, int n) {
        BackwardPosition backwardPosition = new BackwardPosition(n);
        document.addDocumentListener(WeakListener.document(backwardPosition, document));
        return backwardPosition;
    }

    public int getOffset() {
        return this.offset;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getOffset() < this.offset) {
            this.offset += documentEvent.getLength();
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        int n = documentEvent.getOffset();
        if (n < this.offset) {
            this.offset -= documentEvent.getLength();
            if (this.offset < n) {
                this.offset = n;
            }
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }
}

