/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.Line;
import org.openide.text.LineListener;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.WeakListener;

public abstract class DocumentLine
extends Line {
    protected PositionRef pos;
    private boolean breakpoint;
    private transient boolean error;
    private transient boolean current;
    private transient LR listener;
    private transient DocumentListener docL;
    private static WeakHashMap assigned = new WeakHashMap(5);
    private List lineParts = new ArrayList(3);
    static final long serialVersionUID = 3213776466939427487L;

    public DocumentLine(DataObject dataObject, PositionRef positionRef) {
        super(dataObject);
        this.pos = positionRef;
    }

    void init() {
        this.listener = new LR();
        this.pos.getCloneableEditorSupport().addChangeListener(WeakListener.change(this.listener, this.pos.getCloneableEditorSupport()));
    }

    public int getLineNumber() {
        try {
            return this.pos.getLine();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public abstract void show(int var1, int var2);

    public void setBreakpoint(boolean bl) {
        if (this.breakpoint != bl) {
            this.breakpoint = bl;
            this.refreshState();
        }
    }

    public boolean isBreakpoint() {
        return this.breakpoint;
    }

    public void markError() {
        DocumentLine documentLine = this.registerLine(1, this);
        if (documentLine != null) {
            documentLine.error = false;
            documentLine.refreshState();
        }
        this.error = true;
        this.refreshState();
    }

    public void unmarkError() {
        this.error = false;
        this.registerLine(1, null);
        this.refreshState();
    }

    public void markCurrentLine() {
        DocumentLine documentLine = this.registerLine(0, this);
        if (documentLine != null) {
            documentLine.current = false;
            documentLine.refreshState();
        }
        this.current = true;
        this.refreshState();
    }

    public void unmarkCurrentLine() {
        this.current = false;
        this.registerLine(0, null);
        this.refreshState();
    }

    synchronized void refreshState() {
        StyledDocument styledDocument = this.pos.getCloneableEditorSupport().getDocument();
        if (styledDocument != null) {
            if (this.docL != null) {
                styledDocument.removeDocumentListener(this.docL);
            }
            if (this.error) {
                NbDocument.markError(styledDocument, this.pos.getOffset());
                this.docL = WeakListener.document(this.listener, styledDocument);
                styledDocument.addDocumentListener(this.docL);
                return;
            }
            if (this.current) {
                NbDocument.markCurrent(styledDocument, this.pos.getOffset());
                return;
            }
            if (this.breakpoint) {
                NbDocument.markBreakpoint(styledDocument, this.pos.getOffset());
                return;
            }
            NbDocument.markNormal(styledDocument, this.pos.getOffset());
            return;
        }
    }

    public int hashCode() {
        return this.pos.getCloneableEditorSupport().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DocumentLine) {
            DocumentLine documentLine = (DocumentLine)object;
            if (documentLine.pos.getCloneableEditorSupport() == this.pos.getCloneableEditorSupport()) {
                return documentLine.getLineNumber() == this.getLineNumber();
            }
        }
        return false;
    }

    private DocumentLine registerLine(int n, DocumentLine documentLine) {
        DocumentLine documentLine2;
        CloneableEditorSupport cloneableEditorSupport = this.pos.getCloneableEditorSupport();
        DocumentLine[] documentLineArray = (DocumentLine[])assigned.get(cloneableEditorSupport);
        if (documentLineArray != null) {
            documentLine2 = documentLineArray[n];
        } else {
            documentLineArray = new DocumentLine[2];
            assigned.put(cloneableEditorSupport, documentLineArray);
            documentLine2 = null;
        }
        documentLineArray[n] = documentLine;
        return documentLine2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.pos);
        objectOutputStream.writeBoolean(this.breakpoint);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pos = (PositionRef)objectInputStream.readObject();
        this.setBreakpoint(objectInputStream.readBoolean());
        this.lineParts = new ArrayList(3);
    }

    Object readResolve() throws ObjectStreamException {
        return this.pos.getCloneableEditorSupport().getLineSet().registerLine(this);
    }

    protected void addAnnotation(Annotation annotation) {
        super.addAnnotation(annotation);
        StyledDocument styledDocument = this.pos.getCloneableEditorSupport().getDocument();
        if (styledDocument == null) {
            return;
        }
        this.pos.getCloneableEditorSupport().prepareDocument().waitFinished();
        try {
            if (!annotation.isInDocument()) {
                annotation.setInDocument(true);
                NbDocument.addAnnotation(styledDocument, this.pos.getPosition(), -1, annotation);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(4096, iOException);
        }
    }

    protected void removeAnnotation(Annotation annotation) {
        super.removeAnnotation(annotation);
        StyledDocument styledDocument = this.pos.getCloneableEditorSupport().getDocument();
        if (styledDocument == null) {
            return;
        }
        this.pos.getCloneableEditorSupport().prepareDocument().waitFinished();
        if (annotation.isInDocument()) {
            annotation.setInDocument(false);
            NbDocument.removeAnnotation(styledDocument, annotation);
        }
    }

    void attachDetachAnnotations(StyledDocument styledDocument, boolean bl) {
        List list = this.getAnnotations();
        int n = 0;
        while (n < list.size()) {
            Annotation annotation = (Annotation)list.get(n);
            if (!bl) {
                try {
                    if (!annotation.isInDocument()) {
                        annotation.setInDocument(true);
                        NbDocument.addAnnotation(styledDocument, this.pos.getPosition(), -1, annotation);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(4096, iOException);
                }
            } else if (annotation.isInDocument()) {
                annotation.setInDocument(false);
                NbDocument.removeAnnotation(styledDocument, annotation);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.lineParts.size()) {
            ((Part)this.lineParts.get(n2)).attachDetachAnnotations(styledDocument, bl);
            ++n2;
        }
    }

    public String getText() {
        StyledDocument styledDocument = this.pos.getCloneableEditorSupport().getDocument();
        if (styledDocument == null) {
            return null;
        }
        int n = this.getLineNumber();
        int n2 = NbDocument.findLineOffset(styledDocument, n);
        int n3 = n + 1 >= NbDocument.findLineRootElement(styledDocument).getElementCount() ? styledDocument.getLength() : NbDocument.findLineOffset(styledDocument, n + 1);
        try {
            return styledDocument.getText(n2, n3 - n2);
        }
        catch (BadLocationException badLocationException) {
            ErrorManager.getDefault().notify(4096, badLocationException);
            return null;
        }
    }

    void addLinePart(Part part) {
        this.lineParts.add(part);
    }

    void moveLinePart(Part part, DocumentLine documentLine) {
        this.lineParts.remove(part);
        documentLine.addLinePart(part);
        part.changeLine(documentLine);
    }

    void notifyChange(DocumentEvent documentEvent, Set set, StyledDocument styledDocument) {
        int n = 0;
        while (n < this.lineParts.size()) {
            Part part = (Part)this.lineParts.get(n);
            part.handleDocumentChange(documentEvent);
            if (NbDocument.findLineNumber(styledDocument, part.getOffset()) != part.getLine().getLineNumber()) {
                DocumentLine documentLine = (DocumentLine)set.getCurrent(NbDocument.findLineNumber(styledDocument, part.getOffset()));
                this.moveLinePart(part, documentLine);
                continue;
            }
            ++n;
        }
    }

    void notifyMove() {
        this.updatePositionRef();
        int n = 0;
        while (n < this.lineParts.size()) {
            ((Part)this.lineParts.get(n)).firePropertyChange("line", null, null);
            ++n;
        }
    }

    private void updatePositionRef() {
        CloneableEditorSupport cloneableEditorSupport = this.pos.getCloneableEditorSupport();
        int n = NbDocument.findLineOffset(cloneableEditorSupport.getDocument(), this.getLineNumber());
        if (this.pos.getOffset() != n) {
            this.pos = new PositionRef(cloneableEditorSupport.getPositionManager(), n, Position.Bias.Forward);
        }
    }

    public static abstract class Set
    extends Line.Set {
        private final LineListener listener;
        private List list;

        public Set(StyledDocument styledDocument) {
            this(styledDocument, null);
        }

        Set(StyledDocument styledDocument, CloneableEditorSupport cloneableEditorSupport) {
            this.listener = new LineListener(styledDocument, cloneableEditorSupport);
        }

        void linesChanged(int n, int n2, DocumentEvent documentEvent) {
            List list = this.getLinesFromRange(n, n2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Line line = (Line)iterator.next();
                line.firePropertyChange("text", null, null);
                if (!(line instanceof DocumentLine)) continue;
                ((DocumentLine)line).notifyChange(documentEvent, this, this.listener.doc);
            }
        }

        void linesMoved(int n, int n2) {
            List list = this.getLinesFromRange(n, n2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Line line = (Line)iterator.next();
                line.firePropertyChange("lineNumber", null, null);
                if (!(line instanceof DocumentLine)) continue;
                ((DocumentLine)line).notifyMove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List getLinesFromRange(int n, int n2) {
            ArrayList<Line> arrayList = new ArrayList<Line>(10);
            Map map = this.lines;
            synchronized (map) {
                Iterator iterator = this.lines.keySet().iterator();
                while (iterator.hasNext()) {
                    Line line = (Line)iterator.next();
                    int n3 = line.getLineNumber();
                    if (n > n3 || n3 > n2) continue;
                    arrayList.add(line);
                }
            }
            return arrayList;
        }

        public List getLines() {
            if (this.list == null) {
                int n = this.listener.getOriginalLineCount();
                LinkedList<Line> linkedList = new LinkedList<Line>();
                int n2 = 0;
                while (n2 < n) {
                    linkedList.add(this.getOriginal(n2));
                    ++n2;
                }
                this.list = linkedList;
            }
            return this.list;
        }

        public Line getOriginal(int n) throws IndexOutOfBoundsException {
            int n2 = this.listener.getLine(n);
            int n3 = NbDocument.findLineOffset(this.listener.doc, n2);
            return this.registerLine(this.createLine(n3));
        }

        public Line getCurrent(int n) throws IndexOutOfBoundsException {
            int n2 = NbDocument.findLineOffset(this.listener.doc, n);
            return this.registerLine(this.createLine(n2));
        }

        protected abstract Line createLine(int var1);
    }

    private final class LR
    implements Runnable,
    ChangeListener,
    DocumentListener {
        private static final int REFRESH = 0;
        private static final int UNMARK = 1;
        private static final int ATTACH_DETACH = 2;
        private int actionId;
        private EnhancedChangeEvent ev;

        public LR() {
        }

        public LR(int n) {
            this.actionId = n;
        }

        public LR(EnhancedChangeEvent enhancedChangeEvent) {
            this.actionId = 2;
            this.ev = enhancedChangeEvent;
        }

        public void run() {
            switch (this.actionId) {
                case 0: {
                    DocumentLine.this.refreshState();
                    break;
                }
                case 1: {
                    DocumentLine.this.unmarkError();
                    break;
                }
                case 2: {
                    DocumentLine.this.attachDetachAnnotations(this.ev.getDocument(), this.ev.isClosingDocument());
                    this.ev = null;
                }
            }
        }

        private void invoke(int n) {
            SwingUtilities.invokeLater(new LR(n));
        }

        private void invoke(EnhancedChangeEvent enhancedChangeEvent) {
            SwingUtilities.invokeLater(new LR(enhancedChangeEvent));
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.invoke(0);
            this.invoke((EnhancedChangeEvent)changeEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.invoke(1);
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.invoke(1);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    static class Part
    extends Line.Part {
        private PositionRef position;
        private Line line;
        private int length;
        private int previousOffset;

        public Part(Line line, PositionRef positionRef, int n) {
            this.position = positionRef;
            this.line = line;
            this.length = n;
            this.previousOffset = positionRef.getOffset();
        }

        public int getColumn() {
            try {
                return this.position.getColumn();
            }
            catch (IOException iOException) {
                return 0;
            }
        }

        public int getLength() {
            return this.length;
        }

        public Line getLine() {
            return this.line;
        }

        int getOffset() {
            return this.position.getOffset();
        }

        void changeLine(Line line) {
            this.line = line;
            this.firePropertyChange("lineNumber", null, line);
        }

        protected void addAnnotation(Annotation annotation) {
            super.addAnnotation(annotation);
            StyledDocument styledDocument = this.position.getCloneableEditorSupport().getDocument();
            if (styledDocument == null) {
                return;
            }
            this.position.getCloneableEditorSupport().prepareDocument().waitFinished();
            try {
                if (!annotation.isInDocument()) {
                    annotation.setInDocument(true);
                    NbDocument.addAnnotation(styledDocument, this.position.getPosition(), this.length, annotation);
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(4096, iOException);
            }
        }

        protected void removeAnnotation(Annotation annotation) {
            super.removeAnnotation(annotation);
            StyledDocument styledDocument = this.position.getCloneableEditorSupport().getDocument();
            if (styledDocument == null) {
                return;
            }
            this.position.getCloneableEditorSupport().prepareDocument().waitFinished();
            if (annotation.isInDocument()) {
                annotation.setInDocument(false);
                NbDocument.removeAnnotation(styledDocument, annotation);
            }
        }

        public String getText() {
            StyledDocument styledDocument = this.position.getCloneableEditorSupport().getDocument();
            if (styledDocument == null) {
                return null;
            }
            try {
                return styledDocument.getText(this.position.getOffset(), this.getLength());
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify(4096, badLocationException);
                return null;
            }
        }

        void attachDetachAnnotations(StyledDocument styledDocument, boolean bl) {
            List list = this.getAnnotations();
            int n = 0;
            while (n < list.size()) {
                Annotation annotation = (Annotation)list.get(n);
                if (!bl) {
                    try {
                        if (!annotation.isInDocument()) {
                            annotation.setInDocument(true);
                            NbDocument.addAnnotation(styledDocument, this.position.getPosition(), this.getLength(), annotation);
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(4096, iOException);
                    }
                } else if (annotation.isInDocument()) {
                    annotation.setInDocument(false);
                    NbDocument.removeAnnotation(styledDocument, annotation);
                }
                ++n;
            }
        }

        void handleDocumentChange(DocumentEvent documentEvent) {
            if (documentEvent.getType().equals(DocumentEvent.EventType.INSERT) && documentEvent.getOffset() >= this.previousOffset && documentEvent.getOffset() < this.previousOffset + this.getLength()) {
                this.firePropertyChange("text", null, null);
            }
            if (documentEvent.getType().equals(DocumentEvent.EventType.REMOVE) && (documentEvent.getOffset() >= this.previousOffset && documentEvent.getOffset() < this.previousOffset + this.getLength() || documentEvent.getOffset() < this.previousOffset && documentEvent.getOffset() + documentEvent.getLength() > this.previousOffset)) {
                this.firePropertyChange("text", null, null);
            }
            if ((documentEvent.getType().equals(DocumentEvent.EventType.INSERT) || documentEvent.getType().equals(DocumentEvent.EventType.REMOVE)) && documentEvent.getOffset() < this.previousOffset) {
                this.firePropertyChange("column", null, null);
            }
            this.previousOffset = this.position.getOffset();
        }
    }
}

