/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.openide.TopManager;
import org.openide.util.Mutex;
import org.openide.util.WeakListener;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public abstract class CloneableOpenSupport {
    protected Env env;
    protected CloneableTopComponent.Ref allEditors;
    private static Container container;

    public CloneableOpenSupport(Env env) {
        this.env = env;
        Listener listener = new Listener(env);
        this.allEditors = listener;
        env.addPropertyChangeListener(WeakListener.propertyChange(listener, env));
        env.addVetoableChangeListener(WeakListener.vetoableChange(listener, env));
    }

    public void open() {
        Mutex.EVENT.writeAccess(new Runnable(){

            public void run() {
                CloneableTopComponent cloneableTopComponent = CloneableOpenSupport.this.openCloneableTopComponent();
                cloneableTopComponent.requestFocus();
            }
        });
    }

    public void view() {
        this.open();
    }

    public void edit() {
        this.open();
    }

    public boolean close() {
        return this.close(true);
    }

    protected boolean close(final boolean bl) {
        if (this.allEditors.isEmpty()) {
            return true;
        }
        Boolean bl2 = (Boolean)Mutex.EVENT.writeAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                Object object = CloneableOpenSupport.this.getLock();
                synchronized (object) {
                    if (bl && !CloneableOpenSupport.this.canClose()) {
                        return Boolean.FALSE;
                    }
                    Enumeration enumeration = CloneableOpenSupport.this.allEditors.getComponents();
                    while (enumeration.hasMoreElements()) {
                        TopComponent topComponent = (TopComponent)enumeration.nextElement();
                        if (topComponent.close()) continue;
                        return Boolean.FALSE;
                    }
                    return Boolean.TRUE;
                }
            }
        });
        return bl2;
    }

    protected boolean canClose() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final CloneableTopComponent openCloneableTopComponent() {
        Object object = this.getLock();
        synchronized (object) {
            try {
                CloneableTopComponent cloneableTopComponent = this.allEditors.getAnyComponent();
                cloneableTopComponent.open();
                return cloneableTopComponent;
            }
            catch (NoSuchElementException noSuchElementException) {
                String string = this.messageOpening();
                if (string != null) {
                    TopManager.getDefault().setStatusText(string);
                }
                CloneableTopComponent cloneableTopComponent = this.createCloneableTopComponent();
                cloneableTopComponent.setReference(this.allEditors);
                cloneableTopComponent.open();
                string = this.messageOpened();
                if (string == null) {
                    string = "";
                }
                TopManager.getDefault().setStatusText(string);
                return cloneableTopComponent;
            }
        }
    }

    private Object getLock() {
        if (container == null) {
            container = new Container();
        }
        return container.getTreeLock();
    }

    protected abstract CloneableTopComponent createCloneableTopComponent();

    protected abstract String messageOpening();

    protected abstract String messageOpened();

    private static final class Listener
    extends CloneableTopComponent.Ref
    implements PropertyChangeListener,
    VetoableChangeListener,
    Runnable {
        static final long serialVersionUID = -1934890789745432531L;
        private Env env;

        public Listener(Env env) {
            this.env = env;
        }

        private CloneableOpenSupport support() {
            return this.env.findCloneableOpenSupport();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                if (Boolean.FALSE.equals(propertyChangeEvent.getOldValue())) {
                    return;
                }
                Mutex.EVENT.readAccess(this);
            }
        }

        public void run() {
            CloneableOpenSupport cloneableOpenSupport = this.support();
            if (cloneableOpenSupport != null) {
                this.env.unmarkModified();
                cloneableOpenSupport.close(false);
            }
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("valid".equals(propertyChangeEvent.getPropertyName())) {
                CloneableOpenSupport cloneableOpenSupport;
                if (Boolean.FALSE.equals(propertyChangeEvent.getOldValue())) {
                    return;
                }
                if (this.env.isModified() && (cloneableOpenSupport = this.support()) != null && !cloneableOpenSupport.canClose()) {
                    throw new PropertyVetoException("", propertyChangeEvent);
                }
            }
        }

        public Object readResolve() {
            CloneableOpenSupport cloneableOpenSupport = this.support();
            if (cloneableOpenSupport == null) {
                return this;
            }
            return cloneableOpenSupport.allEditors;
        }
    }

    public static interface Env
    extends Serializable {
        public static final String PROP_VALID = "valid";
        public static final String PROP_MODIFIED = "modified";

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);

        public void addVetoableChangeListener(VetoableChangeListener var1);

        public void removeVetoableChangeListener(VetoableChangeListener var1);

        public boolean isValid();

        public boolean isModified();

        public void markModified() throws IOException;

        public void unmarkModified();

        public CloneableOpenSupport findCloneableOpenSupport();
    }
}

