/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.CommentHandler;
import com.jclark.xsl.sax.Destination;
import com.jclark.xsl.sax.OutputDocumentHandler;
import com.jclark.xsl.sax.RawCharactersHandler;
import java.io.IOException;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class Indenter
implements OutputDocumentHandler,
CommentHandler,
RawCharactersHandler {
    private DocumentHandler documentHandler = null;
    private CommentHandler commentHandler = null;
    private RawCharactersHandler rawCharactersHandler;
    private char[] newline = new char[]{'\n'};
    private static final byte IN_PCDATA_CHUNK = 0;
    private static final byte JUST_HAD_START_TAG = 1;
    private static final byte OTHER = 2;
    private byte state = 0;

    public Indenter(DocumentHandler documentHandler, RawCharactersHandler rawCharactersHandler) {
        this.documentHandler = documentHandler;
        this.commentHandler = documentHandler instanceof CommentHandler ? (CommentHandler)((Object)documentHandler) : null;
        this.rawCharactersHandler = rawCharactersHandler;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (n2 > 0) {
            this.documentHandler.characters(cArray, n, n2);
            this.state = 0;
        }
    }

    public void comment(String string) throws SAXException {
        if (this.commentHandler != null) {
            this.maybeNewline();
            this.commentHandler.comment(string);
        }
    }

    public void endDocument() throws SAXException {
        this.maybeNewline();
        this.documentHandler.endDocument();
    }

    public void endElement(String string) throws SAXException {
        if (this.state == 1) {
            this.state = (byte)2;
        } else {
            this.maybeNewline();
        }
        this.documentHandler.endElement(string);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (n2 > 0) {
            this.documentHandler.ignorableWhitespace(cArray, n, n2);
            this.state = 0;
        }
    }

    public DocumentHandler init(Destination destination, AttributeList attributeList) throws IOException, SAXException {
        if (this.documentHandler instanceof OutputDocumentHandler) {
            this.documentHandler = ((OutputDocumentHandler)this.documentHandler).init(destination, attributeList);
        }
        return this;
    }

    private final void maybeNewline() throws SAXException {
        if (this.state != 0) {
            this.documentHandler.characters(this.newline, 0, 1);
            this.newline[0] = 10;
        }
        this.state = (byte)2;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.maybeNewline();
        this.documentHandler.processingInstruction(string, string2);
    }

    public void rawCharacters(String string) throws SAXException {
        if (string.length() > 0) {
            this.rawCharactersHandler.rawCharacters(string);
            this.state = 0;
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.documentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        this.documentHandler.startDocument();
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        this.maybeNewline();
        this.state = 1;
        this.documentHandler.startElement(string, attributeList);
    }
}

